package org.openxml4j.samples.wordprocessingml;

import java.io.File;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openxml4j.document.wordprocessing.ParagraphAlignment;
import org.openxml4j.document.wordprocessing.WordDocument;
import org.openxml4j.document.wordprocessing.model.table.BorderStyle;
import org.openxml4j.document.wordprocessing.model.table.TableBorder;
import org.openxml4j.document.wordprocessing.model.table.TableCellSize;
import org.openxml4j.document.wordprocessing.model.table.TableDescription;
import org.openxml4j.document.wordprocessing.model.table.TableWidthType;
import org.openxml4j.exceptions.OpenXML4JException;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackageAccess;

/**
 * Demo : add a table in a WordML document.
 *
 * @author Julien Chable, CDubet
 * @version 1.0
 */
public class DemoListingBuildingTable {

	private static Logger logger = Logger.getLogger("org.openxml4j");

	private String testRoot; // The dir where the files are

	private String pathRootProject;

	public void init() {
		String packageName = getClass().getPackage().getName();
		// replace . by /
		String sep = File.separator;
		if (sep.equals("\\")) {
			// replaceAll wishes a regular expression, so give it
			sep = "\\\\";
		}
		pathRootProject=System.getProperty("user.dir")+File.separator+"src";
		testRoot=pathRootProject+File.separator+packageName.replaceAll("\\.", sep)+File.separator;

		PropertyConfigurator.configure(pathRootProject+File.separator+"config.log4j");	}

	/**
	 * Show how to build a table object for a word document
	 *
	 * @return The table ready for inserting in open XML
	 *
	 * @throws OpenXML4JException
	 */
	private TableDescription buildTestData() throws OpenXML4JException {
		// build the table info
		int nbCol = 3;
		TableDescription tableDesc = new TableDescription(
				ParagraphAlignment.LEFT);
		// do not use the standar border, make our own, color red, with -.-
		TableBorder border = new TableBorder(BorderStyle.BORDER_STYLE_DOT_DASH,
				8, "FF0000");
		tableDesc.setBorder(border);

		// build cells and lines
		for (int lineNo = 0; lineNo < 5; lineNo++) {
			ArrayList<String> line = new ArrayList<String>();
			for (int col = 0; col < nbCol; col++) {
				line.add(new String("line=" + lineNo + " col=" + col));
			}
			// (a table line can be as simple as a list of string)
			tableDesc.appendLine(line);
		}

		// make a special configuration for a cell
		// set the size of the cell (not automatically computed by MS-Word
		tableDesc.getCellAt(1, 2)
				.setCellSize(
						new TableCellSize(TableWidthType.TABLE_WIDTH_DXA,
								(short) 4096));

		tableDesc.getCellAt(1, 2).setCellBackgroundColor("FA0000"); // set a red
																	// background
		return tableDesc;
	}

	private void buildTable(String inputFile, String outputFile) {
		File destFile = new File(outputFile);

		try {
			Package pack = Package.open(inputFile, PackageAccess.READ_WRITE);
			WordDocument docx = new WordDocument(pack);

			TableDescription tableDesc = buildTestData();
			// ADD TABLE TO DOC
			docx.appendTable(tableDesc);
			docx.save(destFile);
		} catch (Exception e) {
			logger.error(e);
		}
	}

	public void demoBuildTable() {
		buildTable(testRoot + "Blank.docx", testRoot + "table_example.docx");
	}

	public static void main(String[] args) {
		DemoListingBuildingTable demoTable = new DemoListingBuildingTable();

		demoTable.init(); // init log4j and path

		try {
			demoTable.demoBuildTable();
		} catch (Exception e) {
			logger.error(e);
			e.printStackTrace();
		}
	}
}
