package org.openxml4j.samples.opc;

import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackageAccess;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.samples.DemoCore;

/**
 * Demo : list all the parts of a package.
 * 
 * @author Julien Chable
 * @version 1.0
 */
public class ListAllParts {

	public static void main(String[] args) throws Exception {
		DemoCore demoCore = new DemoCore();
		String filepath = demoCore.getTestRootPath() + "sample.docx";

		Package p = Package.open(filepath, PackageAccess.READ);
		for (PackagePart part : p.getParts())
			System.out.println(part.getPartName() + " -> "
					+ part.getContentType());
	}
}