/*
 * Copyright (c) 2006, Wygwam
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met: 
 * 
 * - Redistributions of source code must retain the above copyright notice, 
 * this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation and/or 
 * other materials provided with the distribution.
 * - Neither the name of Wygwam nor the names of its contributors may be 
 * used to endorse or promote products derived from this software without 
 * specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.openxml4j.samples.opc;

import org.openxml4j.exceptions.OpenXML4JException;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackageAccess;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.opc.PackageRelationship;
import org.openxml4j.opc.PackageRelationshipTypes;
import org.openxml4j.samples.DemoCore;

/**
 * Gets the core part URI.
 * 
 * @author Julien Chable
 * @version 1.0
 */
public class GetCorePart {

	public PackagePart getCorePartUri(String fileName) {
		try {
			// Open the package
			Package p = Package.open(fileName, PackageAccess.READ);

			// Gets the core part relationship
			PackageRelationship coreDocRelationship = p.getRelationshipsByType(
					PackageRelationshipTypes.CORE_DOCUMENT).getRelationship(0);

			// Get core part
			PackagePart corePart = p.getPart(coreDocRelationship);
			return corePart;
		} catch (OpenXML4JException e) {
			DemoCore.getLogger().debug(e.getMessage());
			return null;
		}
	}

	public static void main(String[] args) {
		DemoCore demoCore = new DemoCore();
		GetCorePart demo = new GetCorePart();

		String docPath;
		if (args.length == 1) {
			docPath = demoCore.getTestRootPath() + args[0];
		} else {
			docPath = demoCore.getTestRootPath() + "sample.docx";
		}

		// Retrieves core part
		PackagePart corePart = demo.getCorePartUri(docPath);
		if (corePart != null)
			System.out.println(corePart.getPartName() + " -> "
					+ corePart.getContentType());
		else
			System.out.println("The specified file is not valid !");
	}
}