package org.openxml4j.samples.opc;

import org.openxml4j.exceptions.OpenXML4JException;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackageAccess;
import org.openxml4j.opc.PackageProperties;
import org.openxml4j.samples.DemoCore;

/**
 * Demo : Extract package core properties.
 * 
 * @author Julien Chable
 * @version 0.1
 */
public class ExtractPackageCoreProperties {

	public static void main(String[] args) throws Exception {
		DemoCore demoCore = new DemoCore();

		String docPath;
		if (args.length == 1) {
			docPath = demoCore.getTestRootPath() + args[0];
		} else {
			docPath = demoCore.getTestRootPath() + "sample.docx";
		}

		try {
			// Open the package
			Package p = Package.open(docPath, PackageAccess.READ);

			// Gets the core properties
			PackageProperties props = p.getPackageProperties();
			DemoCore.getLogger().info(
					"Title: " + props.getTitleProperty().getValue());
			DemoCore.getLogger().info(
					"Creator: " + props.getCreatorProperty().getValue());
			DemoCore.getLogger().info(
					"Creation date: " + props.getCreatedProperty().getValue());
			DemoCore.getLogger().info(
					"Status: " + props.getContentStatusProperty().getValue());

			p.revert();
		} catch (OpenXML4JException e) {
			DemoCore.getLogger().debug(e.getMessage());
		}
	}
}
