package org.openxml4j.samples;

import java.io.File;

import org.openxml4j.document.OpenXMLDocument;
import org.openxml4j.exceptions.OpenXML4JException;
import org.openxml4j.opc.PackageAccess;

/**
 * Extract thumbnails of a document.
 * 
 * @author Julien Chable, CDubet
 * @version 1.1
 */
public class GetThumbnails {

	public static void main(String[] args) {
		DemoCore demoCore = new DemoCore();
		try {
			// Destination folder
			File destFile = new File(demoCore.getTestRootPath() + "export");

			// Open the package
			OpenXMLDocument docx = OpenXMLDocument.open(demoCore.getTestRootPath() + "sample.docx",
					PackageAccess.READ);

			// Extract available thumbnails
			docx.extractParts(docx.getThumbnails(), destFile);

			System.out.println("Thumbnail(s) successfully extracted !");
		} catch (OpenXML4JException e) {
			e.printStackTrace();
		}
	}
}
