package org.openxml4j.document.wordprocessing.model.table;

/**
 * Specifies the possible values for the units of the width property being
 * defined by a specific table width property.
 *
 * @author C Dubettier
 */

public class TableWidthType implements Comparable {
	// Ordinal of next DocumentStatus to be created
	private static int nextOrdinal = 0;

	// Assign an ordinal to this suit
	private final int ordinal = nextOrdinal++;

	private String name;
	private boolean requiredExplicitWidth; // value AUTO does not require a width, other do

	private TableWidthType(String name,boolean isWidthRequired) {
		this.name = name;
		requiredExplicitWidth=isWidthRequired;
	}

	public String toString() {
		return name;
	}

	/**
	 * @return open xml name (ie name in lower case)
	 */
	public String getOpenXmlName() {
		return name.toLowerCase();
	}

	public int compareTo(Object o) {
		return ordinal - ((TableWidthType) o).ordinal;
	}

	public boolean isRequiredExplicitWidth() {
		return requiredExplicitWidth;
	}
	//////////////////////////////////////////////////////////////////////////////////////////////////
	//
	//	JDK 1.4 like enum
	//

	/**
	 * Automatically determined width
	 */
	public static final TableWidthType TABLE_WIDTH_AUTO = new TableWidthType("AUTO",false);
	/**
	 *  No border
	 */
	public static final TableWidthType TABLE_WIDTH_NIL = new TableWidthType("NIL",true);
	/**
	 * Width in Fiftieths of a percent
	 */
	public static final TableWidthType TABLE_WIDTH_PCT = new TableWidthType("PCT",true);
	/**
	 *  Width in Twentieth of a Point
	 */
	public static final TableWidthType TABLE_WIDTH_DXA = new TableWidthType("DXA",true);


}