package org.openxml4j.document.wordprocessing.model.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;


import org.apache.log4j.Logger;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.openxml4j.document.wordprocessing.ParagraphAlignment;
import org.openxml4j.document.wordprocessing.WordDocument;
import org.openxml4j.document.wordprocessing.WordprocessingML;
import org.openxml4j.exceptions.OpenXML4JException;




/**
 * this class contains a line of a table
 *
 * @author CDubettier
 *
 */
public class TableLine {
	private static Logger  logger = Logger.getLogger("org.openxml4j");

	/**
	 * storage of cells in a line
	 */
//#ifdef JAVA5
	protected List<TableCell> cells;
//#else
/*
	protected List cells;
*/
//#endif

	/**
	 * convenient constructor, for a simple table creation
	 * @param listOfCells
	 * @param alignment
	 */
//#ifdef JAVA5
	public TableLine(List<String> listOfCells, ParagraphAlignment alignment) {
		cells=new ArrayList<TableCell> ();
//#else
/*
	public TableLine(List listOfCells, ParagraphAlignment alignment) {
		cells=new ArrayList();
*/
//#endif
		for (Iterator iter = listOfCells.iterator(); iter.hasNext();) {
			String cellElement = (String) iter.next();
			cells.add(new TableCell(cellElement,alignment));
		}

	}
	public TableLine() {
		cells=null;
	}

	/**
	 * create a line of cells with some cells merged horizontally
	 * @param listOfCells: list of CellWidth. show how many cells a cell should be merged with
	 *
	 * note: this function should be called just after constructor TableLine(), not after TableLine(List<String> listOfCells, ParagraphAlignment alignment)
	 * which already creates cells
	 */
//#ifdef JAVA5
	public void createLine(List<CellWidth> listOfCells) {
//#else
/*
	public void createLine(List listOfCells) {
*/
//#endif
		if (cells!=null) {
			//normally should not happen
			// this function should be called after TableLine(), not after TableLine(List<String> listOfCells, ParagraphAlignment alignment)
			logger.warn("erasing the contents of a line");
		}
//#ifdef JAVA5
		cells=new ArrayList<TableCell> ();
//#else
/*
		cells=new ArrayList();
*/
//#endif

		for (Iterator iter = listOfCells.iterator(); iter.hasNext();) {
			CellWidth cellWidth = (CellWidth) iter.next();
			cells.add(new TableCell(cellWidth));
		}

	}
	/**
	 * set a background color for a table line
	 *
	 * @param color in open XML format (ie RRGGBB)
	 */
	public void setBackgroundColor(String color) {
		for (Iterator iter = cells.iterator(); iter.hasNext();) {
			TableCell cellElement = (TableCell) iter.next();
			cellElement.setCellBackgroundColor(color);
		}
	}

	/**
	 * set all the text of a table line as bold
	 */
	public void setBold() {
		for (Iterator iter = cells.iterator(); iter.hasNext();) {
			TableCell cellElement = (TableCell) iter.next();
			cellElement.setBold(true);
		}
	}
	public void setAlignment(ParagraphAlignment alignment) {
		for (Iterator iter = cells.iterator(); iter.hasNext();) {
			TableCell cellElement = (TableCell) iter.next();
			cellElement.setAlignment(alignment);
		}
	}

	public Element build()  {
		/* build something like
		 * <w:tr>
            <w:tc>
                  <w:tcPr>
                  </w:tcPr>
                  <w:p >
                  <w:r>
							<w:t>Title 1</w:t>
						</w:r>
					</w:p>
            </w:tc>
            <w:tc>
                  ....
            </w:tc>
      	  </w:tr>
      	<w:tc>
		 */

		DocumentFactory factory=DocumentFactory.getInstance();
		Element lineAsXml=factory.createElement(new QName(WordprocessingML.TABLE_CELL_ROW, WordDocument.namespaceWord));

		// add the cells
		for (Iterator iter = cells.iterator(); iter.hasNext();) {
			TableCell element = (TableCell) iter.next();
			//add cell to table line
			lineAsXml.add(element.build());
		}
		return lineAsXml;
	}

	public TableCell getCell(int col) throws OpenXML4JException {
		if (col>=cells.size()) {
			String msg="col should be <"+ cells.size()+" col="+col;
			logger.error(msg);
			throw new OpenXML4JException(msg);
		}
//#ifdef JAVA5
		return cells.get(col);
//#else
/*
		return (TableCell) cells.get(col);
*/
//#endif
	}




}
