package org.openxml4j.document.wordprocessing.model.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.openxml4j.document.wordprocessing.ParagraphAlignment;
import org.openxml4j.document.wordprocessing.WordDocument;
import org.openxml4j.document.wordprocessing.WordprocessingML;
import org.openxml4j.exceptions.OpenXML4JException;

/**
 * This class should be use to describe a table that should be inserted in a word document
 * @author    CDubettier
 */
public class TableDescription {
	private static final String DEFAULT_COLOR_FOR_TABLE_HEADER = "a0aca3"; //light grey


	private static Logger  logger = Logger.getLogger("org.openxml4j");

	/**
	 * the storage for each line
	 */
//#ifdef JAVA5
	private List<TableLine> lines;
//#else
/*
	private List lines;
*/
//#endif
	private TableBorder border;

	/**
	 * alignment is stored here in order to avoid user to set it explicitely for each cell
	 */
	private ParagraphAlignment alignment;

	/**
	 * Auto width
	 */
	protected TableWidthType widthType =   TableWidthType.TABLE_WIDTH_AUTO;


	public TableDescription(ParagraphAlignment p_alignment) {
		alignment=p_alignment;
//#ifdef JAVA5
		lines=new ArrayList<TableLine> ();
//#else
/*
		lines=new ArrayList();
*/
//#endif
		//default border will be created (in build()) if none has been set
		// IoC pattern
	}


	/**
	 * get a specific cell of the table
	 * @param line
	 * @param col
	 * @return
	 * @throws OpenXML4JException
	 */
	public TableCell getCellAt(int line,int col) throws OpenXML4JException {
		//check parameter (col is check in getCell())
		if (line>=lines.size()) {
			String msg="line should be <"+ lines.size()+" line="+line;
			logger.error(msg);
			throw new OpenXML4JException(msg);
		}
//#ifdef JAVA5
		return lines.get(line).getCell(col);
//#else
/*
		return ((TableLine)lines.get(line)).getCell(col);
*/
//#endif
	}

	public TableWidthType getWidthType() {
		return widthType;
	}

	public void setWidthType(TableWidthType widthType) {
		this.widthType = widthType;
	}
	/**
	 * append a line in the table, when each cell is a string
	 * @param lineToAppend
	 *
	 * NOTE: for the moment a table cell can contain ONLY 1 run (the string)
	 */
//#ifdef JAVA5
	public void appendLine(List<String>lineToAppend) {
//#else
/*
	public void appendLine(List lineToAppend) {
*/
//#endif
		lines.add(new TableLine(lineToAppend,alignment));
	}

//#ifdef JAVA5
	public void appendBlankLine(List<CellWidth> listOfCells) {
//#else
/*
	public void appendBlankLine(List listOfCells) {
*/
//#endif
		TableLine line=new TableLine();
		line.createLine(listOfCells);
		line.setAlignment(alignment);
		lines.add(line);
	}
	/**
	 * convenient function
	 * format a table to have the first line as "heading" (bold character, grey background)
	 *
	 * Note: this function should be used once the table has been filled !
	 */
	public void formatAsTableWithHeading() {
		if (lines.size()==0) {
			//nothing to do, empty
			logger.debug("nothing to format, table empty");
			return;
		}
		//get the header
//#ifdef JAVA5
		TableLine line = lines.get(0);
//#else
/*
		TableLine line = (TableLine) lines.get(0);
*/
//#endif
		line.setBackgroundColor(DEFAULT_COLOR_FOR_TABLE_HEADER);
		line.setBold();
	}


	public int getNbline() {
		return lines.size();
	}


	/**
	 * @param alignment   the alignment to set
	 * @uml.property  name="alignment"
	 */
	public void setAlignment(ParagraphAlignment alignment) {
		this.alignment=alignment;
	}
	/**
	 * @return   the alignment
	 * @uml.property  name="alignment"
	 */
	public ParagraphAlignment getAlignment() {
		return alignment;
	}

	private Element buildColumnSize() {
		//default table width for the moment
		//TODO implement something for table size if needed

		DocumentFactory factory=DocumentFactory.getInstance();
		Element columnSizeXml=factory.createElement(new QName(WordprocessingML.TABLE_PROPERTIES_PREFRED_TABLE_WIDTH, WordDocument.namespaceWord));
		columnSizeXml.addAttribute(new QName(WordprocessingML.TABLE_CELL_WIDTH_VALUE, WordDocument.namespaceWord), "0");//TODO hard coded

		//alignment
		// w:type="auto"
		//TODO rename TABLE_CELL_WIDTH_TYPE as it is also used here
		columnSizeXml.addAttribute(new QName(WordprocessingML.TABLE_CELL_WIDTH_TYPE, WordDocument.namespaceWord),widthType.getOpenXmlName());
		return columnSizeXml;
	}

	public Element build()  {
		DocumentFactory factory=DocumentFactory.getInstance();
		Element tableAsNode=factory.createElement(new QName(WordprocessingML.TABLE_BODY_TAG_NAME, WordDocument.namespaceWord));


		Element tableProperties =tableAsNode.addElement(new QName(WordprocessingML.TABLE_PROPERTIES_TAG_NAME, WordDocument.namespaceWord));

		if (border==null) {
			// build a default border
			border=new TableBorder();
		}
		border.build(  tableProperties ); // table border
		// add properties like column size
		tableProperties.add(buildColumnSize());

		//end of properties, now add each line
		for (Iterator iter = lines.iterator(); iter.hasNext();) {
			TableLine line = (TableLine) iter.next();
			tableAsNode.add(line.build());
		}
		return tableAsNode;
	}

	/**
	 * use this method if you wish custom border
	 * @param  border
	 * @uml.property  name="border"
	 */
	public void setBorder(TableBorder border) {
		this.border = border;
	}
}
