package org.openxml4j.document.wordprocessing.model.table;

import org.dom4j.Element;
import org.dom4j.QName;
import org.openxml4j.document.wordprocessing.WordDocument;
import org.openxml4j.document.wordprocessing.WordprocessingML;


/**
 * @author CDubettier
 *
 * storage class for defining a cell size
 * If the size is set as Auto, MS-Word will compute itself the size fo the row
 */
public class TableCellSize {
	private TableWidthType widthType ;
	private short width ;

	public TableCellSize(TableWidthType widthType, short width) {
		this.widthType = widthType;
		this.width = width;
	}

	public TableCellSize() {
		//no predefined setting -> ask MS-Word to do the job
		widthType = TableWidthType.TABLE_WIDTH_AUTO;
		width = 0;
	}

	public short getWidth() {
		return width;
	}
	public void setWidth(short width) {
		this.width = width;
	}
	public TableWidthType getWidthType() {
		return widthType;
	}
	public void setWidthType(TableWidthType widthType) {
		this.widthType = widthType;
	}

	public void build(Element cellProperties) {
		// if the cell has a specif size, set it
		if (widthType.isRequiredExplicitWidth()) {
			Element widthPropertyElement= cellProperties.addElement(new QName(WordprocessingML.TABLE_CELL_WIDTH, WordDocument.namespaceWord));
			widthPropertyElement.addAttribute(new QName(WordprocessingML.TABLE_CELL_WIDTH_VALUE, WordDocument.namespaceWord), Short.toString(width));
			widthPropertyElement.addAttribute(new QName(WordprocessingML.TABLE_CELL_WIDTH_TYPE, WordDocument.namespaceWord),widthType.getOpenXmlName());

		}
	}
}
