package org.openxml4j.document.wordprocessing.model.table;

import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.openxml4j.document.wordprocessing.Paragraph;
import org.openxml4j.document.wordprocessing.ParagraphAlignment;
import org.openxml4j.document.wordprocessing.ParagraphBuilder;
import org.openxml4j.document.wordprocessing.UnderlineStyle;
import org.openxml4j.document.wordprocessing.WordDocument;
import org.openxml4j.document.wordprocessing.WordprocessingML;


/**
 * cell in a table For the moment a cell is a text (no image) and should fit in 1 paragraph
 * @author    CDubettier
 */
public class TableCell {
	private static Logger  logger = Logger.getLogger("org.openxml4j");

	/**
	 * text value of the cell
	 */
	private String value=null;

	/**
	 */
	private String cellBackgroundColor=null; //cell color in openXml format (ie RRGGBB in hex)

	/**
	 * size of the cell in points or other MS-Word units
	 */
	private TableCellSize cellSize=new TableCellSize();//default mode, cell size is defined by word according to contents size
	/**
	 * is the cell merged with other ones ?
	 */
	private CellWidth cellWitdh=new CellWidth();

	/**
	 * we store here the cell text configuration (bold, italic, text centered ...)
	 * limitation : 1 table cell = 1 paragraph for the moment
	 */
	private ParagraphBuilder paraBuilder = new ParagraphBuilder();

	public TableCell(String value,ParagraphAlignment alignment) {
		this.value = value;
		paraBuilder.setAlignment(alignment);
	}

	public TableCell(String value, boolean isBold, boolean isItalic,UnderlineStyle isUnderline,ParagraphAlignment alignment) {
		this.value = value;
		paraBuilder.setBold(isBold);
		paraBuilder.setItalic(isItalic);
		paraBuilder.setUnderline(isUnderline);
		paraBuilder.setAlignment(alignment);
	}

	public TableCell(CellWidth p_cellWidth) {
		cellWitdh=p_cellWidth;
	}
	/**
	 * @return   the value
	 * @uml.property  name="value"
	 */
	public String getValue() {
		return value;
	}
	/**
	 * @param value   the value to set
	 * @uml.property  name="value"
	 */
	public void setValue(String value) {
		this.value = value;
	}

	private Element addCellProperties() {
		/* 	build something like
		 * 	<w:tcPr> <!-- table cell properties -->
				<w:shd w:fill="00FF00"/>
				<!-- Table Cell Shading see chapter 2.4.33
			</w:tcPr>
		 */
		DocumentFactory factory=DocumentFactory.getInstance();
		Element cellProperties=factory.createElement(new QName(WordprocessingML.TABLE_CELL_PROPERTIES, WordDocument.namespaceWord));

		if (cellBackgroundColor!=null) {
			//add shading only if a color has been defined
			addBackgroundProperties( cellProperties);
		}
		// add the info if the cell is merged with the next ones
		cellWitdh.build(  cellProperties);

		// if the cell has a specific size, set it
		cellSize.build( cellProperties);
		return cellProperties;
	}

	/**
	 * @param rootDocument
	 * @param cellProperties, color is in format RRGGBB
	 * add something like
	 * 		<w:shd w:fill="00FF00"/> Table Cell Shading see chapter 2.4.33
	 */
	private void addBackgroundProperties(Element cellProperties) {
		Element cellBackground  =cellProperties.addElement(new QName(WordprocessingML.TABLE_CELL_SHADING, WordDocument.namespaceWord));
		cellBackground.addAttribute(new QName(WordprocessingML.ATTRIBUTE_FILL, WordDocument.namespaceWord), cellBackgroundColor);
		}

	public Element build() {
		if (value!=null) {
			return buildXmlForCell(value);
		} else {
			logger.warn("cell with null value, empty string assumed");
			return buildXmlForCell("");
		}
		}

	private Element buildXmlForCell(String valueInCell)  {

		//the open xml part of the job :
		// - create the cell properties and
		// - add the paragraphs in the cell open xml tag

		// build the  paragraph list from cell value.
		//each CR will make a new paragraph
//#ifdef JAVA5
		List<Paragraph> paraList = paraBuilder.newParagraphs(valueInCell);
//#else
/*
		List paraList = paraBuilder.newParagraphs(valueInCell);
*/
//#endif

		//TODO why namespace makes trouble with table border ??
		//	Element cellAsXml = rootDocument.createElementNS(WordprocessingML.NS_WORD12,"tc");
//			Element cellProperties = rootDocument.createElementNS(WordprocessingML.NS_WORD12,"tcPr");
		DocumentFactory factory=DocumentFactory.getInstance();
		Element cellAsXml=factory.createElement(new QName(WordprocessingML.TABLE_CELL, WordDocument.namespaceWord));
		cellAsXml.add(addCellProperties());
		//TODO optimize here, addCellProperties call again DocumentFactory. sent as argument and use addElement instead

		//add all the paragraphs
		for (Iterator iter = paraList.iterator(); iter.hasNext();) {
			Paragraph para = (Paragraph) iter.next();
			cellAsXml.add(para.build());
		}


		return cellAsXml;
	}
	/**
	 * @return   the cellBackgroundColor
	 * @uml.property  name="cellBackgroundColor"
	 */
	public String getCellBackgroundColor() {
		return cellBackgroundColor;
	}
	/**
	 * @param cellBackgroundColor   the cellBackgroundColor to set
	 * @uml.property  name="cellBackgroundColor"
	 */
	public void setCellBackgroundColor(String cellBackgroundColor) {
		this.cellBackgroundColor = cellBackgroundColor;
	}
	public void setBold(boolean isBold) {
		paraBuilder.setBold(isBold);
	}
	public void setItalic(boolean isItalic) {
		paraBuilder.setItalic(isItalic);
	}
	public void setUnderline(UnderlineStyle isUnderline) {
		paraBuilder.setUnderline(isUnderline);
	}
	public void setAlignment(ParagraphAlignment alignment) {
		paraBuilder.setAlignment(alignment);
	}
	public void setCellSize(TableCellSize cellsize) {
		this.cellSize = cellsize;
	}
}
