package org.openxml4j.document.wordprocessing.model.table;

import org.dom4j.Element;
import org.dom4j.QName;
import org.openxml4j.document.wordprocessing.WordDocument;
import org.openxml4j.document.wordprocessing.WordprocessingML;
import org.openxml4j.exceptions.OpenXML4JException;


/**
 * @author CDubettier
 * number of cells horizontally merged
 */
public class CellWidth {
	private int nbCellHorizontallyMerged;

	public CellWidth() {
		this.nbCellHorizontallyMerged =1;//no merge
	}

	public CellWidth(int nbCellHorizontallyMerged) throws OpenXML4JException {
		if (nbCellHorizontallyMerged<1) {
			throw new OpenXML4JException("Cell merge should be >= 1");
			// 1 -> no merge, cell is alone
			// 2 -> merge with the next one
			// 3                    2 next ones
		}
		this.nbCellHorizontallyMerged = nbCellHorizontallyMerged;
	}

	public int getNbCellHorizontallyMerged() {
		return nbCellHorizontallyMerged;
	}

	public void setNbCellHorizontallyMerged(int nbCellHorizontallyMerged) {
		this.nbCellHorizontallyMerged = nbCellHorizontallyMerged;
	}

	/**
	 * @return true if this cell is merged horizontally with an other one
	 */
	private boolean isCellMergedHorizontally() {
		if (nbCellHorizontallyMerged >1) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 *  add something like <w:gridSpan w:val="3"/> if cells are merge (add nothing if cell is left alone)
	 * @param rootDocument
	 * @param cellProperties : the node <w:tcPr> (table cell properties)
	 */
	public void build( Element cellProperties) {
		if (isCellMergedHorizontally()) {
			Element cellWidth= cellProperties.addElement(new QName(WordprocessingML.TABLE_CELL_HORIZONTAL_WIDTH, WordDocument.namespaceWord));
			cellWidth.addAttribute(new QName(WordprocessingML.ATTRIBUTE_VAL, WordDocument.namespaceWord), (new Integer(nbCellHorizontallyMerged)).toString());
		}
	}
}
