package org.openxml4j.document.wordprocessing.model.table;


/**
 * @author CDubettier
 * this is a subset of possible elements
 * defined in 2.18.4 ST_Border (Border Styles) in doc open_xml_part_4_markup_language_reference
 *
 * this is not an Enum because of JDK 1.4 compatibility
 */
public class BorderStyle implements Comparable {
	// Ordinal of next DocumentStatus to be created
	private static int nextOrdinal = 0;

	// Assign an ordinal to this suit
	private final int ordinal = nextOrdinal++;

	private String name;

	private BorderStyle(String name) {
		this.name = name;
	}

	public String toString() {
		return name;
	}

	public int compareTo(Object o) {
		return ordinal - ((BorderStyle) o).ordinal;
	}

	public static final BorderStyle BORDER_STYLE_ZIGZAG = new BorderStyle("zigZag");
	static public final BorderStyle BORDER_STYLE_TRIPLE= new BorderStyle("triple");
	static public final BorderStyle BORDER_STYLE_THIN_THICK_LARGE_GAP= new BorderStyle("thinThickLargeGap");
	static public final BorderStyle BORDER_STYLE_THICK= new BorderStyle("thick");
	static public final BorderStyle BORDER_STYLE_SINGLE= new BorderStyle("single");
	static public final BorderStyle BORDER_STYLE_DOUBLE= new BorderStyle("double");
	static public final BorderStyle BORDER_STYLE_DOTTED= new BorderStyle("dotted");
	static public final BorderStyle BORDER_STYLE_DOT_DOT_DASH= new BorderStyle("dotDotDash");
	static public final BorderStyle BORDER_STYLE_DOT_DASH= new BorderStyle("dotDash");
	static public final BorderStyle BORDER_STYLE_DASHED= new BorderStyle("dashed");
	static public final BorderStyle BORDER_STYLE_COUPON_CUTOUT_DASHES= new BorderStyle("couponCutoutDashes");
	static public final BorderStyle BORDER_STYLE_BASIC_WIDE_OUTLINE= new BorderStyle("basicWideOutline");
	static public final BorderStyle BORDER_STYLE_BASIC_THIN_LINES= new BorderStyle("basicThinLines");
}
