package org.openxml4j.document.wordprocessing;


public interface WordprocessingML {

	String NS_MARKUP_COMPATIBILY = "http://schemas.openxmlformats.org/markup-compatibility/2006";

	String NS_OFFICE = "urn:schemas-microsoft-com:office:office";

	String NS_OFFICE_12 = "http://schemas.microsoft.com/office/2004/7/core";

	String NS_RELATIONSHIPS = "http://schemas.openxmlformats.org/officeDocument/2006/relationships";

	String NS_OMML = "http://schemas.microsoft.com/office/omml/2004/12/core";

	String NS_VML = "urn:schemas-microsoft-com:vml";

	String NS_DRAWINGML = "http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing";

	String NS_WORD10 = "urn:schemas-microsoft-com:office:word";

	//open xml namespace for word (displayed as w: in document.xml)
	String NS_WORD12 = "http://schemas.openxmlformats.org/wordprocessingml/2006/main";

	/////////////////////////////////////////////////////////////////////////////
	// 				Open Xml word keywords
	////////////////////////////////////////////////////////////////////////////
	String WORD_DOC_BODY_TAG_NAME = "body";

	//table
	String TABLE_BODY_TAG_NAME = "tbl";
	String TABLE_PROPERTIES_TAG_NAME="tblPr";
	String TABLE_PROPERTIES_PREFRED_TABLE_WIDTH="tblW";
	String TABLE_BORDER_TAG_NAME = "tblBorders";
	String TABLE_BORDER_TOP_TAG_NAME = "top";
	String TABLE_BORDER_LEFT_TAG_NAME ="left";
	String TABLE_BORDER_RIGHT_TAG_NAME ="right";
	String TABLE_BORDER_BOTTOM_TAG_NAME ="bottom";
	String TABLE_BORDER_INSIDE_V_TAG_NAME ="insideV";
	String TABLE_BORDER_INSIDE_H_TAG_NAME ="insideH";
	String TABLE_CELL="tc";
	String TABLE_CELL_PROPERTIES="tcPr";
	String TABLE_CELL_SHADING="shd";
	String TABLE_CELL_HORIZONTAL_WIDTH="gridSpan";

	String TABLE_CELL_WIDTH="tcW";
	String TABLE_CELL_WIDTH_VALUE="w";
	String TABLE_CELL_WIDTH_TYPE="type";

	String TABLE_CELL_ROW= "tr";

	//paragraph
	String RUN_VERTICAL_ALIGNEMENT_PROPERTY_TAG_NAME = "vertAlign";
	String RUN_FONT_SIZE_PROPERTY_TAG_NAME = "sz";
	String RUN_UNDERLINE_PROPERTY_TAG_NAME = "u";
	String RUN_ITALIC_PROPERTY_TAG_NAME = "i";
	String RUN_BOLD_PROPERTY_TAG_NAME = "b";
	String RUN_PROPERTIES_TAG_NAME = "rPr";
	String RUN_TEXT = "t";

	String PARAGRAPH_RUN_TAG_NAME = "r";
	String PROPERTIES_VALUE_TAG_NAME = "val";
	String PARAGRAPH_ALIGNEMENT_TAG_NAME = "jc";
	String PARAGRAPH_PROPERTIES_TAG_NAME = "pPr";
	String PARAGRAPH_BODY_TAG_NAME = "p";
	String PARAGRAPH_NUMBERING_TAG_NAME="numPr";
	String PARAGRAPH_NUMBERING_LEVEL_REFERENCE="ilvl";
	String PARAGRAPH_NUMBERING_REFERENCE="numId";
	String PARAGRAPH_SPACING="spacing"; //space before/after
	String PARAGRAPH_SPACING_BEFORE="before";
	String PARAGRAPH_SPACING_AFTER="after";

	String PARAGRAPH_STYLE="pStyle";
	String PARAGRAPH_PERM_START_TAG_NAME = "permStart";
	String PARAGRAPH_PERM_END_TAG_NAME = "permEnd";
	String PARAGRAPH_PERM_ID_TAG_NAME = "id";

	// misc
	String ATTRIBUTE_VAL="val";
	String ATTRIBUTE_SIZE="sz";
	String ATTRIBUTE_SPACE="space";
	String ATTRIBUTE_COLOR="color";
	String ATTRIBUTE_FILL = "fill"; //used for TABLE_CELL_SHADING

	String VALUE_AUTO="auto";

	//keyword in setting.xml
	String WORD_DOC_PROTECTION = "documentProtection";
	String PROPERTIES_EDIT_TAG_NAME = "edit";
	String PROPERTIES_READ_ONLY = "readOnly";
	String PROPERTIES_ENFORCEMENT_TAG_NAME = "enforcement";
	String PROPERTIES_ENFORCEMENT_ON = "1";
	String SETTINGS_ROOT="settings";

	String ID_TAG_NAME = "id";//TODO see also PARAGRAPH_PERM_ID_TAG_NAME

	String IMAGEDATA_TAG_NAME = "imagedata";
	String PICTURE_TAG_NAME = "pict";
	String SHAPE_TAG_NAME="shape";
}