package org.openxml4j.document.wordprocessing;


/**
 * Alignement verticale de niveau caractre.
 * @author    Julien Chable
 */
public class VerticalAlignment implements Comparable {
	
	private static int nextOrdinal = 0;
	private final int ordinal = nextOrdinal++;

	private final String name;
	
	private VerticalAlignment(String name) {
		this.name = name;
	}
	
    public int compareTo(Object o) {
        return ordinal - ((VerticalAlignment)o).ordinal;
    }

	public String toString() {
		return name.toLowerCase();
	}
	
	public static final VerticalAlignment NONE = new VerticalAlignment("NONE");	
	public static final VerticalAlignment SUBSCRIPT = new VerticalAlignment("SUBSCRIPT");
	public static final VerticalAlignment SUPERSCRIPT = new VerticalAlignment("SUPERSCRIPT");

}