package org.openxml4j.document.wordprocessing;


/**
 * Le style de soulignement.
 * @author    Julien Chable
 */
public class UnderlineStyle implements Comparable {
	
	private static int nextOrdinal = 0;
	private final int ordinal = nextOrdinal++;

	private final String name;
	
	private UnderlineStyle(String name) {
		this.name = name;
	}
	
    public int compareTo(Object o) {
        return ordinal - ((UnderlineStyle)o).ordinal;
    }

	public String toString() {
		return name.toLowerCase();
	}
	
	public static final UnderlineStyle DASH = new UnderlineStyle("DASH");
	public static final UnderlineStyle NONE = new UnderlineStyle("NONE");
	public static final UnderlineStyle SINGLE = new UnderlineStyle("SINGLE");
	public static final UnderlineStyle THICK = new UnderlineStyle("THICK");
	public static final UnderlineStyle WAVE = new UnderlineStyle("WAVE");
	public static final UnderlineStyle WORDS = new UnderlineStyle("WORDS");


}