package org.openxml4j.document.wordprocessing;

/**
 * Reprsente un Run d'un paragraphe, c'est  dire un ensemble de caractres possdant les mmes proprits.
 * @author    Julien Chable
 */
public class Run {
	/**
	 */
	protected boolean bold;

	/**
	 */
	protected boolean italic;

	protected UnderlineStyle underline = UnderlineStyle.NONE;

	/**
	 * the text of the run
	 */
	protected String text = new String();

	/**
	 */
	protected int fontSize = 22;

	protected VerticalAlignment verticalAlignement = VerticalAlignment.NONE;

	/**
	 * Constructeur.
	 *
	 * @param text
	 *            Le texte initial.
	 */
	public Run(String newText) {
		this.text=text+newText;
	}

	/**
	 * Ajouter le texte spcifi.
	 *
	 * @param text
	 *            Le texte  ajouter.
	 */
	public void appendText(String extraText) {
		text=text+extraText;
	}

	/**
	 * Supprimer l'intgralit du texte.
	 */
	public void clearText() {
		this.text="";
	}

	/* Accesseurs */

	/**
	 * @return   the bold
	 * @uml.property  name="bold"
	 */
	public boolean isBold() {
		return bold;
	}

	/**
	 * @param bold   the bold to set
	 * @uml.property  name="bold"
	 */
	public void setBold(boolean bold) {
		this.bold = bold;
	}

	/**
	 * @return   the italic
	 * @uml.property  name="italic"
	 */
	public boolean isItalic() {
		return italic;
	}

	/**
	 * @param italic   the italic to set
	 * @uml.property  name="italic"
	 */
	public void setItalic(boolean italic) {
		this.italic = italic;
	}

	/**
	 * @return   the underline
	 * @uml.property  name="underline"
	 */
	public UnderlineStyle getUnderline() {
		return underline;
	}

	/**
	 * @param underline   the underline to set
	 * @uml.property  name="underline"
	 */
	public void setUnderline(UnderlineStyle underline) {
		this.underline = underline;
	}

	/**
	 * @return   the fontSize
	 * @uml.property  name="fontSize"
	 */
	public int getFontSize() {
		return fontSize;
	}

	/**
	 * @param fontSize   the fontSize to set
	 * @uml.property  name="fontSize"
	 */
	public void setFontSize(int fontSize) {
		this.fontSize = fontSize;
	}

	/**
	 * @return   the text
	 * @uml.property  name="text"
	 */
	public String getText() {
		return text.toString();
	}

	/**
	 * @return   the verticalAlignement
	 * @uml.property  name="verticalAlignement"
	 */
	public VerticalAlignment getVerticalAlignement() {
		return verticalAlignement;
	}

	/**
	 * @param verticalAlignement   the verticalAlignement to set
	 * @uml.property  name="verticalAlignement"
	 */
	public void setVerticalAlignement(VerticalAlignment verticalAlignement) {
		this.verticalAlignement = verticalAlignement;
	}

}