package org.openxml4j.document.wordprocessing;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;


public class Picture {
	private static Logger  logger = Logger.getLogger("org.openxml4j");



	public static boolean isPicture(String tag) {
		if (tag==null) {
			return false;
		}
		if (tag.equals(WordprocessingML.PICTURE_TAG_NAME)) {
			return true;
		} else {
			return false;
		}
	}
	/**
	 * @param nodeToCheck
	 * @return true if the node is a picture (ie tag w:pict)
	 */
	public static boolean isPicture(Node nodeToCheck) {
		return isPicture(nodeToCheck.getName());
	}
	private static boolean isShape(String tag)
	{
		if (tag==null) {
			return false;
		}
		if (tag.equals(WordprocessingML.SHAPE_TAG_NAME)) {
			return true;
		} else {
			return false;
		}
	}
	private static boolean isImageData(String tag)
	{
		if (tag==null) {
			return false;
		}
		if (tag.equals(WordprocessingML.IMAGEDATA_TAG_NAME)) {
			return true;
		} else {
			return false;
		}
	}
	public static boolean isIdTag(String tag) {
		if (tag==null) {
			return false;
		}
		if (tag.equals(WordprocessingML.ID_TAG_NAME)) {
			return true;
		} else {
			return false;
		}
	}


	/**
	 * update a id in a XML struct like
	 * <w:pict>
     * 		<v:shape>
     * 			<v:imagedata r:id="rId1" />
	 * 		</v:shape>
	 *
	 * @param mapOldIdToNewId  map listing the old id with their new value
	 * @param nodeToSearch: w:pict node
	 * @return false if problem
	 */
//#ifdef JAVA5
	private static boolean updateId(Element nodeToSearch, TreeMap<String, String> mapOldIdToNewId)
//#else
/*
	private static boolean updateId(Element nodeToSearch, TreeMap mapOldIdToNewId)
*/
//#endif
	{
		for ( Iterator i = nodeToSearch.elementIterator(); i.hasNext(); ) {
			Element child = (Element) i.next();
			if  ( isShape(child.getName()) ) {//look for v:shape
				// look for imagedata
				for ( Iterator j = child.elementIterator(); j.hasNext(); ) {
					Element childOfShape = (Element) j.next();
					if  (isImageData(childOfShape.getName())) {
						// look for id attribute
						Attribute attr=childOfShape.attribute(WordprocessingML.ID_TAG_NAME);
//#ifdef JAVA5
						String newId=mapOldIdToNewId.get(attr.getStringValue());
//#else
/*
						String newId=(String) mapOldIdToNewId.get(attr.getStringValue());
*/
//#endif
								if (newId==null) {
							logger.error("cannot find new id for id="+attr.getStringValue());
									return false;
								}
						if (logger.isDebugEnabled()) {
							logger.debug("found image id="+attr.getStringValue()+" replaced by "+newId);
						}
						attr.setValue(newId);
								return true; // id found, no need to continue searching
							}
						}
					}
				}

		logger.warn("no id found for "+nodeToSearch.getName());
		return false;//normally should be an id, but we have not find it
	}

	/**
	 * fill the list of images referenced in this node (<w:pict>)
	 * @param nodeToInsert : input: node to search for images
	 * @param listImageNodes : output: list of images referenced in nodeToInsert
	 * 							Note: The List object should be created, this function just fill it
	 */
//#ifdef JAVA5
	public static void getListReferenceForImages(Element nodeToInsert,List<Element> listImageNodes)
//#else
/*
	public static void getListReferenceForImages(Element nodeToInsert,List listImageNodes)
*/
//#endif
	{
		for ( Iterator i = nodeToInsert.elementIterator(); i.hasNext(); ) {
			Element element = (Element) i.next();
			List listOfChild=element.elements();
			if (listOfChild.size()==0) {
				//end node
				checkPictureTagAndAddToList(listImageNodes, element);
			} else {
				if (checkPictureTagAndAddToList(listImageNodes, element)) {
					//we are lucky we do not have to look for sub nodes
					return;
				}
				//search all subnodes
				for (Iterator j=listOfChild.iterator();j.hasNext();) {
					Element child = (Element) j.next();

					if (checkPictureTagAndAddToList(listImageNodes, child)) {
//						 found a picture no need to dive in xml
						return;
					} else {
						getListReferenceForImages(child, listImageNodes);
						//recursive call
					}
				}
			}
		}
	}
//#ifdef JAVA5
	private static boolean checkPictureTagAndAddToList(List<Element> listImageNodes, Element element) {
//#else
/*
	private static boolean checkPictureTagAndAddToList(List listImageNodes, Element element) {
*/
//#endif
		if (element.getName().equals(WordprocessingML.PICTURE_TAG_NAME)) {
			if (logger.isDebugEnabled()) {
				logger.debug("found a picture :"+element.asXML());
			}
			listImageNodes.add(element);
			return true;
			}
		return false;
		}

	/**
	 * update reference of images in the merged doc by updating the XML attributes
	 *
	 * We cannot keep the same reference as each doc references its images with name image1 image2 ...
	 * The second doc shall rename its images
	 *
	 * @param listOfImages the list of XML image nodes
	 * @param mapOldIdToNewId the association old id-> new id
	 *
	 * @return  false if error
	 */
//#ifdef JAVA5
	public static boolean addNewReferences(List<Element> listOfImages, TreeMap<String, String> mapOldIdToNewId) {
//#else
/*
	public static boolean addNewReferences(List listOfImages, TreeMap mapOldIdToNewId) {
*/
//#endif
		for (Iterator iter = listOfImages.iterator(); iter.hasNext();) {
			Element pictureElement = (Element) iter.next();
//			extract the id of the reference
			if (!updateId(pictureElement,mapOldIdToNewId)) {
				logger.error("aborting because of error");
				return false;
			}
		}
		return true;
	}
}
