package org.openxml4j.document.wordprocessing;

import org.dom4j.Element;
import org.dom4j.QName;

public class ParagraphSpacing {
	private int before;
	private int after;

	public ParagraphSpacing() {
		this.before = 0;
		this.after = 0;
	}
	public ParagraphSpacing(int before, int after) {
		this.before = before;
		this.after = after;
	}
	public ParagraphSpacing(ParagraphSpacingPredefined predefined) {
		before=predefined.getBefore();
		after=predefined.getAfter();
	}
	public int getAfter() {
		return after;
	}
	public void setAfter(int after) {
		this.after = after;
	}
	public int getBefore() {
		return before;
	}
	public void setBefore(int before) {
		this.before = before;
	}
	public boolean isSpacingRequired() {
		if ((after !=0) || (before !=0)) {
			return true;
		}
		return false;
	}

	public void addParagraphSpacingProperties(Element parProps) {
		// build something like
		// <w:spacing w:before="240" w:after="120"/>
		Element spacing=parProps.addElement(new QName(WordprocessingML.PARAGRAPH_SPACING, WordDocument.namespaceWord));
		//before
		spacing.addAttribute(new QName(WordprocessingML.PARAGRAPH_SPACING_BEFORE, WordDocument.namespaceWord), (new Integer(before)).toString());
		//after
		spacing.addAttribute(new QName(WordprocessingML.PARAGRAPH_SPACING_AFTER, WordDocument.namespaceWord), (new Integer(after)).toString());
	}



}
