package org.openxml4j.document.wordprocessing;

import org.dom4j.Element;
import org.dom4j.QName;



/**
 * @author CDubettier
 * warning, the open xml logic is a bit tricky
 * In order to make a part of the text read only and the rest freely editable, we should
 * 	- set the whole document as "read only"
 *  - set the text that could be changed with the permStart/permEnd tag
 */
public class ParagraphReadOnlyManager {
	/**
	 * each paragraph has an defined id.
	 * this id is used to show where start/end the write allowed part of the document
	 * The id should be unique per paragraph.
	 * ex permStart w:id="10"
	 */
	protected static int firstAvailableId=1;
	/**
	 * @see firstAvailableId
	 * id for this paragraph (a ParagraphReadOnlyManager object is created per paragraph)
	 */
	protected int currentId;

	public ParagraphReadOnlyManager() {
		currentId=firstAvailableId;
		firstAvailableId++;
	}

	/**
	 * add something like <w: permStart w:id="10" />
	 * @param rootDocument
	 * @param paragraph the paragraph to be set as NOT read only
	 */
	public void addReadOnlyStartTag(Element insertionPoint) {
		Element readOnlyProperty=insertionPoint.addElement(new QName(WordprocessingML.PARAGRAPH_PERM_START_TAG_NAME, WordDocument.namespaceWord));
		readOnlyProperty.addAttribute(new QName(WordprocessingML.PARAGRAPH_PERM_ID_TAG_NAME, WordDocument.namespaceWord),
										(new Integer(currentId)).toString());
	}

	/**
	 * add something like <w: permEnd w:id="10" />
	 * @param rootDocument
	 * @param paragraph the paragraph to be set as NOT read only
	 */
	public void addReadOnlyEndTag(Element insertionPoint) {
		Element readOnlyProperty=insertionPoint.addElement(new QName(WordprocessingML.PARAGRAPH_PERM_END_TAG_NAME, WordDocument.namespaceWord));
		readOnlyProperty.addAttribute(new QName(WordprocessingML.PARAGRAPH_PERM_ID_TAG_NAME, WordDocument.namespaceWord),
										(new Integer(currentId)).toString());
	}
}
