package org.openxml4j.document.spreadsheet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.openxml4j.document.OpenXMLDocument;
import org.openxml4j.exceptions.OpenXML4JException;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.opc.PackagePartName;
import org.openxml4j.opc.PackageRelationship;
import org.openxml4j.opc.PackagingURIHelper;
import org.openxml4j.opc.StreamHelper;
import org.openxml4j.opc.internal.PartMarshaller;
import org.openxml4j.opc.internal.marshallers.ZipPartMarshaller;

public class ExcelDocument extends OpenXMLDocument {
	public static final String MAIN_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml";
	public static final String SHEET_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml";
	public static final String SHARED_STRINGS_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml";
	
	/**
	 * XML contents of the excel spreadsheet
	 */
	private Document workbook;
	private List<Element> sheets;
	
	private PackagePart workbookPart;
	
	public ExcelDocument(Package container) throws Exception {
		super(container);
		
		// Get the main workbook
		openWorkbook();
		// And the list of sheets
		sheets = workbook.getRootElement().element("sheets").elements("sheet");
	}
	
	public Document _getWorkbook() { return workbook; }
	public String[] getSheetNames() {
		String[] names = new String[sheets.size()];
		
		int i=0;
		for(Element s : sheets) {
			names[i] = s.attributeValue("name");
			i++;
		}
		return names;
	}
	
	public Document getSheet(String sheetName) throws OpenXML4JException {
		Element sheetDef = null;
		for(Element s : sheets) {
			if(s.attributeValue("name").equals(sheetName)) {
				sheetDef = s;
			}
		}
		if(sheetDef == null) {
			throw new IllegalArgumentException("No sheet with name '"+sheetName+"'");
		}
		
		String relId = sheetDef.attributeValue("id");
		PackageRelationship rel = 
			workbookPart.getRelationship(relId);
		PackagePartName relName =
			PackagingURIHelper.createPartName(rel.getTargetURI());
		
		PackagePart sheet = container.getPart(relName);
		if(sheet == null) {
			throw new OpenXML4JException("No part found for rel " + rel);
		}
		try {
			SAXReader reader = new SAXReader();
			return reader.read(sheet.getInputStream());
		} catch (DocumentException e) {
			throw new OpenXML4JException(e.getMessage());
		} catch (IOException io) {
			throw new OpenXML4JException(io.getMessage());
		}
	}
	
	public String getText() throws OpenXML4JException {
		String[] sheetNames = getSheetNames();
		Document[] sheetDocs = new Document[sheetNames.length];
		for(int i=0; i<sheetDocs.length; i++) {
			sheetDocs[i] = getSheet(sheetNames[i]);
		}
		
		for(int i=0; i<sheetDocs.length; i++) {
		}
		
		return null;
	}
	
	private void openWorkbook() throws Exception {
		// Find the package part for it
		ArrayList<PackagePart> wbs =
			container.getPartsByContentType(MAIN_CONTENT_TYPE);
		if(wbs.size() != 1) {
			throw new OpenXML4JException("Expecting one entry with content type of " + MAIN_CONTENT_TYPE + ", but found " + wbs.size());
		}
		workbookPart = wbs.get(0);
		
		// And load it up
		try {
			SAXReader reader = new SAXReader();
			workbook = reader.read(workbookPart.getInputStream());
		} catch (DocumentException e) {
			throw new OpenXML4JException(e.getMessage());
		}
	}
}
