/*
 * Copyright (c) 2006, Wygwam
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met: 
 * 
 * - Redistributions of source code must retain the above copyright notice, 
 * this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation and/or 
 * other materials provided with the distribution.
 * - Neither the name of Wygwam nor the names of its contributors may be 
 * used to endorse or promote products derived from this software without 
 * specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.openxml4j.document;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.openxml4j.exceptions.InvalidFormatException;
import org.openxml4j.exceptions.InvalidOperationException;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackageAccess;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.opc.PackageRelationshipTypes;
import org.openxml4j.opc.PackagingURIHelper;

/**
 * Represent an abtract OpenXML document. <b>Testing only</b>
 * 
 * @author Julien Chable
 * @version 0.2
 */
@Deprecated
public abstract class OpenXMLDocument {

	/**
	 * Buffer to read data from file. Use big buffer to improve performaces. the
	 * InputStream class is reading only 8192 bytes per read call (default value
	 * set by sun)
	 */
	public static final int READ_WRITE_FILE_BUFFER_SIZE = 8192;

	/**
	 * Logger.
	 */
	protected static Logger logger = Logger.getLogger("org.openxml4j.document");

	/**
	 * Package container.
	 */
	protected Package container;

	/**
	 * Constructor.
	 * 
	 * @param container
	 *            The package
	 */
	protected OpenXMLDocument(Package container) {
		this.container = container;
	}

	/**
	 * Extract all resources of the specified content type and copy them to the
	 * specified folder.
	 * 
	 * @param contentType
	 *            Content type.
	 * @param destFolder
	 *            Destination folder.
	 */
	public void extractFiles(String contentType, File destFolder) {
		if (!destFolder.isDirectory()) {
			throw new IllegalArgumentException(
					"parameter desFolder should be a directory !");
		}

		ArrayList<PackagePart> parts = new ArrayList<PackagePart>();
		for (PackagePart part : container.getPartsByContentType(contentType)) {
			parts.add(part);
		}
		extractParts(parts, destFolder);
	}

	/**
	 * Extract content of the specified parts and copy them to the specified
	 * folder.
	 * 
	 * @param contentType
	 *            Content type.
	 * @param destFolder
	 *            Destination folder.
	 */
	public boolean extractParts(ArrayList<PackagePart> parts, File destFolder) {
		boolean result = true;
		for (PackagePart part : parts) {
			String filename = PackagingURIHelper.getFilename(part.getPartName()
					.getURI());
			try {
				InputStream ins = part.getInputStream();
				FileOutputStream fw = new FileOutputStream(destFolder
						.getAbsolutePath()
						+ File.separator + filename);

				byte[] buff = new byte[READ_WRITE_FILE_BUFFER_SIZE];
				while (ins.available() > 0) {
					int resultRead = ins.read(buff);
					if (resultRead == -1) {
						// end of file reached
						break;
					} else {
						fw.write(buff, 0, resultRead);
					}
				}
				fw.close();
			} catch (IOException e) {
				logger.error("cannot generate file " + filename, e);
				result = false;
			}
		}
		return result;
	}

	/**
	 * Get all thumbnail parts in this document.
	 * 
	 * @return All thumbnail parts contain in this document if any, else returns
	 *         <code>null</code> (also occur if OpenXML4J encounter an invalid
	 *         package and can't find thumbnail parts by following the
	 *         relationship parts).
	 */
	public ArrayList<PackagePart> getThumbnails() {
		return container
				.getPartsByRelationshipType(PackageRelationshipTypes.THUMBNAIL);
	}

	/**
	 * Open an Open XML document.
	 * 
	 * @param path
	 *            The path to the document.
	 * @param access
	 *            Document access mode.
	 * @throws InvalidFormatException
	 *             Throws if the specified document is not valid.
	 * @return A typed package
	 */
	public static OpenXMLDocument open(String path, PackageAccess access)
			throws InvalidFormatException {
		// return new OpenXMLDocument(Package.open(path, access));
		// TODO Detect document type
		return null;
	}

	/**
	 * Save document in an open XML file
	 */
	public void save() throws IOException {
		container.close();
	}

	/**
	 * Save this document in the specified file.
	 */
	public void save(File file) throws IOException {
		throw new InvalidOperationException("Method not implemented !");
	}

	/**
	 * Get the package container.
	 * 
	 * @return The package associated to this document.
	 */
	public Package getPackage() {
		return container;
	}

}