/*
 * Ext JS Library 2.3.0
 * Copyright(c) 2006-2009, Ext JS, LLC.
 * licensing@extjs.com
 * 
 * http://extjs.com/license
 */


Ext.Toolbar=function(config){if(Ext.isArray(config)){config={buttons:config};}
Ext.Toolbar.superclass.constructor.call(this,config);};(function(){var T=Ext.Toolbar;Ext.extend(T,Ext.BoxComponent,{trackMenus:true,initComponent:function(){T.superclass.initComponent.call(this);if(this.items){this.buttons=this.items;}
this.items=new Ext.util.MixedCollection(false,function(o){return o.itemId||o.id||Ext.id();});},autoCreate:{cls:'x-toolbar x-small-editor',html:'<table cellspacing="0"><tr></tr></table>'},onRender:function(ct,position){this.el=ct.createChild(Ext.apply({id:this.id},this.autoCreate),position);this.tr=this.el.child("tr",true);},afterRender:function(){T.superclass.afterRender.call(this);if(this.buttons){this.add.apply(this,this.buttons);delete this.buttons;}},add:function(){var a=arguments,l=a.length;for(var i=0;i<l;i++){var el=a[i];if(el.isFormField){this.addField(el);}else if(el.render){this.addItem(el);}else if(typeof el=="string"){if(el=="separator"||el=="-"){this.addSeparator();}else if(el==" "){this.addSpacer();}else if(el=="->"){this.addFill();}else{this.addText(el);}}else if(el.tagName){this.addElement(el);}else if(typeof el=="object"){if(el.xtype){this.addField(Ext.ComponentMgr.create(el,'button'));}else{this.addButton(el);}}}},addSeparator:function(){return this.addItem(new T.Separator());},addSpacer:function(){return this.addItem(new T.Spacer());},addFill:function(){return this.addItem(new T.Fill());},addElement:function(el){return this.addItem(new T.Item(el));},addItem:function(item){var td=this.nextBlock();this.initMenuTracking(item);item.render(td);this.items.add(item);return item;},addButton:function(config){if(Ext.isArray(config)){var buttons=[];for(var i=0,len=config.length;i<len;i++){buttons.push(this.addButton(config[i]));}
return buttons;}
var b=config;if(!(config instanceof T.Button)){b=config.split?new T.SplitButton(config):new T.Button(config);}
var td=this.nextBlock();this.initMenuTracking(b);b.render(td);this.items.add(b);return b;},initMenuTracking:function(item){if(this.trackMenus&&item.menu){item.on({'menutriggerover':this.onButtonTriggerOver,'menushow':this.onButtonMenuShow,'menuhide':this.onButtonMenuHide,scope:this})}},addText:function(text){return this.addItem(new T.TextItem(text));},insertButton:function(index,item){if(Ext.isArray(item)){var buttons=[];for(var i=0,len=item.length;i<len;i++){buttons.push(this.insertButton(index+i,item[i]));}
return buttons;}
if(!(item instanceof T.Button)){item=new T.Button(item);}
var td=document.createElement("td");this.tr.insertBefore(td,this.tr.childNodes[index]);this.initMenuTracking(item);item.render(td);this.items.insert(index,item);return item;},addDom:function(config,returnEl){var td=this.nextBlock();Ext.DomHelper.overwrite(td,config);var ti=new T.Item(td.firstChild);ti.render(td);this.items.add(ti);return ti;},addField:function(field){var td=this.nextBlock();field.render(td);var ti=new T.Item(td.firstChild);ti.render(td);this.items.add(field);return ti;},nextBlock:function(){var td=document.createElement("td");this.tr.appendChild(td);return td;},onDestroy:function(){Ext.Toolbar.superclass.onDestroy.call(this);if(this.rendered){if(this.items){Ext.destroy.apply(Ext,this.items.items);}
Ext.Element.uncache(this.tr);}},onDisable:function(){this.items.each(function(item){if(item.disable){item.disable();}});},onEnable:function(){this.items.each(function(item){if(item.enable){item.enable();}});},onButtonTriggerOver:function(btn){if(this.activeMenuBtn&&this.activeMenuBtn!=btn){this.activeMenuBtn.hideMenu();btn.showMenu();this.activeMenuBtn=btn;}},onButtonMenuShow:function(btn){this.activeMenuBtn=btn;},onButtonMenuHide:function(btn){delete this.activeMenuBtn;}});Ext.reg('toolbar',Ext.Toolbar);T.Item=function(el){this.el=Ext.getDom(el);this.id=Ext.id(this.el);this.hidden=false;};T.Item.prototype={getEl:function(){return this.el;},render:function(td){this.td=td;td.appendChild(this.el);},destroy:function(){if(this.el){var el=Ext.get(this.el);Ext.destroy(el);}
Ext.removeNode(this.td);},show:function(){this.hidden=false;this.td.style.display="";},hide:function(){this.hidden=true;this.td.style.display="none";},setVisible:function(visible){if(visible){this.show();}else{this.hide();}},focus:function(){Ext.fly(this.el).focus();},disable:function(){Ext.fly(this.td).addClass("x-item-disabled");this.disabled=true;this.el.disabled=true;},enable:function(){Ext.fly(this.td).removeClass("x-item-disabled");this.disabled=false;this.el.disabled=false;}};Ext.reg('tbitem',T.Item);T.Separator=function(){var s=document.createElement("span");s.className="ytb-sep";T.Separator.superclass.constructor.call(this,s);};Ext.extend(T.Separator,T.Item,{enable:Ext.emptyFn,disable:Ext.emptyFn,focus:Ext.emptyFn});Ext.reg('tbseparator',T.Separator);T.Spacer=function(){var s=document.createElement("div");s.className="ytb-spacer";T.Spacer.superclass.constructor.call(this,s);};Ext.extend(T.Spacer,T.Item,{enable:Ext.emptyFn,disable:Ext.emptyFn,focus:Ext.emptyFn});Ext.reg('tbspacer',T.Spacer);T.Fill=Ext.extend(T.Spacer,{render:function(td){td.style.width='100%';T.Fill.superclass.render.call(this,td);}});Ext.reg('tbfill',T.Fill);T.TextItem=function(t){var s=document.createElement("span");s.className="ytb-text";s.innerHTML=t.text?t.text:t;T.TextItem.superclass.constructor.call(this,s);};Ext.extend(T.TextItem,T.Item,{enable:Ext.emptyFn,disable:Ext.emptyFn,focus:Ext.emptyFn});Ext.reg('tbtext',T.TextItem);T.Button=Ext.extend(Ext.Button,{hideParent:true,onDestroy:function(){T.Button.superclass.onDestroy.call(this);if(this.container){this.container.remove();}}});Ext.reg('tbbutton',T.Button);T.SplitButton=Ext.extend(Ext.SplitButton,{hideParent:true,onDestroy:function(){T.SplitButton.superclass.onDestroy.call(this);if(this.container){this.container.remove();}}});Ext.reg('tbsplit',T.SplitButton);T.MenuButton=T.SplitButton;})();

Ext.PagingToolbar=Ext.extend(Ext.Toolbar,{pageSize:20,displayMsg:'Displaying {0} - {1} of {2}',emptyMsg:'No data to display',beforePageText:"Page",afterPageText:"of {0}",firstText:"First Page",prevText:"Previous Page",nextText:"Next Page",lastText:"Last Page",refreshText:"Refresh",paramNames:{start:'start',limit:'limit'},initComponent:function(){this.addEvents('change','beforechange');Ext.PagingToolbar.superclass.initComponent.call(this);this.cursor=0;this.bind(this.store);},onRender:function(ct,position){Ext.PagingToolbar.superclass.onRender.call(this,ct,position);this.first=this.addButton({tooltip:this.firstText,iconCls:"x-tbar-page-first",disabled:true,handler:this.onClick.createDelegate(this,["first"])});this.prev=this.addButton({tooltip:this.prevText,iconCls:"x-tbar-page-prev",disabled:true,handler:this.onClick.createDelegate(this,["prev"])});this.addSeparator();this.add(this.beforePageText);this.field=Ext.get(this.addDom({tag:"input",type:"text",size:"3",value:"1",cls:"x-tbar-page-number"}).el);this.field.on("keydown",this.onPagingKeydown,this);this.field.on("focus",function(){this.dom.select();});this.field.on("blur",this.onPagingBlur,this);this.afterTextEl=this.addText(String.format(this.afterPageText,1));this.field.setHeight(18);this.addSeparator();this.next=this.addButton({tooltip:this.nextText,iconCls:"x-tbar-page-next",disabled:true,handler:this.onClick.createDelegate(this,["next"])});this.last=this.addButton({tooltip:this.lastText,iconCls:"x-tbar-page-last",disabled:true,handler:this.onClick.createDelegate(this,["last"])});this.addSeparator();this.loading=this.addButton({tooltip:this.refreshText,iconCls:"x-tbar-loading",handler:this.onClick.createDelegate(this,["refresh"])});if(this.displayInfo){this.displayEl=Ext.fly(this.el.dom).createChild({cls:'x-paging-info'});}
if(this.dsLoaded){this.onLoad.apply(this,this.dsLoaded);}},updateInfo:function(){if(this.displayEl){var count=this.store.getCount();var msg=count==0?this.emptyMsg:String.format(this.displayMsg,this.cursor+1,this.cursor+count,this.store.getTotalCount());this.displayEl.update(msg);}},onLoad:function(store,r,o){if(!this.rendered){this.dsLoaded=[store,r,o];return;}
this.cursor=o.params?o.params[this.paramNames.start]:0;var d=this.getPageData(),ap=d.activePage,ps=d.pages;this.afterTextEl.el.innerHTML=String.format(this.afterPageText,d.pages);this.field.dom.value=ap;this.first.setDisabled(ap==1);this.prev.setDisabled(ap==1);this.next.setDisabled(ap==ps);this.last.setDisabled(ap==ps);this.loading.enable();this.updateInfo();this.fireEvent('change',this,d);},getPageData:function(){var total=this.store.getTotalCount();return{total:total,activePage:Math.ceil((this.cursor+this.pageSize)/this.pageSize),pages:total<this.pageSize?1:Math.ceil(total/this.pageSize)};},onLoadError:function(){if(!this.rendered){return;}
this.loading.enable();},readPage:function(d){var v=this.field.dom.value,pageNum;if(!v||isNaN(pageNum=parseInt(v,10))){this.field.dom.value=d.activePage;return false;}
return pageNum;},onPagingBlur:function(e){this.field.dom.value=this.getPageData().activePage;},onPagingKeydown:function(e){var k=e.getKey(),d=this.getPageData(),pageNum;if(k==e.RETURN){e.stopEvent();pageNum=this.readPage(d);if(pageNum!==false){pageNum=Math.min(Math.max(1,pageNum),d.pages)-1;this.doLoad(pageNum*this.pageSize);}}else if(k==e.HOME||k==e.END){e.stopEvent();pageNum=k==e.HOME?1:d.pages;this.field.dom.value=pageNum;}else if(k==e.UP||k==e.PAGEUP||k==e.DOWN||k==e.PAGEDOWN){e.stopEvent();if(pageNum=this.readPage(d)){var increment=e.shiftKey?10:1;if(k==e.DOWN||k==e.PAGEDOWN){increment*=-1;}
pageNum+=increment;if(pageNum>=1&pageNum<=d.pages){this.field.dom.value=pageNum;}}}},beforeLoad:function(){if(this.rendered&&this.loading){this.loading.disable();}},doLoad:function(start){var o={},pn=this.paramNames;o[pn.start]=start;o[pn.limit]=this.pageSize;if(this.fireEvent('beforechange',this,o)!==false){this.store.load({params:o});}},changePage:function(page){this.doLoad(((page-1)*this.pageSize).constrain(0,this.store.getTotalCount()));},onClick:function(which){var store=this.store;switch(which){case"first":this.doLoad(0);break;case"prev":this.doLoad(Math.max(0,this.cursor-this.pageSize));break;case"next":this.doLoad(this.cursor+this.pageSize);break;case"last":var total=store.getTotalCount();var extra=total%this.pageSize;var lastStart=extra?(total-extra):total-this.pageSize;this.doLoad(lastStart);break;case"refresh":this.doLoad(this.cursor);break;}},unbind:function(store){store=Ext.StoreMgr.lookup(store);store.un("beforeload",this.beforeLoad,this);store.un("load",this.onLoad,this);store.un("loadexception",this.onLoadError,this);this.store=undefined;},bind:function(store){store=Ext.StoreMgr.lookup(store);store.on("beforeload",this.beforeLoad,this);store.on("load",this.onLoad,this);store.on("loadexception",this.onLoadError,this);this.store=store;if(store.getCount()>0){this.onLoad(store,null,{});}},onDestroy:function(){if(this.store){this.unbind(this.store);}
Ext.PagingToolbar.superclass.onDestroy.call(this);}});Ext.reg('paging',Ext.PagingToolbar);
