/*
 * Ext JS Library 2.3.0
 * Copyright(c) 2006-2009, Ext JS, LLC.
 * licensing@extjs.com
 * 
 * http://extjs.com/license
 */


Ext.Tip=Ext.extend(Ext.Panel,{minWidth:40,maxWidth:300,shadow:"sides",defaultAlign:"tl-bl?",autoRender:true,quickShowInterval:250,frame:true,hidden:true,baseCls:'x-tip',floating:{shadow:true,shim:true,useDisplay:true,constrain:false},autoHeight:true,initComponent:function(){Ext.Tip.superclass.initComponent.call(this);if(this.closable&&!this.title){this.elements+=',header';}},afterRender:function(){Ext.Tip.superclass.afterRender.call(this);if(this.closable){this.addTool({id:'close',handler:this.hide,scope:this});}},showAt:function(xy){Ext.Tip.superclass.show.call(this);if(this.measureWidth!==false&&(!this.initialConfig||typeof this.initialConfig.width!='number')){this.doAutoWidth();}
if(this.constrainPosition){xy=this.el.adjustForConstraints(xy);}
this.setPagePosition(xy[0],xy[1]);},doAutoWidth:function(){var bw=this.body.getTextWidth();if(this.title){bw=Math.max(bw,this.header.child('span').getTextWidth(this.title));}
bw+=this.getFrameWidth()+(this.closable?20:0)+this.body.getPadding("lr");this.setWidth(bw.constrain(this.minWidth,this.maxWidth));if(Ext.isIE7&&!this.repainted){this.el.repaint();this.repainted=true;}},showBy:function(el,pos){if(!this.rendered){this.render(Ext.getBody());}
this.showAt(this.el.getAlignToXY(el,pos||this.defaultAlign));},initDraggable:function(){this.dd=new Ext.Tip.DD(this,typeof this.draggable=='boolean'?null:this.draggable);this.header.addClass('x-tip-draggable');}});Ext.Tip.DD=function(tip,config){Ext.apply(this,config);this.tip=tip;Ext.Tip.DD.superclass.constructor.call(this,tip.el.id,'WindowDD-'+tip.id);this.setHandleElId(tip.header.id);this.scroll=false;};Ext.extend(Ext.Tip.DD,Ext.dd.DD,{moveOnly:true,scroll:false,headerOffsets:[100,25],startDrag:function(){this.tip.el.disableShadow();},endDrag:function(e){this.tip.el.enableShadow(true);}});

Ext.ToolTip=Ext.extend(Ext.Tip,{showDelay:500,hideDelay:200,dismissDelay:5000,mouseOffset:[15,18],trackMouse:false,constrainPosition:true,initComponent:function(){Ext.ToolTip.superclass.initComponent.call(this);this.lastActive=new Date();this.initTarget();},initTarget:function(){if(this.target){this.target=Ext.get(this.target);this.target.on('mouseover',this.onTargetOver,this);this.target.on('mouseout',this.onTargetOut,this);this.target.on('mousemove',this.onMouseMove,this);}},onMouseMove:function(e){this.targetXY=e.getXY();if(!this.hidden&&this.trackMouse){this.setPagePosition(this.getTargetXY());}},getTargetXY:function(){return[this.targetXY[0]+this.mouseOffset[0],this.targetXY[1]+this.mouseOffset[1]];},onTargetOver:function(e){if(this.disabled||e.within(this.target.dom,true)){return;}
this.clearTimer('hide');this.targetXY=e.getXY();this.delayShow();},delayShow:function(){if(this.hidden&&!this.showTimer){if(this.lastActive.getElapsed()<this.quickShowInterval){this.show();}else{this.showTimer=this.show.defer(this.showDelay,this);}}else if(!this.hidden&&this.autoHide!==false){this.show();}},onTargetOut:function(e){if(this.disabled||e.within(this.target.dom,true)){return;}
this.clearTimer('show');if(this.autoHide!==false){this.delayHide();}},delayHide:function(){if(!this.hidden&&!this.hideTimer){this.hideTimer=this.hide.defer(this.hideDelay,this);}},hide:function(){this.clearTimer('dismiss');this.lastActive=new Date();Ext.ToolTip.superclass.hide.call(this);},show:function(){this.showAt(this.getTargetXY());},showAt:function(xy){this.lastActive=new Date();this.clearTimers();Ext.ToolTip.superclass.showAt.call(this,xy);if(this.dismissDelay&&this.autoHide!==false){this.dismissTimer=this.hide.defer(this.dismissDelay,this);}},clearTimer:function(name){name=name+'Timer';clearTimeout(this[name]);delete this[name];},clearTimers:function(){this.clearTimer('show');this.clearTimer('dismiss');this.clearTimer('hide');},onShow:function(){Ext.ToolTip.superclass.onShow.call(this);Ext.getDoc().on('mousedown',this.onDocMouseDown,this);},onHide:function(){Ext.ToolTip.superclass.onHide.call(this);Ext.getDoc().un('mousedown',this.onDocMouseDown,this);},onDocMouseDown:function(e){if(this.autoHide!==true&&!e.within(this.el.dom)){this.disable();this.enable.defer(100,this);}},onDisable:function(){this.clearTimers();this.hide();},adjustPosition:function(x,y){var ay=this.targetXY[1],h=this.getSize().height;if(this.constrainPosition&&y<=ay&&(y+h)>=ay){y=ay-h-5;}
return{x:x,y:y};},onDestroy:function(){Ext.ToolTip.superclass.onDestroy.call(this);Ext.getDoc().un('mousedown',this.onDocMouseDown,this);if(this.target){this.target.un('mouseover',this.onTargetOver,this);this.target.un('mouseout',this.onTargetOut,this);this.target.un('mousemove',this.onMouseMove,this);}}});

Ext.QuickTip=Ext.extend(Ext.ToolTip,{interceptTitles:false,tagConfig:{namespace:"ext",attribute:"qtip",width:"qwidth",target:"target",title:"qtitle",hide:"hide",cls:"qclass",align:"qalign"},initComponent:function(){this.target=this.target||Ext.getDoc();this.targets=this.targets||{};Ext.QuickTip.superclass.initComponent.call(this);},register:function(config){var cs=Ext.isArray(config)?config:arguments;for(var i=0,len=cs.length;i<len;i++){var c=cs[i];var target=c.target;if(target){if(Ext.isArray(target)){for(var j=0,jlen=target.length;j<jlen;j++){this.targets[Ext.id(target[j])]=c;}}else{this.targets[Ext.id(target)]=c;}}}},unregister:function(el){delete this.targets[Ext.id(el)];},onTargetOver:function(e){if(this.disabled){return;}
this.targetXY=e.getXY();var t=e.getTarget();if(!t||t.nodeType!==1||t==document||t==document.body){return;}
if(this.activeTarget&&t==this.activeTarget.el){this.clearTimer('hide');this.show();return;}
if(t&&this.targets[t.id]){this.activeTarget=this.targets[t.id];this.activeTarget.el=t;this.delayShow();return;}
var ttp,et=Ext.fly(t),cfg=this.tagConfig;var ns=cfg.namespace;if(this.interceptTitles&&t.title){ttp=t.title;t.qtip=ttp;t.removeAttribute("title");e.preventDefault();}else{ttp=t.qtip||et.getAttributeNS(ns,cfg.attribute);}
if(ttp){var autoHide=et.getAttributeNS(ns,cfg.hide);this.activeTarget={el:t,text:ttp,width:et.getAttributeNS(ns,cfg.width),autoHide:autoHide!="user"&&autoHide!=='false',title:et.getAttributeNS(ns,cfg.title),cls:et.getAttributeNS(ns,cfg.cls),align:et.getAttributeNS(ns,cfg.align)};this.delayShow();}},onTargetOut:function(e){this.clearTimer('show');if(this.autoHide!==false){this.delayHide();}},showAt:function(xy){var t=this.activeTarget;if(t){if(!this.rendered){this.render(Ext.getBody());this.activeTarget=t;}
if(t.width){this.setWidth(t.width);this.body.setWidth(this.adjustBodyWidth(t.width-this.getFrameWidth()));this.measureWidth=false;}else{this.measureWidth=true;}
this.setTitle(t.title||'');this.body.update(t.text);this.autoHide=t.autoHide;this.dismissDelay=t.dismissDelay||this.dismissDelay;if(this.lastCls){this.el.removeClass(this.lastCls);delete this.lastCls;}
if(t.cls){this.el.addClass(t.cls);this.lastCls=t.cls;}
if(t.align){xy=this.el.getAlignToXY(t.el,t.align);this.constrainPosition=false;}else{this.constrainPosition=true;}}
Ext.QuickTip.superclass.showAt.call(this,xy);},hide:function(){delete this.activeTarget;Ext.QuickTip.superclass.hide.call(this);}});

Ext.QuickTips=function(){var tip,locks=[];return{init:function(autoRender){if(!tip){if(!Ext.isReady){Ext.onReady(function(){Ext.QuickTips.init(autoRender);});return;}
tip=new Ext.QuickTip({elements:'header,body'});if(autoRender!==false){tip.render(Ext.getBody());}}},enable:function(){if(tip){locks.pop();if(locks.length<1){tip.enable();}}},disable:function(){if(tip){tip.disable();}
locks.push(1);},isEnabled:function(){return tip!==undefined&&!tip.disabled;},getQuickTip:function(){return tip;},register:function(){tip.register.apply(tip,arguments);},unregister:function(){tip.unregister.apply(tip,arguments);},tips:function(){tip.register.apply(tip,arguments);}}}();
