/*
 * Ext JS Library 2.3.0
 * Copyright(c) 2006-2009, Ext JS, LLC.
 * licensing@extjs.com
 * 
 * http://extjs.com/license
 */


Ext.grid.GridView=function(config){Ext.apply(this,config);this.addEvents("beforerowremoved","beforerowsinserted","beforerefresh","rowremoved","rowsinserted","rowupdated","refresh");Ext.grid.GridView.superclass.constructor.call(this);};Ext.extend(Ext.grid.GridView,Ext.util.Observable,{deferEmptyText:true,scrollOffset:19,autoFill:false,forceFit:false,sortClasses:["sort-asc","sort-desc"],sortAscText:"Sort Ascending",sortDescText:"Sort Descending",columnsText:"Columns",borderWidth:2,tdClass:'x-grid3-cell',hdCls:'x-grid3-hd',cellSelectorDepth:4,rowSelectorDepth:10,cellSelector:'td.x-grid3-cell',rowSelector:'div.x-grid3-row',firstRowCls:'x-grid3-row-first',lastRowCls:'x-grid3-row-last',rowClsRe:/(?:^|\s+)x-grid3-row-(first|last|alt)(?:\s+|$)/g,initTemplates:function(){var ts=this.templates||{};if(!ts.master){ts.master=new Ext.Template('<div class="x-grid3" hidefocus="true">','<div class="x-grid3-viewport">','<div class="x-grid3-header"><div class="x-grid3-header-inner"><div class="x-grid3-header-offset" style="{ostyle}">{header}</div></div><div class="x-clear"></div></div>','<div class="x-grid3-scroller"><div class="x-grid3-body" style="{bstyle}">{body}</div><a href="#" class="x-grid3-focus" tabIndex="-1"></a></div>','</div>','<div class="x-grid3-resize-marker">&#160;</div>','<div class="x-grid3-resize-proxy">&#160;</div>','</div>');}
if(!ts.header){ts.header=new Ext.Template('<table border="0" cellspacing="0" cellpadding="0" style="{tstyle}">','<thead><tr class="x-grid3-hd-row">{cells}</tr></thead>','</table>');}
if(!ts.hcell){ts.hcell=new Ext.Template('<td class="x-grid3-hd x-grid3-cell x-grid3-td-{id} {css}" style="{style}"><div {tooltip} {attr} class="x-grid3-hd-inner x-grid3-hd-{id}" unselectable="on" style="{istyle}">',this.grid.enableHdMenu?'<a class="x-grid3-hd-btn" href="#"></a>':'','{value}<img class="x-grid3-sort-icon" src="',Ext.BLANK_IMAGE_URL,'" />','</div></td>');}
if(!ts.body){ts.body=new Ext.Template('{rows}');}
if(!ts.row){ts.row=new Ext.Template('<div class="x-grid3-row {alt}" style="{tstyle}"><table class="x-grid3-row-table" border="0" cellspacing="0" cellpadding="0" style="{tstyle}">','<tbody><tr>{cells}</tr>',(this.enableRowBody?'<tr class="x-grid3-row-body-tr" style="{bodyStyle}"><td colspan="{cols}" class="x-grid3-body-cell" tabIndex="0" hidefocus="on"><div class="x-grid3-row-body">{body}</div></td></tr>':''),'</tbody></table></div>');}
if(!ts.cell){ts.cell=new Ext.Template('<td class="x-grid3-col x-grid3-cell x-grid3-td-{id} {css}" style="{style}" tabIndex="0" {cellAttr}>','<div class="x-grid3-cell-inner x-grid3-col-{id}" unselectable="on" {attr}>{value}</div>','</td>');}
for(var k in ts){var t=ts[k];if(t&&typeof t.compile=='function'&&!t.compiled){t.disableFormats=true;t.compile();}}
this.templates=ts;this.colRe=new RegExp("x-grid3-td-([^\\s]+)","");},fly:function(el){if(!this._flyweight){this._flyweight=new Ext.Element.Flyweight(document.body);}
this._flyweight.dom=el;return this._flyweight;},getEditorParent:function(){return this.scroller.dom;},initElements:function(){var E=Ext.Element;var el=this.grid.getGridEl().dom.firstChild;var cs=el.childNodes;this.el=new E(el);this.mainWrap=new E(cs[0]);this.mainHd=new E(this.mainWrap.dom.firstChild);if(this.grid.hideHeaders){this.mainHd.setDisplayed(false);}
this.innerHd=this.mainHd.dom.firstChild;this.scroller=new E(this.mainWrap.dom.childNodes[1]);if(this.forceFit){this.scroller.setStyle('overflow-x','hidden');}
this.mainBody=new E(this.scroller.dom.firstChild);this.focusEl=new E(this.scroller.dom.childNodes[1]);this.focusEl.swallowEvent("click",true);this.resizeMarker=new E(cs[1]);this.resizeProxy=new E(cs[2]);},getRows:function(){return this.hasRows()?this.mainBody.dom.childNodes:[];},findCell:function(el){if(!el){return false;}
return this.fly(el).findParent(this.cellSelector,this.cellSelectorDepth);},findCellIndex:function(el,requiredCls){var cell=this.findCell(el);if(cell&&(!requiredCls||this.fly(cell).hasClass(requiredCls))){return this.getCellIndex(cell);}
return false;},getCellIndex:function(el){if(el){var m=el.className.match(this.colRe);if(m&&m[1]){return this.cm.getIndexById(m[1]);}}
return false;},findHeaderCell:function(el){var cell=this.findCell(el);return cell&&this.fly(cell).hasClass(this.hdCls)?cell:null;},findHeaderIndex:function(el){return this.findCellIndex(el,this.hdCls);},findRow:function(el){if(!el){return false;}
return this.fly(el).findParent(this.rowSelector,this.rowSelectorDepth);},findRowIndex:function(el){var r=this.findRow(el);return r?r.rowIndex:false;},getRow:function(row){return this.getRows()[row];},getCell:function(row,col){return this.getRow(row).getElementsByTagName('td')[col];},getHeaderCell:function(index){return this.mainHd.dom.getElementsByTagName('td')[index];},addRowClass:function(row,cls){var r=this.getRow(row);if(r){this.fly(r).addClass(cls);}},removeRowClass:function(row,cls){var r=this.getRow(row);if(r){this.fly(r).removeClass(cls);}},removeRow:function(row){Ext.removeNode(this.getRow(row));this.syncFocusEl(row);},removeRows:function(firstRow,lastRow){var bd=this.mainBody.dom;for(var rowIndex=firstRow;rowIndex<=lastRow;rowIndex++){Ext.removeNode(bd.childNodes[firstRow]);}
this.syncFocusEl(firstRow);},getScrollState:function(){var sb=this.scroller.dom;return{left:sb.scrollLeft,top:sb.scrollTop};},restoreScroll:function(state){var sb=this.scroller.dom;sb.scrollLeft=state.left;sb.scrollTop=state.top;},scrollToTop:function(){this.scroller.dom.scrollTop=0;this.scroller.dom.scrollLeft=0;},syncScroll:function(){this.syncHeaderScroll();var mb=this.scroller.dom;this.grid.fireEvent("bodyscroll",mb.scrollLeft,mb.scrollTop);},syncHeaderScroll:function(){var mb=this.scroller.dom;this.innerHd.scrollLeft=mb.scrollLeft;this.innerHd.scrollLeft=mb.scrollLeft;},updateSortIcon:function(col,dir){var sc=this.sortClasses;var hds=this.mainHd.select('td').removeClass(sc);hds.item(col).addClass(sc[dir=="DESC"?1:0]);},updateAllColumnWidths:function(){var tw=this.getTotalWidth();var clen=this.cm.getColumnCount();var ws=[];for(var i=0;i<clen;i++){ws[i]=this.getColumnWidth(i);}
this.innerHd.firstChild.style.width=this.getOffsetWidth();this.innerHd.firstChild.firstChild.style.width=tw;this.mainBody.dom.style.width=tw;for(var i=0;i<clen;i++){var hd=this.getHeaderCell(i);hd.style.width=ws[i];}
var ns=this.getRows(),row,trow;for(var i=0,len=ns.length;i<len;i++){row=ns[i];row.style.width=tw;if(row.firstChild){row.firstChild.style.width=tw;trow=row.firstChild.rows[0];for(var j=0;j<clen;j++){trow.childNodes[j].style.width=ws[j];}}}
this.onAllColumnWidthsUpdated(ws,tw);},updateColumnWidth:function(col,width){var w=this.getColumnWidth(col);var tw=this.getTotalWidth();this.innerHd.firstChild.style.width=this.getOffsetWidth();this.innerHd.firstChild.firstChild.style.width=tw;this.mainBody.dom.style.width=tw;var hd=this.getHeaderCell(col);hd.style.width=w;var ns=this.getRows(),row;for(var i=0,len=ns.length;i<len;i++){row=ns[i];row.style.width=tw;if(row.firstChild){row.firstChild.style.width=tw;row.firstChild.rows[0].childNodes[col].style.width=w;}}
this.onColumnWidthUpdated(col,w,tw);},updateColumnHidden:function(col,hidden){var tw=this.getTotalWidth();this.innerHd.firstChild.style.width=this.getOffsetWidth();this.innerHd.firstChild.firstChild.style.width=tw;this.mainBody.dom.style.width=tw;var display=hidden?'none':'';var hd=this.getHeaderCell(col);hd.style.display=display;var ns=this.getRows(),row;for(var i=0,len=ns.length;i<len;i++){row=ns[i];row.style.width=tw;if(row.firstChild){row.firstChild.style.width=tw;row.firstChild.rows[0].childNodes[col].style.display=display;}}
this.onColumnHiddenUpdated(col,hidden,tw);delete this.lastViewWidth;this.layout();},doRender:function(cs,rs,ds,startRow,colCount,stripe){var ts=this.templates,ct=ts.cell,rt=ts.row,last=colCount-1;var tstyle='width:'+this.getTotalWidth()+';';var buf=[],cb,c,p={},rp={tstyle:tstyle},r;for(var j=0,len=rs.length;j<len;j++){r=rs[j];cb=[];var rowIndex=(j+startRow);for(var i=0;i<colCount;i++){c=cs[i];p.id=c.id;p.css=i==0?'x-grid3-cell-first ':(i==last?'x-grid3-cell-last ':'');p.attr=p.cellAttr="";p.value=c.renderer(r.data[c.name],p,r,rowIndex,i,ds);p.style=c.style;if(p.value==undefined||p.value==="")p.value="&#160;";if(r.dirty&&typeof r.modified[c.name]!=='undefined'){p.css+=' x-grid3-dirty-cell';}
cb[cb.length]=ct.apply(p);}
var alt=[];if(stripe&&((rowIndex+1)%2==0)){alt[0]="x-grid3-row-alt";}
if(r.dirty){alt[1]=" x-grid3-dirty-row";}
rp.cols=colCount;if(this.getRowClass){alt[2]=this.getRowClass(r,rowIndex,rp,ds);}
rp.alt=alt.join(" ");rp.cells=cb.join("");buf[buf.length]=rt.apply(rp);}
return buf.join("");},processRows:function(startRow,skipStripe){if(!this.ds||this.ds.getCount()<1){return;}
var rows=this.getRows();skipStripe=skipStripe||!this.grid.stripeRows;startRow=startRow||0;Ext.each(rows,function(row,idx){row.rowIndex=idx;row.className=row.className.replace(this.rowClsRe,' ');if(!skipStripe&&(idx+1)%2===0){row.className+=' x-grid3-row-alt';}});if(startRow===0){Ext.fly(rows[0]).addClass(this.firstRowCls);}
Ext.fly(rows[rows.length-1]).addClass(this.lastRowCls);},afterRender:function(){this.mainBody.dom.innerHTML=this.renderRows()||'&nbsp;';this.processRows(0,true);if(this.deferEmptyText!==true){this.applyEmptyText();}},renderUI:function(){var header=this.renderHeaders();var body=this.templates.body.apply({rows:'&nbsp;'});var html=this.templates.master.apply({body:body,header:header,ostyle:'width:'+this.getOffsetWidth()+';',bstyle:'width:'+this.getTotalWidth()+';'});var g=this.grid;g.getGridEl().dom.innerHTML=html;this.initElements();Ext.fly(this.innerHd).on("click",this.handleHdDown,this);this.mainHd.on("mouseover",this.handleHdOver,this);this.mainHd.on("mouseout",this.handleHdOut,this);this.mainHd.on("mousemove",this.handleHdMove,this);this.scroller.on('scroll',this.syncScroll,this);if(g.enableColumnResize!==false){this.splitZone=new Ext.grid.GridView.SplitDragZone(g,this.mainHd.dom);}
if(g.enableColumnMove){this.columnDrag=new Ext.grid.GridView.ColumnDragZone(g,this.innerHd);this.columnDrop=new Ext.grid.HeaderDropZone(g,this.mainHd.dom);}
if(g.enableHdMenu!==false){if(g.enableColumnHide!==false){this.colMenu=new Ext.menu.Menu({id:g.id+"-hcols-menu"});this.colMenu.on("beforeshow",this.beforeColMenuShow,this);this.colMenu.on("itemclick",this.handleHdMenuClick,this);}
this.hmenu=new Ext.menu.Menu({id:g.id+"-hctx"});this.hmenu.add({id:"asc",text:this.sortAscText,cls:"xg-hmenu-sort-asc"},{id:"desc",text:this.sortDescText,cls:"xg-hmenu-sort-desc"});if(g.enableColumnHide!==false){this.hmenu.add('-',{id:"columns",hideOnClick:false,text:this.columnsText,menu:this.colMenu,iconCls:'x-cols-icon'});}
this.hmenu.on("itemclick",this.handleHdMenuClick,this);}
if(g.trackMouseOver){this.mainBody.on("mouseover",this.onRowOver,this);this.mainBody.on("mouseout",this.onRowOut,this);}
if(g.enableDragDrop||g.enableDrag){this.dragZone=new Ext.grid.GridDragZone(g,{ddGroup:g.ddGroup||'GridDD'});}
this.updateHeaderSortState();},layout:function(){if(!this.mainBody){return;}
var g=this.grid;var c=g.getGridEl();var csize=c.getSize(true);var vw=csize.width;if(vw<20||csize.height<20){return;}
if(g.autoHeight){this.scroller.dom.style.overflow='visible';if(Ext.isWebKit){this.scroller.dom.style.position='static';}}else{this.el.setSize(csize.width,csize.height);var hdHeight=this.mainHd.getHeight();var vh=csize.height-(hdHeight);this.scroller.setSize(vw,vh);if(this.innerHd){this.innerHd.style.width=(vw)+'px';}}
if(this.forceFit){if(this.lastViewWidth!=vw){this.fitColumns(false,false);this.lastViewWidth=vw;}}else{this.autoExpand();this.syncHeaderScroll();}
this.onLayout(vw,vh);},onLayout:function(vw,vh){},onColumnWidthUpdated:function(col,w,tw){},onAllColumnWidthsUpdated:function(ws,tw){},onColumnHiddenUpdated:function(col,hidden,tw){},updateColumnText:function(col,text){},afterMove:function(colIndex){},init:function(grid){this.grid=grid;this.initTemplates();this.initData(grid.store,grid.colModel);this.initUI(grid);},getColumnId:function(index){return this.cm.getColumnId(index);},getOffsetWidth:function(){return(this.cm.getTotalWidth()+this.scrollOffset)+'px';},renderHeaders:function(){var cm=this.cm,ts=this.templates;var ct=ts.hcell;var cb=[],sb=[],p={};var len=cm.getColumnCount();var last=len-1;for(var i=0;i<len;i++){p.id=cm.getColumnId(i);p.value=cm.getColumnHeader(i)||"";p.style=this.getColumnStyle(i,true);p.tooltip=this.getColumnTooltip(i);p.css=i==0?'x-grid3-cell-first ':(i==last?'x-grid3-cell-last ':'');if(cm.config[i].align=='right'){p.istyle='padding-right:16px';}else{delete p.istyle;}
cb[cb.length]=ct.apply(p);}
return ts.header.apply({cells:cb.join(""),tstyle:'width:'+this.getTotalWidth()+';'});},getColumnTooltip:function(i){var tt=this.cm.getColumnTooltip(i);if(tt){if(Ext.QuickTips.isEnabled()){return'ext:qtip="'+tt+'"';}else{return'title="'+tt+'"';}}
return"";},beforeUpdate:function(){this.grid.stopEditing(true);},updateHeaders:function(){this.innerHd.firstChild.innerHTML=this.renderHeaders();this.innerHd.firstChild.style.width=this.getOffsetWidth();this.innerHd.firstChild.firstChild.style.width=this.getTotalWidth();},focusRow:function(row){this.focusCell(row,0,false);},focusCell:function(row,col,hscroll){this.syncFocusEl(this.ensureVisible(row,col,hscroll));if(Ext.isGecko){this.focusEl.focus();}else{this.focusEl.focus.defer(1,this.focusEl);}},resolveCell:function(row,col,hscroll){if(typeof row!="number"){row=row.rowIndex;}
if(!this.ds){return null;}
if(row<0||row>=this.ds.getCount()){return null;}
col=(col!==undefined?col:0);var rowEl=this.getRow(row),cm=this.cm,colCount=cm.getColumnCount(),cellEl;if(!(hscroll===false&&col===0)){while(col<colCount&&cm.isHidden(col)){col++;}
cellEl=this.getCell(row,col);}
return{row:rowEl,cell:cellEl};},getResolvedXY:function(resolved){if(!resolved){return null;}
var s=this.scroller.dom,c=resolved.cell,r=resolved.row;return c?Ext.fly(c).getXY():[this.el.getX(),Ext.fly(r).getY()];},syncFocusEl:function(row,col,hscroll){var xy=row;if(!Ext.isArray(xy)){row=Math.min(row,Math.max(0,this.getRows().length-1));xy=this.getResolvedXY(this.resolveCell(row,col,hscroll));}
this.focusEl.setXY(xy||this.scroller.getXY());},ensureVisible:function(row,col,hscroll){var resolved=this.resolveCell(row,col,hscroll);if(!resolved||!resolved.row){return;}
var rowEl=resolved.row,cellEl=resolved.cell;var c=this.scroller.dom;var ctop=0;var p=rowEl,stop=this.el.dom;while(p&&p!=stop){ctop+=p.offsetTop;p=p.offsetParent;}
ctop-=this.mainHd.dom.offsetHeight;var cbot=ctop+rowEl.offsetHeight;var ch=c.clientHeight;var stop=parseInt(c.scrollTop,10);var sbot=stop+ch;if(ctop<stop){c.scrollTop=ctop;}else if(cbot>sbot){c.scrollTop=cbot-ch;}
if(hscroll!==false){var cleft=parseInt(cellEl.offsetLeft,10);var cright=cleft+cellEl.offsetWidth;var sleft=parseInt(c.scrollLeft,10);var sright=sleft+c.clientWidth;if(cleft<sleft){c.scrollLeft=cleft;}else if(cright>sright){c.scrollLeft=cright-c.clientWidth;}}
return this.getResolvedXY(resolved);},insertRows:function(dm,firstRow,lastRow,isUpdate){var last=dm.getCount()-1;if(!isUpdate&&firstRow===0&&lastRow>=last){this.refresh();}else{if(!isUpdate){this.fireEvent("beforerowsinserted",this,firstRow,lastRow);}
var html=this.renderRows(firstRow,lastRow);var before=this.getRow(firstRow);if(before){if(firstRow===0){Ext.fly(this.getRow(0)).removeClass(this.firstRowCls);}
Ext.DomHelper.insertHtml('beforeBegin',before,html);}else{var r=this.getRow(last-1);if(r){Ext.fly(r).removeClass(this.lastRowCls);}
Ext.DomHelper.insertHtml('beforeEnd',this.mainBody.dom,html);}
if(!isUpdate){this.fireEvent("rowsinserted",this,firstRow,lastRow);this.processRows(firstRow);}else if(firstRow===0||firstRow>=last){Ext.fly(this.getRow(firstRow)).addClass(firstRow===0?this.firstRowCls:this.lastRowCls);}}
this.syncFocusEl(firstRow);},deleteRows:function(dm,firstRow,lastRow){if(dm.getRowCount()<1){this.refresh();}else{this.fireEvent("beforerowsdeleted",this,firstRow,lastRow);this.removeRows(firstRow,lastRow);this.processRows(firstRow);this.fireEvent("rowsdeleted",this,firstRow,lastRow);}},getColumnStyle:function(col,isHeader){var style=!isHeader?(this.cm.config[col].css||''):'';style+='width:'+this.getColumnWidth(col)+';';if(this.cm.isHidden(col)){style+='display:none;';}
var align=this.cm.config[col].align;if(align){style+='text-align:'+align+';';}
return style;},getColumnWidth:function(col){var w=this.cm.getColumnWidth(col);if(typeof w=='number'){return(Ext.isBorderBox||(Ext.isWebKit&&!Ext.isSafari2)?w:(w-this.borderWidth>0?w-this.borderWidth:0))+'px';}
return w;},getTotalWidth:function(){return this.cm.getTotalWidth()+'px';},fitColumns:function(preventRefresh,onlyExpand,omitColumn){var cm=this.cm,leftOver,dist,i;var tw=cm.getTotalWidth(false);var aw=this.grid.getGridEl().getWidth(true)-this.scrollOffset;if(aw<20){return;}
var extra=aw-tw;if(extra===0){return false;}
var vc=cm.getColumnCount(true);var ac=vc-(typeof omitColumn=='number'?1:0);if(ac===0){ac=1;omitColumn=undefined;}
var colCount=cm.getColumnCount();var cols=[];var extraCol=0;var width=0;var w;for(i=0;i<colCount;i++){if(!cm.isHidden(i)&&!cm.isFixed(i)&&i!==omitColumn){w=cm.getColumnWidth(i);cols.push(i);extraCol=i;cols.push(w);width+=w;}}
var frac=(aw-cm.getTotalWidth())/width;while(cols.length){w=cols.pop();i=cols.pop();cm.setColumnWidth(i,Math.max(this.grid.minColumnWidth,Math.floor(w+w*frac)),true);}
if((tw=cm.getTotalWidth(false))>aw){var adjustCol=ac!=vc?omitColumn:extraCol;cm.setColumnWidth(adjustCol,Math.max(1,cm.getColumnWidth(adjustCol)-(tw-aw)),true);}
if(preventRefresh!==true){this.updateAllColumnWidths();}
return true;},autoExpand:function(preventUpdate){var g=this.grid,cm=this.cm;if(!this.userResized&&g.autoExpandColumn){var tw=cm.getTotalWidth(false);var aw=this.grid.getGridEl().getWidth(true)-this.scrollOffset;if(tw!=aw){var ci=cm.getIndexById(g.autoExpandColumn);var currentWidth=cm.getColumnWidth(ci);var cw=Math.min(Math.max(((aw-tw)+currentWidth),g.autoExpandMin),g.autoExpandMax);if(cw!=currentWidth){cm.setColumnWidth(ci,cw,true);if(preventUpdate!==true){this.updateColumnWidth(ci,cw);}}}}},getColumnData:function(){var cs=[],cm=this.cm,colCount=cm.getColumnCount();for(var i=0;i<colCount;i++){var name=cm.getDataIndex(i);cs[i]={name:(typeof name=='undefined'?this.ds.fields.get(i).name:name),renderer:cm.getRenderer(i),id:cm.getColumnId(i),style:this.getColumnStyle(i)};}
return cs;},renderRows:function(startRow,endRow){var g=this.grid,cm=g.colModel,ds=g.store,stripe=g.stripeRows;var colCount=cm.getColumnCount();if(ds.getCount()<1){return"";}
var cs=this.getColumnData();startRow=startRow||0;endRow=typeof endRow=="undefined"?ds.getCount()-1:endRow;var rs=ds.getRange(startRow,endRow);return this.doRender(cs,rs,ds,startRow,colCount,stripe);},renderBody:function(){var markup=this.renderRows()||'&nbsp;';return this.templates.body.apply({rows:markup});},refreshRow:function(record){var ds=this.ds,index;if(typeof record=='number'){index=record;record=ds.getAt(index);if(!record){return;}}else{index=ds.indexOf(record);if(index<0){return;}}
var cls=[];this.insertRows(ds,index,index,true);this.getRow(index).rowIndex=index;this.onRemove(ds,record,index+1,true);this.fireEvent("rowupdated",this,index,record);},refresh:function(headersToo){this.fireEvent("beforerefresh",this);this.grid.stopEditing(true);var result=this.renderBody();this.mainBody.update(result).setWidth(this.getTotalWidth());if(headersToo===true){this.updateHeaders();this.updateHeaderSortState();}
this.processRows(0,true);this.layout();this.applyEmptyText();this.fireEvent("refresh",this);},applyEmptyText:function(){if(this.emptyText&&!this.hasRows()){this.mainBody.update('<div class="x-grid-empty">'+this.emptyText+'</div>');}},updateHeaderSortState:function(){var state=this.ds.getSortState();if(!state){return;}
if(!this.sortState||(this.sortState.field!=state.field||this.sortState.direction!=state.direction)){this.grid.fireEvent('sortchange',this.grid,state);}
this.sortState=state;var sortColumn=this.cm.findColumnIndex(state.field);if(sortColumn!=-1){var sortDir=state.direction;this.updateSortIcon(sortColumn,sortDir);}},destroy:function(){if(this.colMenu){Ext.menu.MenuMgr.unregister(this.colMenu);this.colMenu.destroy();delete this.colMenu;}
if(this.hmenu){Ext.menu.MenuMgr.unregister(this.hmenu);this.hmenu.destroy();delete this.hmenu;}
if(this.grid.enableColumnMove){var dds=Ext.dd.DDM.ids['gridHeader'+this.grid.getGridEl().id];if(dds){for(var dd in dds){if(!dds[dd].config.isTarget&&dds[dd].dragElId){var elid=dds[dd].dragElId;dds[dd].unreg();Ext.get(elid).remove();}else if(dds[dd].config.isTarget){dds[dd].proxyTop.remove();dds[dd].proxyBottom.remove();dds[dd].unreg();}
if(Ext.dd.DDM.locationCache[dd]){delete Ext.dd.DDM.locationCache[dd];}}
delete Ext.dd.DDM.ids['gridHeader'+this.grid.getGridEl().id];}}
if(this.dragZone){this.dragZone.unreg();}
Ext.fly(this.innerHd).removeAllListeners();Ext.removeNode(this.innerHd);Ext.destroy(this.resizeMarker,this.resizeProxy,this.focusEl,this.mainBody,this.scroller,this.mainHd,this.mainWrap,this.dragZone,this.splitZone,this.columnDrag,this.columnDrop);this.initData(null,null);Ext.EventManager.removeResizeListener(this.onWindowResize,this);this.purgeListeners();},onDenyColumnHide:function(){},render:function(){if(this.autoFill){var ct=this.grid.ownerCt;if(ct&&ct.getLayout()){ct.on('afterlayout',function(){this.fitColumns(true,true);this.updateHeaders();},this,{single:true});}else{this.fitColumns(true,true);}}else if(this.forceFit){this.fitColumns(true,false);}else if(this.grid.autoExpandColumn){this.autoExpand(true);}
this.renderUI();},initData:function(ds,cm){if(this.ds){this.ds.un("load",this.onLoad,this);this.ds.un("datachanged",this.onDataChange,this);this.ds.un("add",this.onAdd,this);this.ds.un("remove",this.onRemove,this);this.ds.un("update",this.onUpdate,this);this.ds.un("clear",this.onClear,this);}
if(ds){ds.on("load",this.onLoad,this);ds.on("datachanged",this.onDataChange,this);ds.on("add",this.onAdd,this);ds.on("remove",this.onRemove,this);ds.on("update",this.onUpdate,this);ds.on("clear",this.onClear,this);}
this.ds=ds;if(this.cm){this.cm.un("configchange",this.onColConfigChange,this);this.cm.un("widthchange",this.onColWidthChange,this);this.cm.un("headerchange",this.onHeaderChange,this);this.cm.un("hiddenchange",this.onHiddenChange,this);this.cm.un("columnmoved",this.onColumnMove,this);this.cm.un("columnlockchange",this.onColumnLock,this);}
if(cm){delete this.lastViewWidth;cm.on("configchange",this.onColConfigChange,this);cm.on("widthchange",this.onColWidthChange,this);cm.on("headerchange",this.onHeaderChange,this);cm.on("hiddenchange",this.onHiddenChange,this);cm.on("columnmoved",this.onColumnMove,this);cm.on("columnlockchange",this.onColumnLock,this);}
this.cm=cm;},onDataChange:function(){this.refresh();this.updateHeaderSortState();this.syncFocusEl(0);},onClear:function(){this.refresh();this.syncFocusEl(0);},onUpdate:function(ds,record){this.refreshRow(record);},onAdd:function(ds,records,index){this.insertRows(ds,index,index+(records.length-1));},onRemove:function(ds,record,index,isUpdate){if(isUpdate!==true){this.fireEvent("beforerowremoved",this,index,record);}
this.removeRow(index);if(isUpdate!==true){this.processRows(index);this.applyEmptyText();this.fireEvent("rowremoved",this,index,record);}},onLoad:function(){this.scrollToTop();},onColWidthChange:function(cm,col,width){this.updateColumnWidth(col,width);},onHeaderChange:function(cm,col,text){this.updateHeaders();},onHiddenChange:function(cm,col,hidden){this.updateColumnHidden(col,hidden);},onColumnMove:function(cm,oldIndex,newIndex){this.indexMap=null;var s=this.getScrollState();this.refresh(true);this.restoreScroll(s);this.afterMove(newIndex);this.grid.fireEvent('columnmove',oldIndex,newIndex);},onColConfigChange:function(){delete this.lastViewWidth;this.indexMap=null;this.refresh(true);},initUI:function(grid){grid.on("headerclick",this.onHeaderClick,this);},initEvents:function(){},onHeaderClick:function(g,index){if(this.headersDisabled||!this.cm.isSortable(index)){return;}
g.stopEditing(true);g.store.sort(this.cm.getDataIndex(index));},onRowOver:function(e,t){var row;if((row=this.findRowIndex(t))!==false){this.addRowClass(row,"x-grid3-row-over");}},onRowOut:function(e,t){var row;if((row=this.findRowIndex(t))!==false&&!e.within(this.getRow(row),true)){this.removeRowClass(row,"x-grid3-row-over");}},handleWheel:function(e){e.stopPropagation();},onRowSelect:function(row){this.addRowClass(row,"x-grid3-row-selected");},onRowDeselect:function(row){this.removeRowClass(row,"x-grid3-row-selected");},onCellSelect:function(row,col){var cell=this.getCell(row,col);if(cell){this.fly(cell).addClass("x-grid3-cell-selected");}},onCellDeselect:function(row,col){var cell=this.getCell(row,col);if(cell){this.fly(cell).removeClass("x-grid3-cell-selected");}},onColumnSplitterMoved:function(i,w){this.userResized=true;var cm=this.grid.colModel;cm.setColumnWidth(i,w,true);if(this.forceFit){this.fitColumns(true,false,i);this.updateAllColumnWidths();}else{this.updateColumnWidth(i,w);this.syncHeaderScroll();}
this.grid.fireEvent("columnresize",i,w);},handleHdMenuClick:function(item){var index=this.hdCtxIndex;var cm=this.cm,ds=this.ds;switch(item.id){case"asc":ds.sort(cm.getDataIndex(index),"ASC");break;case"desc":ds.sort(cm.getDataIndex(index),"DESC");break;default:index=cm.getIndexById(item.id.substr(4));if(index!=-1){if(item.checked&&cm.getColumnsBy(this.isHideableColumn,this).length<=1){this.onDenyColumnHide();return false;}
cm.setHidden(index,item.checked);}}
return true;},isHideableColumn:function(c){return!c.hidden&&!c.fixed;},beforeColMenuShow:function(){var cm=this.cm,colCount=cm.getColumnCount();this.colMenu.removeAll();for(var i=0;i<colCount;i++){if(cm.config[i].fixed!==true&&cm.config[i].hideable!==false){this.colMenu.add(new Ext.menu.CheckItem({id:"col-"+cm.getColumnId(i),text:cm.getColumnHeader(i),checked:!cm.isHidden(i),hideOnClick:false,disabled:cm.config[i].hideable===false}));}}},handleHdDown:function(e,t){if(Ext.fly(t).hasClass('x-grid3-hd-btn')){e.stopEvent();var hd=this.findHeaderCell(t);Ext.fly(hd).addClass('x-grid3-hd-menu-open');var index=this.getCellIndex(hd);this.hdCtxIndex=index;var ms=this.hmenu.items,cm=this.cm;ms.get("asc").setDisabled(!cm.isSortable(index));ms.get("desc").setDisabled(!cm.isSortable(index));this.hmenu.on("hide",function(){Ext.fly(hd).removeClass('x-grid3-hd-menu-open');},this,{single:true});this.hmenu.show(t,"tl-bl?");}},handleHdOver:function(e,t){var hd=this.findHeaderCell(t);if(hd&&!this.headersDisabled){this.activeHd=hd;this.activeHdIndex=this.getCellIndex(hd);var fly=this.fly(hd);this.activeHdRegion=fly.getRegion();if(!this.cm.isMenuDisabled(this.activeHdIndex)){fly.addClass("x-grid3-hd-over");this.activeHdBtn=fly.child('.x-grid3-hd-btn');if(this.activeHdBtn){this.activeHdBtn.dom.style.height=(hd.firstChild.offsetHeight-1)+'px';}}}},handleHdMove:function(e,t){if(this.activeHd&&!this.headersDisabled){var hw=this.splitHandleWidth||5;var r=this.activeHdRegion;var x=e.getPageX();var ss=this.activeHd.style;if(x-r.left<=hw&&this.cm.isResizable(this.activeHdIndex-1)){ss.cursor=Ext.isAir?'move':Ext.isWebKit?'e-resize':'col-resize';}else if(r.right-x<=(!this.activeHdBtn?hw:2)&&this.cm.isResizable(this.activeHdIndex)){ss.cursor=Ext.isAir?'move':Ext.isWebKit?'w-resize':'col-resize';}else{ss.cursor='';}}},handleHdOut:function(e,t){var hd=this.findHeaderCell(t);if(hd&&(!Ext.isIE||!e.within(hd,true))){this.activeHd=null;this.fly(hd).removeClass("x-grid3-hd-over");hd.style.cursor='';}},hasRows:function(){var fc=this.mainBody.dom.firstChild;return fc&&fc.nodeType==1&&fc.className!='x-grid-empty';},bind:function(d,c){this.initData(d,c);}});Ext.grid.GridView.SplitDragZone=function(grid,hd){this.grid=grid;this.view=grid.getView();this.marker=this.view.resizeMarker;this.proxy=this.view.resizeProxy;Ext.grid.GridView.SplitDragZone.superclass.constructor.call(this,hd,"gridSplitters"+this.grid.getGridEl().id,{dragElId:Ext.id(this.proxy.dom),resizeFrame:false});this.scroll=false;this.hw=this.view.splitHandleWidth||5;};Ext.extend(Ext.grid.GridView.SplitDragZone,Ext.dd.DDProxy,{b4StartDrag:function(x,y){this.view.headersDisabled=true;var h=this.view.mainWrap.getHeight();this.marker.setHeight(h);this.marker.show();this.marker.alignTo(this.view.getHeaderCell(this.cellIndex),'tl-tl',[-2,0]);this.proxy.setHeight(h);var w=this.cm.getColumnWidth(this.cellIndex);var minw=Math.max(w-this.grid.minColumnWidth,0);this.resetConstraints();this.setXConstraint(minw,1000);this.setYConstraint(0,0);this.minX=x-minw;this.maxX=x+1000;this.startPos=x;Ext.dd.DDProxy.prototype.b4StartDrag.call(this,x,y);},handleMouseDown:function(e){var t=this.view.findHeaderCell(e.getTarget());if(t){var xy=this.view.fly(t).getXY(),x=xy[0],y=xy[1];var exy=e.getXY(),ex=exy[0],ey=exy[1];var w=t.offsetWidth,adjust=false;if((ex-x)<=this.hw){adjust=-1;}else if((x+w)-ex<=this.hw){adjust=0;}
if(adjust!==false){this.cm=this.grid.colModel;var ci=this.view.getCellIndex(t);if(adjust==-1){if(ci+adjust<0){return;}
while(this.cm.isHidden(ci+adjust)){--adjust;if(ci+adjust<0){return;}}}
this.cellIndex=ci+adjust;this.split=t.dom;if(this.cm.isResizable(this.cellIndex)&&!this.cm.isFixed(this.cellIndex)){Ext.grid.GridView.SplitDragZone.superclass.handleMouseDown.apply(this,arguments);}}else if(this.view.columnDrag){this.view.columnDrag.callHandleMouseDown(e);}}},endDrag:function(e){this.marker.hide();var v=this.view;var endX=Math.max(this.minX,e.getPageX());var diff=endX-this.startPos;v.onColumnSplitterMoved(this.cellIndex,this.cm.getColumnWidth(this.cellIndex)+diff);setTimeout(function(){v.headersDisabled=false;},50);},autoOffset:function(){this.setDelta(0,0);}});

Ext.grid.ColumnModel=function(config){this.defaultWidth=100;this.defaultSortable=false;if(config.columns){Ext.apply(this,config);this.setConfig(config.columns,true);}else{this.setConfig(config,true);}
this.addEvents("widthchange","headerchange","hiddenchange","columnmoved","columnlockchange","configchange");Ext.grid.ColumnModel.superclass.constructor.call(this);};Ext.extend(Ext.grid.ColumnModel,Ext.util.Observable,{getColumnId:function(index){return this.config[index].id;},setConfig:function(config,initial){if(!initial){delete this.totalWidth;for(var i=0,len=this.config.length;i<len;i++){var c=this.config[i];if(c.editor){c.editor.destroy();}}}
this.config=config;this.lookup={};for(var i=0,len=config.length;i<len;i++){var c=config[i];if(typeof c.renderer=="string"){c.renderer=Ext.util.Format[c.renderer];}
if(typeof c.id=="undefined"){c.id=i;}
if(c.editor&&c.editor.isFormField){c.editor=new Ext.grid.GridEditor(c.editor);}
this.lookup[c.id]=c;}
if(!initial){this.fireEvent('configchange',this);}},getColumnById:function(id){return this.lookup[id];},getIndexById:function(id){for(var i=0,len=this.config.length;i<len;i++){if(this.config[i].id==id){return i;}}
return-1;},moveColumn:function(oldIndex,newIndex){var c=this.config[oldIndex];this.config.splice(oldIndex,1);this.config.splice(newIndex,0,c);this.dataMap=null;this.fireEvent("columnmoved",this,oldIndex,newIndex);},isLocked:function(colIndex){return this.config[colIndex].locked===true;},setLocked:function(colIndex,value,suppressEvent){if(this.isLocked(colIndex)==value){return;}
this.config[colIndex].locked=value;if(!suppressEvent){this.fireEvent("columnlockchange",this,colIndex,value);}},getTotalLockedWidth:function(){var totalWidth=0;for(var i=0;i<this.config.length;i++){if(this.isLocked(i)&&!this.isHidden(i)){this.totalWidth+=this.getColumnWidth(i);}}
return totalWidth;},getLockedCount:function(){for(var i=0,len=this.config.length;i<len;i++){if(!this.isLocked(i)){return i;}}},getColumnCount:function(visibleOnly){if(visibleOnly===true){var c=0;for(var i=0,len=this.config.length;i<len;i++){if(!this.isHidden(i)){c++;}}
return c;}
return this.config.length;},getColumnsBy:function(fn,scope){var r=[];for(var i=0,len=this.config.length;i<len;i++){var c=this.config[i];if(fn.call(scope||this,c,i)===true){r[r.length]=c;}}
return r;},isSortable:function(col){if(typeof this.config[col].sortable=="undefined"){return this.defaultSortable;}
return this.config[col].sortable;},isMenuDisabled:function(col){return!!this.config[col].menuDisabled;},getRenderer:function(col){if(!this.config[col].renderer){return Ext.grid.ColumnModel.defaultRenderer;}
return this.config[col].renderer;},setRenderer:function(col,fn){this.config[col].renderer=fn;},getColumnWidth:function(col){return this.config[col].width||this.defaultWidth;},setColumnWidth:function(col,width,suppressEvent){this.config[col].width=width;this.totalWidth=null;if(!suppressEvent){this.fireEvent("widthchange",this,col,width);}},getTotalWidth:function(includeHidden){if(!this.totalWidth){this.totalWidth=0;for(var i=0,len=this.config.length;i<len;i++){if(includeHidden||!this.isHidden(i)){this.totalWidth+=this.getColumnWidth(i);}}}
return this.totalWidth;},getColumnHeader:function(col){return this.config[col].header;},setColumnHeader:function(col,header){this.config[col].header=header;this.fireEvent("headerchange",this,col,header);},getColumnTooltip:function(col){return this.config[col].tooltip;},setColumnTooltip:function(col,tooltip){this.config[col].tooltip=tooltip;},getDataIndex:function(col){return this.config[col].dataIndex;},setDataIndex:function(col,dataIndex){this.config[col].dataIndex=dataIndex;},findColumnIndex:function(dataIndex){var c=this.config;for(var i=0,len=c.length;i<len;i++){if(c[i].dataIndex==dataIndex){return i;}}
return-1;},isCellEditable:function(colIndex,rowIndex){return(this.config[colIndex].editable||(typeof this.config[colIndex].editable=="undefined"&&this.config[colIndex].editor))?true:false;},getCellEditor:function(colIndex,rowIndex){return this.config[colIndex].editor;},setEditable:function(col,editable){this.config[col].editable=editable;},isHidden:function(colIndex){return this.config[colIndex].hidden;},isFixed:function(colIndex){return this.config[colIndex].fixed;},isResizable:function(colIndex){return colIndex>=0&&this.config[colIndex].resizable!==false&&this.config[colIndex].fixed!==true;},setHidden:function(colIndex,hidden){var c=this.config[colIndex];if(c.hidden!==hidden){c.hidden=hidden;this.totalWidth=null;this.fireEvent("hiddenchange",this,colIndex,hidden);}},setEditor:function(col,editor){Ext.destroy(this.config[col].editor);this.config[col].editor=editor;},destroy:function(){var c=this.config;for(var i=0,c=this.config,len=c.length;i<len;i++){Ext.destroy(c[i].editor);}
this.purgeListeners();}});Ext.grid.ColumnModel.defaultRenderer=function(value){if(typeof value=="string"&&value.length<1){return"&#160;";}
return value;};Ext.grid.DefaultColumnModel=Ext.grid.ColumnModel;

Ext.grid.AbstractSelectionModel=function(){this.locked=false;Ext.grid.AbstractSelectionModel.superclass.constructor.call(this);};Ext.extend(Ext.grid.AbstractSelectionModel,Ext.util.Observable,{init:function(grid){this.grid=grid;this.initEvents();},lock:function(){this.locked=true;},unlock:function(){this.locked=false;},isLocked:function(){return this.locked;},destroy:function(){this.purgeListeners();}});

Ext.grid.RowSelectionModel=function(config){Ext.apply(this,config);this.selections=new Ext.util.MixedCollection(false,function(o){return o.id;});this.last=false;this.lastActive=false;this.addEvents("selectionchange","beforerowselect","rowselect","rowdeselect");Ext.grid.RowSelectionModel.superclass.constructor.call(this);};Ext.extend(Ext.grid.RowSelectionModel,Ext.grid.AbstractSelectionModel,{singleSelect:false,initEvents:function(){if(!this.grid.enableDragDrop&&!this.grid.enableDrag){this.grid.on("rowmousedown",this.handleMouseDown,this);}
this.rowNav=new Ext.KeyNav(this.grid.getGridEl(),{"up":function(e){if(!e.shiftKey||this.singleSelect){this.selectPrevious(false);}else if(this.last!==false&&this.lastActive!==false){var last=this.last;this.selectRange(this.last,this.lastActive-1);this.grid.getView().focusRow(this.lastActive);if(last!==false){this.last=last;}}else{this.selectFirstRow();}},"down":function(e){if(!e.shiftKey||this.singleSelect){this.selectNext(false);}else if(this.last!==false&&this.lastActive!==false){var last=this.last;this.selectRange(this.last,this.lastActive+1);this.grid.getView().focusRow(this.lastActive);if(last!==false){this.last=last;}}else{this.selectFirstRow();}},scope:this});var view=this.grid.view;view.on("refresh",this.onRefresh,this);view.on("rowupdated",this.onRowUpdated,this);view.on("rowremoved",this.onRemove,this);},onRefresh:function(){var ds=this.grid.store,index;var s=this.getSelections();this.clearSelections(true);for(var i=0,len=s.length;i<len;i++){var r=s[i];if((index=ds.indexOfId(r.id))!=-1){this.selectRow(index,true);}}
if(s.length!=this.selections.getCount()){this.fireEvent("selectionchange",this);}},onRemove:function(v,index,r){if(this.selections.remove(r)!==false){this.fireEvent('selectionchange',this);}},onRowUpdated:function(v,index,r){if(this.isSelected(r)){v.onRowSelect(index);}},selectRecords:function(records,keepExisting){if(!keepExisting){this.clearSelections();}
var ds=this.grid.store;for(var i=0,len=records.length;i<len;i++){this.selectRow(ds.indexOf(records[i]),true);}},getCount:function(){return this.selections.length;},selectFirstRow:function(){this.selectRow(0);},selectLastRow:function(keepExisting){this.selectRow(this.grid.store.getCount()-1,keepExisting);},selectNext:function(keepExisting){if(this.hasNext()){this.selectRow(this.last+1,keepExisting);this.grid.getView().focusRow(this.last);return true;}
return false;},selectPrevious:function(keepExisting){if(this.hasPrevious()){this.selectRow(this.last-1,keepExisting);this.grid.getView().focusRow(this.last);return true;}
return false;},hasNext:function(){return this.last!==false&&(this.last+1)<this.grid.store.getCount();},hasPrevious:function(){return!!this.last;},getSelections:function(){return[].concat(this.selections.items);},getSelected:function(){return this.selections.itemAt(0);},each:function(fn,scope){var s=this.getSelections();for(var i=0,len=s.length;i<len;i++){if(fn.call(scope||this,s[i],i)===false){return false;}}
return true;},clearSelections:function(fast){if(this.isLocked())return;if(fast!==true){var ds=this.grid.store;var s=this.selections;s.each(function(r){this.deselectRow(ds.indexOfId(r.id));},this);s.clear();}else{this.selections.clear();}
this.last=false;},selectAll:function(){if(this.isLocked())return;this.selections.clear();for(var i=0,len=this.grid.store.getCount();i<len;i++){this.selectRow(i,true);}},hasSelection:function(){return this.selections.length>0;},isSelected:function(index){var r=typeof index=="number"?this.grid.store.getAt(index):index;return(r&&this.selections.key(r.id)?true:false);},isIdSelected:function(id){return(this.selections.key(id)?true:false);},handleMouseDown:function(g,rowIndex,e){if(e.button!==0||this.isLocked()){return;};var view=this.grid.getView();if(e.shiftKey&&!this.singleSelect&&this.last!==false){var last=this.last;this.selectRange(last,rowIndex,e.ctrlKey);this.last=last;view.focusRow(rowIndex);}else{var isSelected=this.isSelected(rowIndex);if(e.ctrlKey&&isSelected){this.deselectRow(rowIndex);}else if(!isSelected||this.getCount()>1){this.selectRow(rowIndex,e.ctrlKey||e.shiftKey);view.focusRow(rowIndex);}}},selectRows:function(rows,keepExisting){if(!keepExisting){this.clearSelections();}
for(var i=0,len=rows.length;i<len;i++){this.selectRow(rows[i],true);}},selectRange:function(startRow,endRow,keepExisting){if(this.isLocked())return;if(!keepExisting){this.clearSelections();}
if(startRow<=endRow){for(var i=startRow;i<=endRow;i++){this.selectRow(i,true);}}else{for(var i=startRow;i>=endRow;i--){this.selectRow(i,true);}}},deselectRange:function(startRow,endRow,preventViewNotify){if(this.isLocked())return;for(var i=startRow;i<=endRow;i++){this.deselectRow(i,preventViewNotify);}},selectRow:function(index,keepExisting,preventViewNotify){if(this.isLocked()||(index<0||index>=this.grid.store.getCount())||(keepExisting&&this.isSelected(index))){return;}
var r=this.grid.store.getAt(index);if(r&&this.fireEvent("beforerowselect",this,index,keepExisting,r)!==false){if(!keepExisting||this.singleSelect){this.clearSelections();}
this.selections.add(r);this.last=this.lastActive=index;if(!preventViewNotify){this.grid.getView().onRowSelect(index);}
this.fireEvent("rowselect",this,index,r);this.fireEvent("selectionchange",this);}},deselectRow:function(index,preventViewNotify){if(this.isLocked())return;if(this.last==index){this.last=false;}
if(this.lastActive==index){this.lastActive=false;}
var r=this.grid.store.getAt(index);if(r){this.selections.remove(r);if(!preventViewNotify){this.grid.getView().onRowDeselect(index);}
this.fireEvent("rowdeselect",this,index,r);this.fireEvent("selectionchange",this);}},restoreLast:function(){if(this._last){this.last=this._last;}},acceptsNav:function(row,col,cm){return!cm.isHidden(col)&&cm.isCellEditable(col,row);},onEditorKey:function(field,e){var k=e.getKey(),newCell,g=this.grid,ed=g.activeEditor;var shift=e.shiftKey;if(k==e.TAB){e.stopEvent();ed.completeEdit();if(shift){newCell=g.walkCells(ed.row,ed.col-1,-1,this.acceptsNav,this);}else{newCell=g.walkCells(ed.row,ed.col+1,1,this.acceptsNav,this);}}else if(k==e.ENTER){e.stopEvent();ed.completeEdit();if(this.moveEditorOnEnter!==false){if(shift){newCell=g.walkCells(ed.row-1,ed.col,-1,this.acceptsNav,this);}else{newCell=g.walkCells(ed.row+1,ed.col,1,this.acceptsNav,this);}}}else if(k==e.ESC){ed.cancelEdit();}
if(newCell){g.startEditing(newCell[0],newCell[1]);}},destroy:function(){if(this.rowNav){this.rowNav.disable();this.rowNav=null;}
Ext.grid.RowSelectionModel.superclass.destroy.call(this);}});

Ext.grid.CellSelectionModel=function(config){Ext.apply(this,config);this.selection=null;this.addEvents("beforecellselect","cellselect","selectionchange");Ext.grid.CellSelectionModel.superclass.constructor.call(this);};Ext.extend(Ext.grid.CellSelectionModel,Ext.grid.AbstractSelectionModel,{initEvents:function(){this.grid.on("cellmousedown",this.handleMouseDown,this);this.grid.getGridEl().on(Ext.isIE||(Ext.isWebKit&&!Ext.isSafari2)?"keydown":"keypress",this.handleKeyDown,this);var view=this.grid.view;view.on("refresh",this.onViewChange,this);view.on("rowupdated",this.onRowUpdated,this);view.on("beforerowremoved",this.clearSelections,this);view.on("beforerowsinserted",this.clearSelections,this);if(this.grid.isEditor){this.grid.on("beforeedit",this.beforeEdit,this);}},beforeEdit:function(e){this.select(e.row,e.column,false,true,e.record);},onRowUpdated:function(v,index,r){if(this.selection&&this.selection.record==r){v.onCellSelect(index,this.selection.cell[1]);}},onViewChange:function(){this.clearSelections(true);},getSelectedCell:function(){return this.selection?this.selection.cell:null;},clearSelections:function(preventNotify){var s=this.selection;if(s){if(preventNotify!==true){this.grid.view.onCellDeselect(s.cell[0],s.cell[1]);}
this.selection=null;this.fireEvent("selectionchange",this,null);}},hasSelection:function(){return this.selection?true:false;},handleMouseDown:function(g,row,cell,e){if(e.button!==0||this.isLocked()){return;};this.select(row,cell);},select:function(rowIndex,colIndex,preventViewNotify,preventFocus,r){if(this.fireEvent("beforecellselect",this,rowIndex,colIndex)!==false){this.clearSelections();r=r||this.grid.store.getAt(rowIndex);this.selection={record:r,cell:[rowIndex,colIndex]};if(!preventViewNotify){var v=this.grid.getView();v.onCellSelect(rowIndex,colIndex);if(preventFocus!==true){v.focusCell(rowIndex,colIndex);}}
this.fireEvent("cellselect",this,rowIndex,colIndex);this.fireEvent("selectionchange",this,this.selection);}},isSelectable:function(rowIndex,colIndex,cm){return!cm.isHidden(colIndex);},handleKeyDown:function(e){if(!e.isNavKeyPress()){return;}
var g=this.grid,s=this.selection;if(!s){e.stopEvent();var cell=g.walkCells(0,0,1,this.isSelectable,this);if(cell){this.select(cell[0],cell[1]);}
return;}
var sm=this;var walk=function(row,col,step){return g.walkCells(row,col,step,sm.isSelectable,sm);};var k=e.getKey(),r=s.cell[0],c=s.cell[1];var newCell;switch(k){case e.TAB:if(e.shiftKey){newCell=walk(r,c-1,-1);}else{newCell=walk(r,c+1,1);}
break;case e.DOWN:newCell=walk(r+1,c,1);break;case e.UP:newCell=walk(r-1,c,-1);break;case e.RIGHT:newCell=walk(r,c+1,1);break;case e.LEFT:newCell=walk(r,c-1,-1);break;case e.ENTER:if(g.isEditor&&!g.editing){g.startEditing(r,c);e.stopEvent();return;}
break;};if(newCell){this.select(newCell[0],newCell[1]);e.stopEvent();}},acceptsNav:function(row,col,cm){return!cm.isHidden(col)&&cm.isCellEditable(col,row);},onEditorKey:function(field,e){var k=e.getKey(),newCell,g=this.grid,ed=g.activeEditor;if(k==e.TAB){if(e.shiftKey){newCell=g.walkCells(ed.row,ed.col-1,-1,this.acceptsNav,this);}else{newCell=g.walkCells(ed.row,ed.col+1,1,this.acceptsNav,this);}
e.stopEvent();}else if(k==e.ENTER){ed.completeEdit();e.stopEvent();}else if(k==e.ESC){e.stopEvent();ed.cancelEdit();}
if(newCell){g.startEditing(newCell[0],newCell[1]);}}});

Ext.grid.HeaderDragZone=function(grid,hd,hd2){this.grid=grid;this.view=grid.getView();this.ddGroup="gridHeader"+this.grid.getGridEl().id;Ext.grid.HeaderDragZone.superclass.constructor.call(this,hd);if(hd2){this.setHandleElId(Ext.id(hd));this.setOuterHandleElId(Ext.id(hd2));}
this.scroll=false;};Ext.extend(Ext.grid.HeaderDragZone,Ext.dd.DragZone,{maxDragWidth:120,getDragData:function(e){var t=Ext.lib.Event.getTarget(e);var h=this.view.findHeaderCell(t);if(h){return{ddel:h.firstChild,header:h};}
return false;},onInitDrag:function(e){this.view.headersDisabled=true;var clone=this.dragData.ddel.cloneNode(true);clone.id=Ext.id();clone.style.width=Math.min(this.dragData.header.offsetWidth,this.maxDragWidth)+"px";this.proxy.update(clone);return true;},afterValidDrop:function(){var v=this.view;setTimeout(function(){v.headersDisabled=false;},50);},afterInvalidDrop:function(){var v=this.view;setTimeout(function(){v.headersDisabled=false;},50);}});Ext.grid.HeaderDropZone=function(grid,hd,hd2){this.grid=grid;this.view=grid.getView();this.proxyTop=Ext.DomHelper.append(document.body,{cls:"col-move-top",html:"&#160;"},true);this.proxyBottom=Ext.DomHelper.append(document.body,{cls:"col-move-bottom",html:"&#160;"},true);this.proxyTop.hide=this.proxyBottom.hide=function(){this.setLeftTop(-100,-100);this.setStyle("visibility","hidden");};this.ddGroup="gridHeader"+this.grid.getGridEl().id;Ext.grid.HeaderDropZone.superclass.constructor.call(this,grid.getGridEl().dom);};Ext.extend(Ext.grid.HeaderDropZone,Ext.dd.DropZone,{proxyOffsets:[-4,-9],fly:Ext.Element.fly,getTargetFromEvent:function(e){var t=Ext.lib.Event.getTarget(e);var cindex=this.view.findCellIndex(t);if(cindex!==false){return this.view.getHeaderCell(cindex);}},nextVisible:function(h){var v=this.view,cm=this.grid.colModel;h=h.nextSibling;while(h){if(!cm.isHidden(v.getCellIndex(h))){return h;}
h=h.nextSibling;}
return null;},prevVisible:function(h){var v=this.view,cm=this.grid.colModel;h=h.prevSibling;while(h){if(!cm.isHidden(v.getCellIndex(h))){return h;}
h=h.prevSibling;}
return null;},positionIndicator:function(h,n,e){var x=Ext.lib.Event.getPageX(e);var r=Ext.lib.Dom.getRegion(n.firstChild);var px,pt,py=r.top+this.proxyOffsets[1];if((r.right-x)<=(r.right-r.left)/2){px=r.right+this.view.borderWidth;pt="after";}else{px=r.left;pt="before";}
var oldIndex=this.view.getCellIndex(h);var newIndex=this.view.getCellIndex(n);if(this.grid.colModel.isFixed(newIndex)){return false;}
var locked=this.grid.colModel.isLocked(newIndex);if(pt=="after"){newIndex++;}
if(oldIndex<newIndex){newIndex--;}
if(oldIndex==newIndex&&(locked==this.grid.colModel.isLocked(oldIndex))){return false;}
px+=this.proxyOffsets[0];this.proxyTop.setLeftTop(px,py);this.proxyTop.show();if(!this.bottomOffset){this.bottomOffset=this.view.mainHd.getHeight();}
this.proxyBottom.setLeftTop(px,py+this.proxyTop.dom.offsetHeight+this.bottomOffset);this.proxyBottom.show();return pt;},onNodeEnter:function(n,dd,e,data){if(data.header!=n){this.positionIndicator(data.header,n,e);}},onNodeOver:function(n,dd,e,data){var result=false;if(data.header!=n){result=this.positionIndicator(data.header,n,e);}
if(!result){this.proxyTop.hide();this.proxyBottom.hide();}
return result?this.dropAllowed:this.dropNotAllowed;},onNodeOut:function(n,dd,e,data){this.proxyTop.hide();this.proxyBottom.hide();},onNodeDrop:function(n,dd,e,data){var h=data.header;if(h!=n){var cm=this.grid.colModel;var x=Ext.lib.Event.getPageX(e);var r=Ext.lib.Dom.getRegion(n.firstChild);var pt=(r.right-x)<=((r.right-r.left)/2)?"after":"before";var oldIndex=this.view.getCellIndex(h);var newIndex=this.view.getCellIndex(n);var locked=cm.isLocked(newIndex);if(pt=="after"){newIndex++;}
if(oldIndex<newIndex){newIndex--;}
if(oldIndex==newIndex&&(locked==cm.isLocked(oldIndex))){return false;}
cm.setLocked(oldIndex,locked,true);cm.moveColumn(oldIndex,newIndex);this.grid.fireEvent("columnmove",oldIndex,newIndex);return true;}
return false;}});Ext.grid.GridView.ColumnDragZone=function(grid,hd){Ext.grid.GridView.ColumnDragZone.superclass.constructor.call(this,grid,hd,null);this.proxy.el.addClass('x-grid3-col-dd');};Ext.extend(Ext.grid.GridView.ColumnDragZone,Ext.grid.HeaderDragZone,{handleMouseDown:function(e){},callHandleMouseDown:function(e){Ext.grid.GridView.ColumnDragZone.superclass.handleMouseDown.call(this,e);}});

Ext.grid.SplitDragZone=function(grid,hd,hd2){this.grid=grid;this.view=grid.getView();this.proxy=this.view.resizeProxy;Ext.grid.SplitDragZone.superclass.constructor.call(this,hd,"gridSplitters"+this.grid.getGridEl().id,{dragElId:Ext.id(this.proxy.dom),resizeFrame:false});this.setHandleElId(Ext.id(hd));this.setOuterHandleElId(Ext.id(hd2));this.scroll=false;};Ext.extend(Ext.grid.SplitDragZone,Ext.dd.DDProxy,{fly:Ext.Element.fly,b4StartDrag:function(x,y){this.view.headersDisabled=true;this.proxy.setHeight(this.view.mainWrap.getHeight());var w=this.cm.getColumnWidth(this.cellIndex);var minw=Math.max(w-this.grid.minColumnWidth,0);this.resetConstraints();this.setXConstraint(minw,1000);this.setYConstraint(0,0);this.minX=x-minw;this.maxX=x+1000;this.startPos=x;Ext.dd.DDProxy.prototype.b4StartDrag.call(this,x,y);},handleMouseDown:function(e){ev=Ext.EventObject.setEvent(e);var t=this.fly(ev.getTarget());if(t.hasClass("x-grid-split")){this.cellIndex=this.view.getCellIndex(t.dom);this.split=t.dom;this.cm=this.grid.colModel;if(this.cm.isResizable(this.cellIndex)&&!this.cm.isFixed(this.cellIndex)){Ext.grid.SplitDragZone.superclass.handleMouseDown.apply(this,arguments);}}},endDrag:function(e){this.view.headersDisabled=false;var endX=Math.max(this.minX,Ext.lib.Event.getPageX(e));var diff=endX-this.startPos;this.view.onColumnSplitterMoved(this.cellIndex,this.cm.getColumnWidth(this.cellIndex)+diff);},autoOffset:function(){this.setDelta(0,0);}});

Ext.grid.GridDragZone=function(grid,config){this.view=grid.getView();Ext.grid.GridDragZone.superclass.constructor.call(this,this.view.mainBody.dom,config);if(this.view.lockedBody){this.setHandleElId(Ext.id(this.view.mainBody.dom));this.setOuterHandleElId(Ext.id(this.view.lockedBody.dom));}
this.scroll=false;this.grid=grid;this.ddel=document.createElement('div');this.ddel.className='x-grid-dd-wrap';};Ext.extend(Ext.grid.GridDragZone,Ext.dd.DragZone,{ddGroup:"GridDD",getDragData:function(e){var t=Ext.lib.Event.getTarget(e);var rowIndex=this.view.findRowIndex(t);if(rowIndex!==false){var sm=this.grid.selModel;if(!sm.isSelected(rowIndex)||e.hasModifier()){sm.handleMouseDown(this.grid,rowIndex,e);}
return{grid:this.grid,ddel:this.ddel,rowIndex:rowIndex,selections:sm.getSelections()};}
return false;},onInitDrag:function(e){var data=this.dragData;this.ddel.innerHTML=this.grid.getDragDropText();this.proxy.update(this.ddel);},afterRepair:function(){this.dragging=false;},getRepairXY:function(e,data){return false;},onEndDrag:function(data,e){},onValidDrop:function(dd,e,id){this.hideProxy();},beforeInvalidDrop:function(e,id){}});
