/*
 * Ext JS Library 2.3.0
 * Copyright(c) 2006-2009, Ext JS, LLC.
 * licensing@extjs.com
 * 
 * http://extjs.com/license
 */


Ext.DataView=Ext.extend(Ext.BoxComponent,{selectedClass:"x-view-selected",emptyText:"",deferEmptyText:true,trackOver:false,last:false,initComponent:function(){Ext.DataView.superclass.initComponent.call(this);if(typeof this.tpl=="string"||Ext.isArray(this.tpl)){this.tpl=new Ext.XTemplate(this.tpl);}
this.addEvents("beforeclick","click","mouseenter","mouseleave","containerclick","dblclick","contextmenu","selectionchange","beforeselect");this.all=new Ext.CompositeElementLite();this.selected=new Ext.CompositeElementLite();},onRender:function(){if(!this.el){this.el=document.createElement('div');this.el.id=this.id;}
Ext.DataView.superclass.onRender.apply(this,arguments);},afterRender:function(){Ext.DataView.superclass.afterRender.call(this);this.el.on({"click":this.onClick,"dblclick":this.onDblClick,"contextmenu":this.onContextMenu,scope:this});if(this.overClass||this.trackOver){this.el.on({"mouseover":this.onMouseOver,"mouseout":this.onMouseOut,scope:this});}
if(this.store){this.setStore(this.store,true);}},refresh:function(){this.clearSelections(false,true);this.el.update("");var records=this.store.getRange();if(records.length<1){if(!this.deferEmptyText||this.hasSkippedEmptyText){this.el.update(this.emptyText);}
this.all.clear();}else{this.tpl.overwrite(this.el,this.collectData(records,0));this.all.fill(Ext.query(this.itemSelector,this.el.dom));this.updateIndexes(0);}
this.hasSkippedEmptyText=true;},prepareData:function(data){return data;},collectData:function(records,startIndex){var r=[];for(var i=0,len=records.length;i<len;i++){r[r.length]=this.prepareData(records[i].data,startIndex+i,records[i]);}
return r;},bufferRender:function(records){var div=document.createElement('div');this.tpl.overwrite(div,this.collectData(records));return Ext.query(this.itemSelector,div);},onUpdate:function(ds,record){var index=this.store.indexOf(record);var sel=this.isSelected(index);var original=this.all.elements[index];var node=this.bufferRender([record],index)[0];this.all.replaceElement(index,node,true);if(sel){this.selected.replaceElement(original,node);this.all.item(index).addClass(this.selectedClass);}
this.updateIndexes(index,index);},onAdd:function(ds,records,index){if(this.all.getCount()==0){this.refresh();return;}
var nodes=this.bufferRender(records,index),n,a=this.all.elements;if(index<this.all.getCount()){n=this.all.item(index).insertSibling(nodes,'before',true);a.splice.apply(a,[index,0].concat(nodes));}else{n=this.all.last().insertSibling(nodes,'after',true);a.push.apply(a,nodes);}
this.updateIndexes(index);},onRemove:function(ds,record,index){this.deselect(index);this.all.removeElement(index,true);this.updateIndexes(index);if(this.store.getCount()==0){this.refresh();}},refreshNode:function(index){this.onUpdate(this.store,this.store.getAt(index));},updateIndexes:function(startIndex,endIndex){var ns=this.all.elements;startIndex=startIndex||0;endIndex=endIndex||((endIndex===0)?0:(ns.length-1));for(var i=startIndex;i<=endIndex;i++){ns[i].viewIndex=i;}},getStore:function(){return this.store;},setStore:function(store,initial){if(!initial&&this.store){this.store.un("beforeload",this.onBeforeLoad,this);this.store.un("datachanged",this.refresh,this);this.store.un("add",this.onAdd,this);this.store.un("remove",this.onRemove,this);this.store.un("update",this.onUpdate,this);this.store.un("clear",this.refresh,this);}
if(store){store=Ext.StoreMgr.lookup(store);store.on("beforeload",this.onBeforeLoad,this);store.on("datachanged",this.refresh,this);store.on("add",this.onAdd,this);store.on("remove",this.onRemove,this);store.on("update",this.onUpdate,this);store.on("clear",this.refresh,this);}
this.store=store;if(store){this.refresh();}},findItemFromChild:function(node){return Ext.fly(node).findParent(this.itemSelector,this.el);},onClick:function(e){var item=e.getTarget(this.itemSelector,this.el);if(item){var index=this.indexOf(item);if(this.onItemClick(item,index,e)!==false){this.fireEvent("click",this,index,item,e);}}else{if(this.fireEvent("containerclick",this,e)!==false){this.clearSelections();}}},onContextMenu:function(e){var item=e.getTarget(this.itemSelector,this.el);if(item){this.fireEvent("contextmenu",this,this.indexOf(item),item,e);}},onDblClick:function(e){var item=e.getTarget(this.itemSelector,this.el);if(item){this.fireEvent("dblclick",this,this.indexOf(item),item,e);}},onMouseOver:function(e){var item=e.getTarget(this.itemSelector,this.el);if(item&&item!==this.lastItem){this.lastItem=item;Ext.fly(item).addClass(this.overClass);this.fireEvent("mouseenter",this,this.indexOf(item),item,e);}},onMouseOut:function(e){if(this.lastItem){if(!e.within(this.lastItem,true,true)){Ext.fly(this.lastItem).removeClass(this.overClass);this.fireEvent("mouseleave",this,this.indexOf(this.lastItem),this.lastItem,e);delete this.lastItem;}}},onItemClick:function(item,index,e){if(this.fireEvent("beforeclick",this,index,item,e)===false){return false;}
if(this.multiSelect){this.doMultiSelection(item,index,e);e.preventDefault();}else if(this.singleSelect){this.doSingleSelection(item,index,e);e.preventDefault();}
return true;},doSingleSelection:function(item,index,e){if(e.ctrlKey&&this.isSelected(index)){this.deselect(index);}else{this.select(index,false);}},doMultiSelection:function(item,index,e){if(e.shiftKey&&this.last!==false){var last=this.last;this.selectRange(last,index,e.ctrlKey);this.last=last;}else{if((e.ctrlKey||this.simpleSelect)&&this.isSelected(index)){this.deselect(index);}else{this.select(index,e.ctrlKey||e.shiftKey||this.simpleSelect);}}},getSelectionCount:function(){return this.selected.getCount()},getSelectedNodes:function(){return this.selected.elements;},getSelectedIndexes:function(){var indexes=[],s=this.selected.elements;for(var i=0,len=s.length;i<len;i++){indexes.push(s[i].viewIndex);}
return indexes;},getSelectedRecords:function(){var r=[],s=this.selected.elements;for(var i=0,len=s.length;i<len;i++){r[r.length]=this.store.getAt(s[i].viewIndex);}
return r;},getRecords:function(nodes){var r=[],s=nodes;for(var i=0,len=s.length;i<len;i++){r[r.length]=this.store.getAt(s[i].viewIndex);}
return r;},getRecord:function(node){return this.store.getAt(node.viewIndex);},clearSelections:function(suppressEvent,skipUpdate){if((this.multiSelect||this.singleSelect)&&this.selected.getCount()>0){if(!skipUpdate){this.selected.removeClass(this.selectedClass);}
this.selected.clear();this.last=false;if(!suppressEvent){this.fireEvent("selectionchange",this,this.selected.elements);}}},isSelected:function(node){return this.selected.contains(this.getNode(node));},deselect:function(node){if(this.isSelected(node)){node=this.getNode(node);this.selected.removeElement(node);if(this.last==node.viewIndex){this.last=false;}
Ext.fly(node).removeClass(this.selectedClass);this.fireEvent("selectionchange",this,this.selected.elements);}},select:function(nodeInfo,keepExisting,suppressEvent){if(Ext.isArray(nodeInfo)){if(!keepExisting){this.clearSelections(true);}
for(var i=0,len=nodeInfo.length;i<len;i++){this.select(nodeInfo[i],true,true);}
if(!suppressEvent){this.fireEvent("selectionchange",this,this.selected.elements);}}else{var node=this.getNode(nodeInfo);if(!keepExisting){this.clearSelections(true);}
if(node&&!this.isSelected(node)){if(this.fireEvent("beforeselect",this,node,this.selected.elements)!==false){Ext.fly(node).addClass(this.selectedClass);this.selected.add(node);this.last=node.viewIndex;if(!suppressEvent){this.fireEvent("selectionchange",this,this.selected.elements);}}}}},selectRange:function(start,end,keepExisting){if(!keepExisting){this.clearSelections(true);}
this.select(this.getNodes(start,end),true);},getNode:function(nodeInfo){if(typeof nodeInfo=="string"){return document.getElementById(nodeInfo);}else if(typeof nodeInfo=="number"){return this.all.elements[nodeInfo];}
return nodeInfo;},getNodes:function(start,end){var ns=this.all.elements;start=start||0;end=typeof end=="undefined"?Math.max(ns.length-1,0):end;var nodes=[],i;if(start<=end){for(i=start;i<=end&&ns[i];i++){nodes.push(ns[i]);}}else{for(i=start;i>=end&&ns[i];i--){nodes.push(ns[i]);}}
return nodes;},indexOf:function(node){node=this.getNode(node);if(typeof node.viewIndex=="number"){return node.viewIndex;}
return this.all.indexOf(node);},onBeforeLoad:function(){if(this.loadingText){this.clearSelections(false,true);this.el.update('<div class="loading-indicator">'+this.loadingText+'</div>');this.all.clear();}},onDestroy:function(){Ext.DataView.superclass.onDestroy.call(this);this.setStore(null);}});Ext.reg('dataview',Ext.DataView);