/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgetree.textextraction;

import com.knowledgetree.textextraction.StringHandler;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KTTextExtractor {
    private static KTTextExtractor textExtractor = null;
    private Logger logger = Logger.getLogger((String)"com.knowledgetree.textextraction");

    public static KTTextExtractor get() {
        if (textExtractor == null) {
            textExtractor = new KTTextExtractor();
        }
        return textExtractor;
    }

    private KTTextExtractor() {
        this.logger.info((Object)"Text Extraction starting...");
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int ExtractTextFromFile(String string, String string2) {
        this.logger.debug((Object)("Text Extractor: file in: " + string + "; file out: " + string2));
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
            BodyContentHandler bodyContentHandler = new BodyContentHandler((Writer)outputStreamWriter);
            AutoDetectParser autoDetectParser = new AutoDetectParser();
            Metadata metadata = new Metadata();
            try {
                autoDetectParser.parse((InputStream)fileInputStream, (ContentHandler)bodyContentHandler, metadata);
                outputStreamWriter.close();
                fileInputStream.close();
            }
            catch (Exception exception) {
                this.logger.error((Object)("Text Extractor: Failed with message - " + exception.getMessage()));
                return -1;
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)("Text Extractor: File could not be found - " + exception.getMessage()));
            return -1;
        }
        return 0;
    }

    public Map<String, String> ExtractText(byte[] byArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AutoDetectParser autoDetectParser = new AutoDetectParser();
        StringHandler stringHandler = new StringHandler();
        try {
            autoDetectParser.parse((InputStream)byteArrayInputStream, (ContentHandler)stringHandler, new Metadata());
        }
        catch (Exception exception) {
            hashtable.put("status", "1");
            hashtable.put("message", exception.getMessage());
            return hashtable;
        }
        hashtable.put("status", "0");
        hashtable.put("text", stringHandler.getString());
        return hashtable;
    }
}

