/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgetree.openoffice;

import java.util.Stack;

public abstract class ResourcePool {
    String name;
    Stack availableResources;
    Stack busyResources;

    public ResourcePool(String string) {
        this.name = string;
        this.availableResources = new Stack();
        this.busyResources = new Stack();
    }

    protected abstract Object createNewResource();

    public synchronized Object getResource() {
        Object object = null;
        object = this.availableResources.empty() ? this.createNewResource() : this.availableResources.pop();
        if (object != null) {
            this.busyResources.push(object);
        }
        return object;
    }

    public synchronized void releaseResource(Object object) {
        if (object != null && this.busyResources.remove(object)) {
            this.availableResources.push(object);
        }
    }
}

