/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgetree.openoffice;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import com.knowledgetree.openoffice.ResourcePool;
import java.io.File;
import org.apache.log4j.Logger;

public class KTConverter
extends ResourcePool {
    public static KTConverter ktc = null;
    private Logger logger;
    private int ooPort = 8100;
    private String ooHost = "127.0.0.1";

    public static KTConverter get(String string, int n) {
        if (ktc == null) {
            ktc = new KTConverter(string, n);
        }
        return ktc;
    }

    public KTConverter(String string, int n) {
        super("OfficeManagers");
        this.ooHost = string;
        this.ooPort = n;
        this.logger = Logger.getLogger((String)"com.knowledgetree.openoffice");
        this.logger.info((Object)"JODConverter starting...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ConvertDocument(String string, String string2) {
        SocketOpenOfficeConnection socketOpenOfficeConnection = (SocketOpenOfficeConnection)this.getResource();
        if (socketOpenOfficeConnection == null) {
            this.logger.error((Object)"JODConverter: could not connect to Open Office");
            return -1;
        }
        this.logger.debug((Object)"JODConverter: creating OO Document converter");
        OpenOfficeDocumentConverter openOfficeDocumentConverter = new OpenOfficeDocumentConverter((OpenOfficeConnection)socketOpenOfficeConnection);
        File file = new File(string);
        File file2 = new File(string2);
        try {
            this.logger.debug((Object)("JODConverter: attempting conversion of: " + string + " to: " + string2));
            openOfficeDocumentConverter.convert(file, file2);
        }
        catch (Exception exception) {
            this.logger.error((Object)("JODConverter: failure to convert file with message: " + exception.getMessage()));
            int n = -1;
            return n;
        }
        finally {
            this.logger.debug((Object)"JODConverter: conversion complete, releasing office");
            this.releaseResource(socketOpenOfficeConnection);
        }
        return 0;
    }

    protected Object createNewResource() {
        try {
            SocketOpenOfficeConnection socketOpenOfficeConnection = new SocketOpenOfficeConnection(this.ooHost, this.ooPort);
            socketOpenOfficeConnection.connect();
            this.logger.debug((Object)("JODConverter: connecting to OpenOffice on host: " + this.ooHost + " and port: " + this.ooPort));
            return socketOpenOfficeConnection;
        }
        catch (Exception exception) {
            this.logger.error((Object)("JODConverter: failed to connect to OpenOffice on host: " + this.ooHost + " and port: " + this.ooPort + " with message: " + exception.getMessage()));
            return null;
        }
    }
}

