/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgetree.metadata;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.hpsf.CustomProperties;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class KTMetaData {
    private static KTMetaData metaDataHandler = null;
    private Logger logger = Logger.getLogger((String)"com.knowledgetree.metadata");

    private KTMetaData() {
        this.logger.info((Object)"Properties handler starting...");
    }

    public static KTMetaData get() {
        if (metaDataHandler == null) {
            metaDataHandler = new KTMetaData();
        }
        return metaDataHandler;
    }

    public int writeMetadata(String string, String string2, Map map) {
        Object object;
        DocumentSummaryInformation documentSummaryInformation;
        Object object2;
        Object object3;
        DocumentEntry documentEntry;
        POIFSFileSystem pOIFSFileSystem;
        FileInputStream fileInputStream;
        this.logger.debug((Object)("POI Properties: Write metadata to file " + string));
        try {
            fileInputStream = new FileInputStream(string);
            pOIFSFileSystem = new POIFSFileSystem((InputStream)fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            this.logger.error((Object)("POI Properties: Input file could not be opened: " + exception.getMessage()));
            exception.printStackTrace();
            return -1;
        }
        fileInputStream = pOIFSFileSystem.getRoot();
        try {
            documentEntry = (DocumentEntry)fileInputStream.getEntry("\u0005DocumentSummaryInformation");
            object3 = new DocumentInputStream(documentEntry);
            object2 = new PropertySet((InputStream)object3);
            object3.close();
            documentSummaryInformation = new DocumentSummaryInformation((PropertySet)object2);
        }
        catch (Exception exception) {
            documentSummaryInformation = PropertySetFactory.newDocumentSummaryInformation();
            this.logger.debug((Object)("POI Properties: Creating new document summary information: " + exception.getMessage()));
        }
        documentEntry = documentSummaryInformation.getCustomProperties();
        if (documentEntry == null) {
            documentEntry = new CustomProperties();
        }
        object3 = map.keySet();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            String string3 = (String)map.get(object);
            documentEntry.put((String)object, string3);
        }
        documentSummaryInformation.setCustomProperties((CustomProperties)documentEntry);
        try {
            documentSummaryInformation.write((DirectoryEntry)fileInputStream, "\u0005DocumentSummaryInformation");
        }
        catch (Exception exception) {
            this.logger.error((Object)("POI Properties: Could not write custom properties to document summary information: " + exception.getMessage()));
            exception.printStackTrace();
            return -1;
        }
        try {
            object = new FileOutputStream(string2);
            pOIFSFileSystem.writeFilesystem((OutputStream)object);
            ((FileOutputStream)object).close();
        }
        catch (Exception exception) {
            this.logger.error((Object)("POI Properties: Could not write output to file: " + exception.getMessage()));
            exception.printStackTrace();
            return -1;
        }
        return 0;
    }

    public Map readMetadata(String string) {
        DocumentSummaryInformation documentSummaryInformation;
        Object object;
        Object object2;
        DocumentEntry documentEntry;
        POIFSFileSystem pOIFSFileSystem;
        FileInputStream fileInputStream;
        this.logger.debug((Object)("POI Properties: Read metadata from file " + string));
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            fileInputStream = new FileInputStream(string);
            pOIFSFileSystem = new POIFSFileSystem((InputStream)fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            this.logger.error((Object)("POI Properties: Input file could not be opened: " + exception.getMessage()));
            exception.printStackTrace();
            hashtable.put("status", "1");
            return hashtable;
        }
        fileInputStream = pOIFSFileSystem.getRoot();
        try {
            documentEntry = (DocumentEntry)fileInputStream.getEntry("\u0005DocumentSummaryInformation");
            object2 = new DocumentInputStream(documentEntry);
            object = new PropertySet((InputStream)object2);
            object2.close();
            documentSummaryInformation = new DocumentSummaryInformation((PropertySet)object);
        }
        catch (Exception exception) {
            documentSummaryInformation = PropertySetFactory.newDocumentSummaryInformation();
            this.logger.debug((Object)("POI Properties: Creating new document summary information: " + exception.getMessage()));
        }
        documentEntry = documentSummaryInformation.getCustomProperties();
        object2 = new Hashtable();
        if (documentEntry == null) {
            this.logger.debug((Object)"POI Properties: No custom properties have been defined.");
            hashtable.put("status", "0");
            hashtable.put("metadata", object2);
            return hashtable;
        }
        object = documentEntry.keySet();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)documentEntry.get(string2);
            ((Hashtable)object2).put(string2, string3);
        }
        hashtable.put("status", "0");
        hashtable.put("metadata", object2);
        return hashtable;
    }
}

