/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgetree.lucene;

import com.knowledgetree.indexer.IndexerInterface;
import com.knowledgetree.indexer.IndexerManager;
import com.knowledgetree.lucene.KTLuceneServerInterface;
import com.knowledgetree.metadata.KTMetaDataInterface;
import com.knowledgetree.openoffice.KTConverterInterface;
import com.knowledgetree.textextraction.KTTextExtractorInterface;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.xmlrpc.server.PropertyHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcServerConfigImpl;
import org.apache.xmlrpc.server.XmlRpcStreamServer;
import org.apache.xmlrpc.webserver.WebServer;

public class KTLuceneServer {
    public static WebServer webServer;
    private static KTLuceneServer luceneServer;
    public static final String KnowledgeTreeLoggingProperties = "KnowledgeTreeIndexer.Logging.properties";
    private Logger logger = Logger.getLogger((String)"com.knowledgetree");
    private int port = 8875;
    private boolean paranoid = true;
    private String clientIps = "127.0.0.1,192.168.1.1";
    private String propertiesFilename = "KnowledgeTreeIndexer.properties";
    private String authenticationToken = "";

    public static void main(String[] stringArray) throws Exception {
        Object object;
        String[] stringArray2;
        PropertyConfigurator.configure((String)KnowledgeTreeLoggingProperties);
        KTLuceneServer kTLuceneServer = KTLuceneServer.get();
        webServer = new WebServer(kTLuceneServer.getPort());
        if (kTLuceneServer.isParanoid()) {
            kTLuceneServer.getLogger().info((Object)"Server in paranoid mode!");
            webServer.setParanoid(true);
            stringArray2 = kTLuceneServer.getAcceptableIps();
            for (int i = 0; i < stringArray2.length; ++i) {
                object = stringArray2[i];
                kTLuceneServer.getLogger().info((Object)("\tAccepting connections from: " + (String)object));
                webServer.acceptClient((String)object);
            }
        } else {
            kTLuceneServer.getLogger().info((Object)"Server trusting everyone!");
        }
        stringArray2 = IndexerManager.get();
        XmlRpcStreamServer xmlRpcStreamServer = webServer.getXmlRpcServer();
        object = new PropertyHandlerMapping();
        object.addHandler("indexer", IndexerInterface.class);
        object.addHandler("textextraction", KTTextExtractorInterface.class);
        object.addHandler("metadata", KTMetaDataInterface.class);
        object.addHandler("openoffice", KTConverterInterface.class);
        object.addHandler("control", KTLuceneServerInterface.class);
        xmlRpcStreamServer.setHandlerMapping((XmlRpcHandlerMapping)object);
        XmlRpcServerConfigImpl xmlRpcServerConfigImpl = (XmlRpcServerConfigImpl)xmlRpcStreamServer.getConfig();
        xmlRpcServerConfigImpl.setEnabledForExtensions(true);
        xmlRpcServerConfigImpl.setContentLengthOptional(false);
        kTLuceneServer.getLogger().info((Object)("Starting web server on port: " + kTLuceneServer.getPort()));
        webServer.start();
    }

    public KTLuceneServer() {
        this.logger.info((Object)"XML-RPC Server starting up...");
        this.logger.info((Object)("Loading properties file: " + this.propertiesFilename));
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(this.propertiesFilename);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            this.logger.error((Object)("Problem loading properties: " + exception.getMessage()));
            this.logger.error((Object)"Shutting down");
            System.exit(1);
        }
        this.port = Integer.parseInt(properties.getProperty("server.port", Integer.toString(this.port)));
        this.paranoid = Boolean.parseBoolean(properties.getProperty("server.paranoid", Boolean.toString(this.paranoid)));
        this.clientIps = properties.getProperty("server.accept", this.clientIps);
        this.authenticationToken = properties.getProperty("auth.token", this.authenticationToken);
    }

    public static KTLuceneServer get() {
        if (luceneServer == null) {
            luceneServer = new KTLuceneServer();
        }
        return luceneServer;
    }

    public boolean authenticate(String string) {
        return this.authenticationToken.equals(string);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isParanoid() {
        return this.paranoid;
    }

    public String[] getAcceptableIps() {
        return this.clientIps.split(",");
    }

    public void shutdown() {
        this.logger.info((Object)"Shutting down...");
        webServer.shutdown();
    }
}

