/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgetree.indexer;

import com.knowledgetree.indexer.IndexerManager;
import com.knowledgetree.indexer.QueryHit;
import com.knowledgetree.lucene.TokenAuthenticationException;

public class IndexerInterface {
    public String getStatistics(String string, String string2) throws Exception {
        IndexerManager indexerManager = IndexerManager.get();
        if (!indexerManager.authenticate(string2)) {
            throw new TokenAuthenticationException(string2);
        }
        return indexerManager.getStatistics();
    }

    public boolean documentExists(String string, String string2, int n) throws Exception {
        IndexerManager indexerManager = IndexerManager.get();
        if (!indexerManager.authenticate(string2)) {
            throw new TokenAuthenticationException(string2);
        }
        try {
            return indexerManager.documentExists(n);
        }
        catch (Exception exception) {
            indexerManager.getLogger().error((Object)exception.getMessage());
            return false;
        }
    }

    public int addDocument(String string, String string2, int n, String string3, String string4, String string5, String string6) throws Exception {
        IndexerManager indexerManager = IndexerManager.get();
        if (!indexerManager.authenticate(string2)) {
            throw new TokenAuthenticationException(string2);
        }
        try {
            indexerManager.getLogger().debug((Object)("addDocument(" + n + "," + string3 + ",...)"));
            indexerManager.indexDocument(n, string3, string4, string5, string6);
        }
        catch (Exception exception) {
            indexerManager.getLogger().error((Object)exception.getMessage());
            return -1;
        }
        return 0;
    }

    public int updateDiscussion(String string, String string2, int n, String string3) throws Exception {
        IndexerManager indexerManager = IndexerManager.get();
        if (!indexerManager.authenticate(string2)) {
            throw new TokenAuthenticationException(string2);
        }
        try {
            indexerManager.getLogger().debug((Object)("updateDiscussion(" + n + ",...)"));
            indexerManager.updateDiscussion(n, string3);
        }
        catch (Exception exception) {
            indexerManager.getLogger().error((Object)exception.getMessage());
            return -1;
        }
        return 0;
    }

    public int deleteDocument(String string, String string2, int n) throws Exception {
        IndexerManager indexerManager = IndexerManager.get();
        if (!indexerManager.authenticate(string2)) {
            throw new TokenAuthenticationException(string2);
        }
        indexerManager.getLogger().debug((Object)("deleteDocument(" + n + ")"));
        try {
            indexerManager.deleteDocument(n);
        }
        catch (Exception exception) {
            indexerManager.getLogger().error((Object)exception.getMessage());
            return -1;
        }
        return 0;
    }

    public int optimise(String string, String string2) throws Exception {
        IndexerManager indexerManager = IndexerManager.get();
        if (!indexerManager.authenticate(string2)) {
            throw new TokenAuthenticationException(string2);
        }
        indexerManager.getLogger().debug((Object)"optimise()");
        try {
            indexerManager.optimise();
            indexerManager.getLogger().debug((Object)"optimise() done");
        }
        catch (Exception exception) {
            indexerManager.getLogger().error((Object)exception.getMessage());
            return -1;
        }
        return 0;
    }

    public String query(String string, String string2, String string3) throws Exception {
        IndexerManager indexerManager = IndexerManager.get();
        if (!indexerManager.authenticate(string2)) {
            throw new TokenAuthenticationException(string2);
        }
        indexerManager.getLogger().debug((Object)("query(" + string3 + ")"));
        try {
            QueryHit[] queryHitArray = indexerManager.query(string3, true);
            return QueryHit.toJSON(queryHitArray);
        }
        catch (Exception exception) {
            indexerManager.getLogger().error((Object)(exception.getClass().getName() + ":" + exception.getMessage()));
            return null;
        }
    }

    public String getText(String string, String string2, int n) throws Exception {
        IndexerManager indexerManager = IndexerManager.get();
        if (!indexerManager.authenticate(string2)) {
            throw new TokenAuthenticationException(string2);
        }
        indexerManager.getLogger().debug((Object)("getText(" + n + ")"));
        String string3 = indexerManager.getText(n);
        return string3;
    }
}

