/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.document.wordprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.openxml4j.document.wordprocessing.ParagraphAlignment;
import org.openxml4j.document.wordprocessing.ParagraphReadOnlyManager;
import org.openxml4j.document.wordprocessing.ParagraphSpacing;
import org.openxml4j.document.wordprocessing.ParagraphSpacingPredefined;
import org.openxml4j.document.wordprocessing.Run;
import org.openxml4j.document.wordprocessing.UnderlineStyle;
import org.openxml4j.document.wordprocessing.VerticalAlignment;
import org.openxml4j.document.wordprocessing.WordDocument;

public final class Paragraph {
    protected ParagraphAlignment alignment;
    protected boolean bold;
    protected boolean italic;
    protected UnderlineStyle underline;
    protected int paragraphRefInNumberingXml = -1;
    protected int paragraphNumberShift = 0;
    protected String paragraphStyleName = "Normal";
    private ParagraphSpacing spacing;
    private ParagraphReadOnlyManager readOnlyPermission = null;
    protected int fontSize;
    protected ArrayList<Run> runs = new ArrayList();

    protected Paragraph() {
        this.spacing = new ParagraphSpacing();
    }

    public void addRun(Run run) {
        this.runs.add(run);
    }

    public void addTextAsRunWithParagraphSetting(String text) {
        Run run = new Run(text);
        run.setBold(this.bold);
        run.setItalic(this.italic);
        run.setUnderline(this.underline);
        run.setFontSize(this.fontSize);
        this.runs.add(run);
    }

    private void addParagraphProperties(Element paragraph) {
        Element properties = paragraph.addElement(new QName("pPr", WordDocument.namespaceWord));
        Element paraAlignement = properties.addElement(new QName("jc", WordDocument.namespaceWord));
        paraAlignement.addAttribute(new QName("val", WordDocument.namespaceWord), this.alignment.toString());
        if (this.paragraphRefInNumberingXml != -1) {
            Element paraNumbering = properties.addElement(new QName("numPr", WordDocument.namespaceWord));
            Element numberingLevelReference = paraNumbering.addElement(new QName("ilvl", WordDocument.namespaceWord));
            numberingLevelReference.addAttribute(new QName("val", WordDocument.namespaceWord), new Integer(this.paragraphNumberShift).toString());
            Element numberingReferenceInNumberingXml = paraNumbering.addElement(new QName("numId", WordDocument.namespaceWord));
            numberingReferenceInNumberingXml.addAttribute(new QName("val", WordDocument.namespaceWord), new Integer(this.paragraphRefInNumberingXml).toString());
        }
        this.addParameterStyleXmlCode(properties);
        if (this.spacing.isSpacingRequired()) {
            this.spacing.addParagraphSpacingProperties(properties);
        }
    }

    private Element addParameterStyleXmlCode(Element paraProperties) {
        return Paragraph.addParameterStyleXmlCode(paraProperties, this.paragraphStyleName);
    }

    private static Element addParameterStyleXmlCode(Element paraProperties, String styleName) {
        Element paraStyle = paraProperties.addElement(new QName("pStyle", WordDocument.namespaceWord));
        paraStyle.addAttribute(new QName("val", WordDocument.namespaceWord), styleName);
        return paraStyle;
    }

    public static void addDefaultStyleXmlCode(Element paraNode) {
        Element propertiesNode = Paragraph.hasProperties(paraNode);
        if (propertiesNode != null) {
            Paragraph.addParameterStyleXmlCode(propertiesNode, "Normal");
        } else {
            propertiesNode = paraNode.addElement(new QName("pPr", WordDocument.namespaceWord));
            Paragraph.addParameterStyleXmlCode(propertiesNode, "Normal");
        }
    }

    public static Element hasProperties(Element nodeToCheck) {
        return Paragraph.hasTag(nodeToCheck, "pPr");
    }

    public static Element hasStyleName(Element nodeToCheck) {
        Element propertiesNode = Paragraph.hasProperties(nodeToCheck);
        if (propertiesNode == null) {
            return null;
        }
        return Paragraph.hasTag(propertiesNode, "pStyle");
    }

    private static Element hasTag(Element nodeToCheck, String valueToSearchFor) {
        List listOfElements = nodeToCheck.elements();
        for (Element element : listOfElements) {
            if (!element.getName().equals(valueToSearchFor)) continue;
            return element;
        }
        return null;
    }

    public Element build() {
        DocumentFactory factory = DocumentFactory.getInstance();
        Element paragraph = factory.createElement(new QName("p", WordDocument.namespaceWord));
        this.addParagraphProperties(paragraph);
        if (this.readOnlyPermission != null) {
            this.readOnlyPermission.addReadOnlyStartTag(paragraph);
        }
        this.addRunsInParagraph(paragraph);
        if (this.readOnlyPermission != null) {
            this.readOnlyPermission.addReadOnlyEndTag(paragraph);
        }
        return paragraph;
    }

    private void addRunsInParagraph(Element paragraph) {
        for (Run r : this.runs) {
            Element run = paragraph.addElement(new QName("r", WordDocument.namespaceWord));
            Element runProps = run.addElement(new QName("rPr", WordDocument.namespaceWord));
            if (r.isBold()) {
                runProps.addElement(new QName("b", WordDocument.namespaceWord));
            }
            if (r.isItalic()) {
                runProps.addElement(new QName("i", WordDocument.namespaceWord));
            }
            if (r.getUnderline() != UnderlineStyle.NONE) {
                Element underlineProp = runProps.addElement(new QName("u", WordDocument.namespaceWord));
                underlineProp.addAttribute(new QName("val", WordDocument.namespaceWord), r.getUnderline().toString());
            }
            if (r.getVerticalAlignement() != VerticalAlignment.NONE) {
                Element vertAlignProp = runProps.addElement(new QName("vertAlign", WordDocument.namespaceWord));
                vertAlignProp.addAttribute(new QName("val", WordDocument.namespaceWord), r.verticalAlignement.toString());
            }
            Element fontSizeProp = runProps.addElement(new QName("sz", WordDocument.namespaceWord));
            fontSizeProp.addAttribute(new QName("val", WordDocument.namespaceWord), "" + r.fontSize);
            Element text = run.addElement(new QName("t", WordDocument.namespaceWord));
            if (r.getText().indexOf(" ") != -1) {
                text.addAttribute("xml:space", "preserve");
            }
            text.addText(r.getText());
        }
    }

    public ParagraphAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(ParagraphAlignment alignment) {
        this.alignment = alignment;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public UnderlineStyle getUnderline() {
        return this.underline;
    }

    public void setUnderline(UnderlineStyle underline) {
        this.underline = underline;
    }

    public int getParagraphNumberShift() {
        return this.paragraphNumberShift;
    }

    public void setParagraphNumberShift(int paragraphNumberShift) {
        this.paragraphNumberShift = paragraphNumberShift;
    }

    public int getParagraphRefInNumberingXml() {
        return this.paragraphRefInNumberingXml;
    }

    public void setParagraphRefInNumberingXml(int paragraphRefInNumberingXml) {
        this.paragraphRefInNumberingXml = paragraphRefInNumberingXml;
    }

    public ParagraphSpacing getSpacing() {
        return this.spacing;
    }

    public void setSpacing(ParagraphSpacing spacing) {
        this.spacing = spacing;
    }

    public void setSpacing(ParagraphSpacingPredefined spacing) {
        this.spacing = new ParagraphSpacing(spacing);
    }

    public ParagraphReadOnlyManager getReadOnlyPermission() {
        return this.readOnlyPermission;
    }

    public void setReadOnlyPermission(ParagraphReadOnlyManager readOnlyPermission) {
        this.readOnlyPermission = readOnlyPermission;
    }

    public String getParagraphStyleName() {
        return this.paragraphStyleName;
    }

    public void setParagraphStyleName(String paragraphStyleName) {
        this.paragraphStyleName = paragraphStyleName;
    }
}

