/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.ArrayList;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.hssf.record.constant.ErrorConstant;
import org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.ArrayPtg;
import org.apache.poi.hssf.record.formula.AttrPtg;
import org.apache.poi.hssf.record.formula.BoolPtg;
import org.apache.poi.hssf.record.formula.ConcatPtg;
import org.apache.poi.hssf.record.formula.DividePtg;
import org.apache.poi.hssf.record.formula.EqualPtg;
import org.apache.poi.hssf.record.formula.ErrPtg;
import org.apache.poi.hssf.record.formula.FuncPtg;
import org.apache.poi.hssf.record.formula.FuncVarPtg;
import org.apache.poi.hssf.record.formula.GreaterEqualPtg;
import org.apache.poi.hssf.record.formula.GreaterThanPtg;
import org.apache.poi.hssf.record.formula.IntPtg;
import org.apache.poi.hssf.record.formula.LessEqualPtg;
import org.apache.poi.hssf.record.formula.LessThanPtg;
import org.apache.poi.hssf.record.formula.MemFuncPtg;
import org.apache.poi.hssf.record.formula.MissingArgPtg;
import org.apache.poi.hssf.record.formula.MultiplyPtg;
import org.apache.poi.hssf.record.formula.NotEqualPtg;
import org.apache.poi.hssf.record.formula.NumberPtg;
import org.apache.poi.hssf.record.formula.OperandPtg;
import org.apache.poi.hssf.record.formula.ParenthesisPtg;
import org.apache.poi.hssf.record.formula.PercentPtg;
import org.apache.poi.hssf.record.formula.PowerPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.RangePtg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.RefPtg;
import org.apache.poi.hssf.record.formula.StringPtg;
import org.apache.poi.hssf.record.formula.SubtractPtg;
import org.apache.poi.hssf.record.formula.UnaryMinusPtg;
import org.apache.poi.hssf.record.formula.UnaryPlusPtg;
import org.apache.poi.hssf.record.formula.UnionPtg;
import org.apache.poi.hssf.record.formula.ValueOperatorPtg;
import org.apache.poi.hssf.record.formula.function.FunctionMetadata;
import org.apache.poi.hssf.record.formula.function.FunctionMetadataRegistry;
import org.apache.poi.hssf.util.AreaReference;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.ss.formula.EvaluationName;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.OperandClassTransformer;
import org.apache.poi.ss.formula.ParseNode;

public final class FormulaParser {
    private final String _formulaString;
    private final int _formulaLength;
    private int _pointer;
    private ParseNode _rootNode;
    private static char TAB = (char)9;
    private char look;
    private FormulaParsingWorkbook _book;
    private int _sheetIndex;

    private FormulaParser(String formula, FormulaParsingWorkbook book, int sheetIndex) {
        this._formulaString = formula;
        this._pointer = 0;
        this._book = book;
        this._formulaLength = this._formulaString.length();
        this._sheetIndex = sheetIndex;
    }

    public static Ptg[] parse(String formula, FormulaParsingWorkbook book) {
        return FormulaParser.parse(formula, book, 0);
    }

    public static Ptg[] parse(String formula, FormulaParsingWorkbook workbook, int formulaType) {
        return FormulaParser.parse(formula, workbook, formulaType, -1);
    }

    public static Ptg[] parse(String formula, FormulaParsingWorkbook workbook, int formulaType, int sheetIndex) {
        FormulaParser fp = new FormulaParser(formula, workbook, sheetIndex);
        fp.parse();
        return fp.getRPNPtg(formulaType);
    }

    private void GetChar() {
        if (this._pointer > this._formulaLength) {
            throw new RuntimeException("too far");
        }
        this.look = this._pointer < this._formulaLength ? this._formulaString.charAt(this._pointer) : (char)'\u0000';
        ++this._pointer;
    }

    private RuntimeException expected(String s) {
        String msg = this.look == '=' && this._formulaString.substring(0, this._pointer - 1).trim().length() < 1 ? "The specified formula '" + this._formulaString + "' starts with an equals sign which is not allowed." : "Parse error near char " + (this._pointer - 1) + " '" + this.look + "'" + " in specified formula '" + this._formulaString + "'. Expected " + s;
        return new FormulaParseException(msg);
    }

    private static boolean IsAlpha(char c) {
        return Character.isLetter(c) || c == '$' || c == '_';
    }

    private static boolean IsDigit(char c) {
        return Character.isDigit(c);
    }

    private static boolean IsAlNum(char c) {
        return FormulaParser.IsAlpha(c) || FormulaParser.IsDigit(c);
    }

    private static boolean IsWhite(char c) {
        return c == ' ' || c == TAB;
    }

    private void SkipWhite() {
        while (FormulaParser.IsWhite(this.look)) {
            this.GetChar();
        }
    }

    private void Match(char x) {
        if (this.look != x) {
            throw this.expected("'" + x + "'");
        }
        this.GetChar();
    }

    private String parseUnquotedIdentifier() {
        Identifier iden = this.parseIdentifier();
        if (iden.isQuoted()) {
            throw this.expected("unquoted identifier");
        }
        return iden.getName();
    }

    private Identifier parseIdentifier() {
        boolean isQuoted;
        StringBuffer sb = new StringBuffer();
        if (!FormulaParser.IsAlpha(this.look) && this.look != '\'' && this.look != '[') {
            throw this.expected("Name");
        }
        boolean bl = isQuoted = this.look == '\'';
        if (isQuoted) {
            boolean done;
            this.Match('\'');
            boolean bl2 = done = this.look == '\'';
            while (!done) {
                sb.append(this.look);
                this.GetChar();
                if (this.look != '\'') continue;
                this.Match('\'');
                done = this.look != '\'';
            }
        } else {
            while (FormulaParser.IsAlNum(this.look) || this.look == '.' || this.look == '[' || this.look == ']') {
                sb.append(this.look);
                this.GetChar();
            }
        }
        return new Identifier(sb.toString(), isQuoted);
    }

    private String GetNum() {
        StringBuffer value = new StringBuffer();
        while (FormulaParser.IsDigit(this.look)) {
            value.append(this.look);
            this.GetChar();
        }
        return value.length() == 0 ? null : value.toString();
    }

    private ParseNode parseFunctionReferenceOrName() {
        String name;
        Identifier iden = this.parseIdentifier();
        if (this.look == '(') {
            return this.function(iden.getName());
        }
        if (!iden.isQuoted() && ((name = iden.getName()).equalsIgnoreCase("TRUE") || name.equalsIgnoreCase("FALSE"))) {
            return new ParseNode(new BoolPtg(name.toUpperCase()));
        }
        return this.parseRangeExpression(iden);
    }

    private ParseNode parseRangeExpression(Identifier iden) {
        Ptg ptgA = this.parseNameOrCellRef(iden);
        if (this.look == ':') {
            this.GetChar();
            Identifier iden2 = this.parseIdentifier();
            Ptg ptgB = this.parseNameOrCellRef(iden2);
            Ptg simplified = FormulaParser.reduceRangeExpression(ptgA, ptgB);
            if (simplified == null) {
                ParseNode[] children = new ParseNode[]{new ParseNode(ptgA), new ParseNode(ptgB)};
                ParseNode result = new ParseNode((Ptg)RangePtg.instance, children);
                MemFuncPtg memFuncPtg = new MemFuncPtg(result.getEncodedSize());
                return new ParseNode((Ptg)memFuncPtg, result);
            }
            return new ParseNode(simplified);
        }
        return new ParseNode(ptgA);
    }

    private static Ptg reduceRangeExpression(Ptg ptgA, Ptg ptgB) {
        if (!(ptgB instanceof RefPtg)) {
            return null;
        }
        RefPtg refB = (RefPtg)ptgB;
        if (ptgA instanceof RefPtg) {
            RefPtg refA = (RefPtg)ptgA;
            return new AreaPtg(refA.getRow(), refB.getRow(), refA.getColumn(), refB.getColumn(), refA.isRowRelative(), refB.isRowRelative(), refA.isColRelative(), refB.isColRelative());
        }
        if (ptgA instanceof Ref3DPtg) {
            Ref3DPtg refA = (Ref3DPtg)ptgA;
            return new Area3DPtg(refA.getRow(), refB.getRow(), refA.getColumn(), refB.getColumn(), refA.isRowRelative(), refB.isRowRelative(), refA.isColRelative(), refB.isColRelative(), refA.getExternSheetIndex());
        }
        return null;
    }

    private Ptg parseNameOrCellRef(Identifier iden) {
        EvaluationName evalName;
        if (this.look == '!') {
            this.GetChar();
            int externIdx = this.getExternalSheetIndex(iden.getName());
            String secondIden = this.parseUnquotedIdentifier();
            if (FormulaParser.isRowOrCol(secondIden) && this.look == ':') {
                this.GetChar();
                String thirdIden = this.parseUnquotedIdentifier();
                return new Area3DPtg(secondIden + ":" + thirdIden, externIdx);
            }
            AreaReference areaRef = this.parseArea(secondIden);
            if (areaRef == null) {
                return new Ref3DPtg(secondIden, externIdx);
            }
            return new Area3DPtg(areaRef.formatAsString(), externIdx);
        }
        String name = iden.getName();
        AreaReference areaRef = this.parseArea(name);
        if (areaRef != null) {
            return new AreaPtg(areaRef.formatAsString());
        }
        int nameType = CellReference.classifyCellReference(name);
        if (nameType == 1) {
            return new RefPtg(name);
        }
        if (this.look == ':' && nameType == 3) {
            this.GetChar();
            String secondIden = this.parseUnquotedIdentifier();
            if (CellReference.classifyCellReference(secondIden) != 3) {
                throw new FormulaParseException("Expected full column after '" + name + ":' but got '" + secondIden + "'");
            }
            return new AreaPtg(name + ":" + secondIden);
        }
        if (nameType != 2) {
            new FormulaParseException("Name '" + name + "' does not look like a cell reference or named range");
        }
        if ((evalName = this._book.getName(name, this._sheetIndex)) == null) {
            throw new FormulaParseException("Specified named range '" + name + "' does not exist in the current workbook.");
        }
        if (evalName.isRange()) {
            return evalName.createPtg();
        }
        throw new FormulaParseException("Specified name '" + name + "' is not a range as expected");
    }

    private static boolean isRowOrCol(String str) {
        int i = 0;
        if (str.charAt(i) == '$') {
            ++i;
        }
        if (FormulaParser.IsDigit(str.charAt(i))) {
            while (i < str.length()) {
                if (!FormulaParser.IsDigit(str.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (FormulaParser.IsAlpha(str.charAt(i))) {
            while (i < str.length()) {
                if (!FormulaParser.IsAlpha(str.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private int getExternalSheetIndex(String name) {
        if (name.charAt(0) == '[') {
            int pos = name.lastIndexOf(93);
            String wbName = name.substring(1, pos);
            String sheetName = name.substring(pos + 1);
            return this._book.getExternalSheetIndex(wbName, sheetName);
        }
        return this._book.getExternalSheetIndex(name);
    }

    private AreaReference parseArea(String name) {
        int dotPos = name.indexOf(46);
        if (dotPos < 0) {
            return null;
        }
        int dotCount = 1;
        while (dotCount < name.length() && name.charAt(dotPos + dotCount) == '.') {
            if (++dotCount <= 3) continue;
            return null;
        }
        String partA = name.substring(0, dotPos);
        if (!FormulaParser.isValidCellReference(partA)) {
            return null;
        }
        String partB = name.substring(dotPos + dotCount);
        if (!FormulaParser.isValidCellReference(partB)) {
            return null;
        }
        CellReference topLeft = new CellReference(partA);
        CellReference bottomRight = new CellReference(partB);
        return new AreaReference(topLeft, bottomRight);
    }

    private static boolean isValidCellReference(String str) {
        return CellReference.classifyCellReference(str) == 1;
    }

    private ParseNode function(String name) {
        OperandPtg nameToken = null;
        if (!AbstractFunctionPtg.isBuiltInFunctionName(name)) {
            EvaluationName hName = this._book.getName(name, this._sheetIndex);
            if (hName == null) {
                nameToken = this._book.getNameXPtg(name);
                if (nameToken == null) {
                    throw new FormulaParseException("Name '" + name + "' is completely unknown in the current workbook");
                }
            } else {
                if (!hName.isFunctionName()) {
                    throw new FormulaParseException("Attempt to use name '" + name + "' as a function, but defined name in workbook does not refer to a function");
                }
                nameToken = hName.createPtg();
            }
        }
        this.Match('(');
        ParseNode[] args = this.Arguments();
        this.Match(')');
        return this.getFunction(name, nameToken, args);
    }

    private ParseNode getFunction(String name, Ptg namePtg, ParseNode[] args) {
        FunctionMetadata fm = FunctionMetadataRegistry.getFunctionByName(name.toUpperCase());
        int numArgs = args.length;
        if (fm == null) {
            if (namePtg == null) {
                throw new IllegalStateException("NamePtg must be supplied for external functions");
            }
            ParseNode[] allArgs = new ParseNode[numArgs + 1];
            allArgs[0] = new ParseNode(namePtg);
            System.arraycopy(args, 0, allArgs, 1, numArgs);
            return new ParseNode((Ptg)new FuncVarPtg(name, (byte)(numArgs + 1)), allArgs);
        }
        if (namePtg != null) {
            throw new IllegalStateException("NamePtg no applicable to internal functions");
        }
        boolean isVarArgs = !fm.hasFixedArgsLength();
        int funcIx = fm.getIndex();
        if (funcIx == 4 && args.length == 1) {
            return new ParseNode((Ptg)AttrPtg.getSumSingle(), args);
        }
        this.validateNumArgs(args.length, fm);
        AbstractFunctionPtg retval = isVarArgs ? new FuncVarPtg(name, (byte)numArgs) : new FuncPtg(funcIx);
        return new ParseNode((Ptg)retval, args);
    }

    private void validateNumArgs(int numArgs, FunctionMetadata fm) {
        if (numArgs < fm.getMinParams()) {
            String msg = "Too few arguments to function '" + fm.getName() + "'. ";
            msg = fm.hasFixedArgsLength() ? msg + "Expected " + fm.getMinParams() : msg + "At least " + fm.getMinParams() + " were expected";
            msg = msg + " but got " + numArgs + ".";
            throw new FormulaParseException(msg);
        }
        if (numArgs > fm.getMaxParams()) {
            String msg = "Too many arguments to function '" + fm.getName() + "'. ";
            msg = fm.hasFixedArgsLength() ? msg + "Expected " + fm.getMaxParams() : msg + "At most " + fm.getMaxParams() + " were expected";
            msg = msg + " but got " + numArgs + ".";
            throw new FormulaParseException(msg);
        }
    }

    private static boolean isArgumentDelimiter(char ch) {
        return ch == ',' || ch == ')';
    }

    private ParseNode[] Arguments() {
        ArrayList<ParseNode> temp;
        block5: {
            temp = new ArrayList<ParseNode>(2);
            this.SkipWhite();
            if (this.look == ')') {
                return ParseNode.EMPTY_ARRAY;
            }
            boolean missedPrevArg = true;
            int numArgs = 0;
            while (true) {
                this.SkipWhite();
                if (FormulaParser.isArgumentDelimiter(this.look)) {
                    if (missedPrevArg) {
                        temp.add(new ParseNode(MissingArgPtg.instance));
                        ++numArgs;
                    }
                    if (this.look != ')') {
                        this.Match(',');
                        missedPrevArg = true;
                        continue;
                    }
                    break block5;
                }
                temp.add(this.comparisonExpression());
                ++numArgs;
                missedPrevArg = false;
                this.SkipWhite();
                if (!FormulaParser.isArgumentDelimiter(this.look)) break;
            }
            throw this.expected("',' or ')'");
        }
        ParseNode[] result = new ParseNode[temp.size()];
        temp.toArray(result);
        return result;
    }

    private ParseNode powerFactor() {
        ParseNode result = this.percentFactor();
        while (true) {
            this.SkipWhite();
            if (this.look != '^') {
                return result;
            }
            this.Match('^');
            ParseNode other = this.percentFactor();
            result = new ParseNode(PowerPtg.instance, result, other);
        }
    }

    private ParseNode percentFactor() {
        ParseNode result = this.parseSimpleFactor();
        while (true) {
            this.SkipWhite();
            if (this.look != '%') {
                return result;
            }
            this.Match('%');
            result = new ParseNode((Ptg)PercentPtg.instance, result);
        }
    }

    private ParseNode parseSimpleFactor() {
        this.SkipWhite();
        switch (this.look) {
            case '#': {
                return new ParseNode(ErrPtg.valueOf(this.parseErrorLiteral()));
            }
            case '-': {
                this.Match('-');
                return new ParseNode((Ptg)UnaryMinusPtg.instance, this.powerFactor());
            }
            case '+': {
                this.Match('+');
                return new ParseNode((Ptg)UnaryPlusPtg.instance, this.powerFactor());
            }
            case '(': {
                this.Match('(');
                ParseNode inside = this.comparisonExpression();
                this.Match(')');
                return new ParseNode((Ptg)ParenthesisPtg.instance, inside);
            }
            case '\"': {
                return new ParseNode(new StringPtg(this.parseStringLiteral()));
            }
            case '{': {
                this.Match('{');
                ParseNode arrayNode = this.parseArray();
                this.Match('}');
                return arrayNode;
            }
        }
        if (FormulaParser.IsAlpha(this.look) || this.look == '\'' || this.look == '[') {
            return this.parseFunctionReferenceOrName();
        }
        return new ParseNode(this.parseNumber());
    }

    private ParseNode parseArray() {
        ArrayList<Object[]> rowsData = new ArrayList<Object[]>();
        while (true) {
            Object[] singleRowData = this.parseArrayRow();
            rowsData.add(singleRowData);
            if (this.look == '}') break;
            if (this.look != ';') {
                throw this.expected("'}' or ';'");
            }
            this.Match(';');
        }
        int nRows = rowsData.size();
        Object[][] values2d = new Object[nRows][];
        rowsData.toArray((T[])values2d);
        int nColumns = values2d[0].length;
        this.checkRowLengths(values2d, nColumns);
        return new ParseNode(new ArrayPtg(values2d));
    }

    private void checkRowLengths(Object[][] values2d, int nColumns) {
        for (int i = 0; i < values2d.length; ++i) {
            int rowLen = values2d[i].length;
            if (rowLen == nColumns) continue;
            throw new FormulaParseException("Array row " + i + " has length " + rowLen + " but row 0 has length " + nColumns);
        }
    }

    private Object[] parseArrayRow() {
        ArrayList<Object> temp = new ArrayList<Object>();
        block4: while (true) {
            temp.add(this.parseArrayItem());
            this.SkipWhite();
            switch (this.look) {
                case ';': 
                case '}': {
                    break block4;
                }
                case ',': {
                    this.Match(',');
                    continue block4;
                }
                default: {
                    throw this.expected("'}' or ','");
                }
            }
            break;
        }
        Object[] result = new Object[temp.size()];
        temp.toArray(result);
        return result;
    }

    private Object parseArrayItem() {
        this.SkipWhite();
        switch (this.look) {
            case '\"': {
                return new UnicodeString(this.parseStringLiteral());
            }
            case '#': {
                return ErrorConstant.valueOf(this.parseErrorLiteral());
            }
            case 'F': 
            case 'T': 
            case 'f': 
            case 't': {
                return this.parseBooleanLiteral();
            }
        }
        return FormulaParser.convertArrayNumber(this.parseNumber());
    }

    private Boolean parseBooleanLiteral() {
        String iden = this.parseUnquotedIdentifier();
        if ("TRUE".equalsIgnoreCase(iden)) {
            return Boolean.TRUE;
        }
        if ("FALSE".equalsIgnoreCase(iden)) {
            return Boolean.FALSE;
        }
        throw this.expected("'TRUE' or 'FALSE'");
    }

    private static Double convertArrayNumber(Ptg ptg) {
        if (ptg instanceof IntPtg) {
            return new Double(((IntPtg)ptg).getValue());
        }
        if (ptg instanceof NumberPtg) {
            return new Double(((NumberPtg)ptg).getValue());
        }
        throw new RuntimeException("Unexpected ptg (" + ptg.getClass().getName() + ")");
    }

    private Ptg parseNumber() {
        String number2 = null;
        String exponent = null;
        String number1 = this.GetNum();
        if (this.look == '.') {
            this.GetChar();
            number2 = this.GetNum();
        }
        if (this.look == 'E') {
            this.GetChar();
            String sign = "";
            if (this.look == '+') {
                this.GetChar();
            } else if (this.look == '-') {
                this.GetChar();
                sign = "-";
            }
            String number = this.GetNum();
            if (number == null) {
                throw this.expected("Integer");
            }
            exponent = sign + number;
        }
        if (number1 == null && number2 == null) {
            throw this.expected("Integer");
        }
        return FormulaParser.getNumberPtgFromString(number1, number2, exponent);
    }

    private int parseErrorLiteral() {
        this.Match('#');
        String part1 = this.parseUnquotedIdentifier().toUpperCase();
        switch (part1.charAt(0)) {
            case 'V': {
                if (part1.equals("VALUE")) {
                    this.Match('!');
                    return 15;
                }
                throw this.expected("#VALUE!");
            }
            case 'R': {
                if (part1.equals("REF")) {
                    this.Match('!');
                    return 23;
                }
                throw this.expected("#REF!");
            }
            case 'D': {
                if (part1.equals("DIV")) {
                    this.Match('/');
                    this.Match('0');
                    this.Match('!');
                    return 7;
                }
                throw this.expected("#DIV/0!");
            }
            case 'N': {
                if (part1.equals("NAME")) {
                    this.Match('?');
                    return 29;
                }
                if (part1.equals("NUM")) {
                    this.Match('!');
                    return 36;
                }
                if (part1.equals("NULL")) {
                    this.Match('!');
                    return 0;
                }
                if (part1.equals("N")) {
                    this.Match('/');
                    if (this.look != 'A' && this.look != 'a') {
                        throw this.expected("#N/A");
                    }
                    this.Match(this.look);
                    return 42;
                }
                throw this.expected("#NAME?, #NUM!, #NULL! or #N/A");
            }
        }
        throw this.expected("#VALUE!, #REF!, #DIV/0!, #NAME?, #NUM!, #NULL! or #N/A");
    }

    private static Ptg getNumberPtgFromString(String number1, String number2, String exponent) {
        StringBuffer number = new StringBuffer();
        if (number2 == null) {
            int intVal;
            number.append(number1);
            if (exponent != null) {
                number.append('E');
                number.append(exponent);
            }
            String numberStr = number.toString();
            try {
                intVal = Integer.parseInt(numberStr);
            }
            catch (NumberFormatException e) {
                return new NumberPtg(numberStr);
            }
            if (IntPtg.isInRange(intVal)) {
                return new IntPtg(intVal);
            }
            return new NumberPtg(numberStr);
        }
        if (number1 != null) {
            number.append(number1);
        }
        number.append('.');
        number.append(number2);
        if (exponent != null) {
            number.append('E');
            number.append(exponent);
        }
        return new NumberPtg(number.toString());
    }

    private String parseStringLiteral() {
        this.Match('\"');
        StringBuffer token = new StringBuffer();
        while (true) {
            if (this.look == '\"') {
                this.GetChar();
                if (this.look != '\"') break;
            }
            token.append(this.look);
            this.GetChar();
        }
        return token.toString();
    }

    private ParseNode Term() {
        ParseNode result = this.powerFactor();
        while (true) {
            ValueOperatorPtg operator;
            this.SkipWhite();
            switch (this.look) {
                case '*': {
                    this.Match('*');
                    operator = MultiplyPtg.instance;
                    break;
                }
                case '/': {
                    this.Match('/');
                    operator = DividePtg.instance;
                    break;
                }
                default: {
                    return result;
                }
            }
            ParseNode other = this.powerFactor();
            result = new ParseNode(operator, result, other);
        }
    }

    private ParseNode unionExpression() {
        ParseNode result = this.comparisonExpression();
        boolean hasUnions = false;
        block3: while (true) {
            this.SkipWhite();
            switch (this.look) {
                case ',': {
                    this.GetChar();
                    hasUnions = true;
                    ParseNode other = this.comparisonExpression();
                    result = new ParseNode(UnionPtg.instance, result, other);
                    continue block3;
                }
            }
            break;
        }
        if (hasUnions) {
            MemFuncPtg memFuncPtg = new MemFuncPtg(result.getEncodedSize());
            result = new ParseNode((Ptg)memFuncPtg, result);
        }
        return result;
    }

    private ParseNode comparisonExpression() {
        ParseNode result = this.concatExpression();
        block3: while (true) {
            this.SkipWhite();
            switch (this.look) {
                case '<': 
                case '=': 
                case '>': {
                    Ptg comparisonToken = this.getComparisonToken();
                    ParseNode other = this.concatExpression();
                    result = new ParseNode(comparisonToken, result, other);
                    continue block3;
                }
            }
            break;
        }
        return result;
    }

    private Ptg getComparisonToken() {
        if (this.look == '=') {
            this.Match(this.look);
            return EqualPtg.instance;
        }
        boolean isGreater = this.look == '>';
        this.Match(this.look);
        if (isGreater) {
            if (this.look == '=') {
                this.Match('=');
                return GreaterEqualPtg.instance;
            }
            return GreaterThanPtg.instance;
        }
        switch (this.look) {
            case '=': {
                this.Match('=');
                return LessEqualPtg.instance;
            }
            case '>': {
                this.Match('>');
                return NotEqualPtg.instance;
            }
        }
        return LessThanPtg.instance;
    }

    private ParseNode concatExpression() {
        ParseNode result = this.additiveExpression();
        while (true) {
            this.SkipWhite();
            if (this.look != '&') break;
            this.Match('&');
            ParseNode other = this.additiveExpression();
            result = new ParseNode(ConcatPtg.instance, result, other);
        }
        return result;
    }

    private ParseNode additiveExpression() {
        ParseNode result = this.Term();
        while (true) {
            ValueOperatorPtg operator;
            this.SkipWhite();
            switch (this.look) {
                case '+': {
                    this.Match('+');
                    operator = AddPtg.instance;
                    break;
                }
                case '-': {
                    this.Match('-');
                    operator = SubtractPtg.instance;
                    break;
                }
                default: {
                    return result;
                }
            }
            ParseNode other = this.Term();
            result = new ParseNode(operator, result, other);
        }
    }

    private void parse() {
        this._pointer = 0;
        this.GetChar();
        this._rootNode = this.unionExpression();
        if (this._pointer <= this._formulaLength) {
            String msg = "Unused input [" + this._formulaString.substring(this._pointer - 1) + "] after attempting to parse the formula [" + this._formulaString + "]";
            throw new FormulaParseException(msg);
        }
    }

    private Ptg[] getRPNPtg(int formulaType) {
        OperandClassTransformer oct = new OperandClassTransformer(formulaType);
        oct.transformFormula(this._rootNode);
        return ParseNode.toTokenArray(this._rootNode);
    }

    static final class FormulaParseException
    extends RuntimeException {
        public FormulaParseException(String msg) {
            super(msg);
        }
    }

    private static final class Identifier {
        private final String _name;
        private final boolean _isQuoted;

        public Identifier(String name, boolean isQuoted) {
            this._name = name;
            this._isQuoted = isQuoted;
        }

        public String getName() {
            return this._name;
        }

        public boolean isQuoted() {
            return this._isQuoted;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.getClass().getName());
            sb.append(" [");
            if (this._isQuoted) {
                sb.append("'").append(this._name).append("'");
            } else {
                sb.append(this._name);
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

