/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.PrintWriter;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hssf.model.Sheet;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.DVRecord;
import org.apache.poi.hssf.record.EscherAggregate;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SCLRecord;
import org.apache.poi.hssf.record.WSBoolRecord;
import org.apache.poi.hssf.record.aggregates.DataValidityTable;
import org.apache.poi.hssf.record.formula.FormulaShifter;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheetConditionalFormatting;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.PaneInformation;
import org.apache.poi.hssf.util.Region;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSSFSheet
implements org.apache.poi.ss.usermodel.Sheet {
    private static final POILogger log = POILogFactory.getLogger(HSSFSheet.class);
    private static final int DEBUG = 1;
    public static final short LeftMargin = 0;
    public static final short RightMargin = 1;
    public static final short TopMargin = 2;
    public static final short BottomMargin = 3;
    public static final byte PANE_LOWER_RIGHT = 0;
    public static final byte PANE_UPPER_RIGHT = 1;
    public static final byte PANE_LOWER_LEFT = 2;
    public static final byte PANE_UPPER_LEFT = 3;
    public static final int INITIAL_CAPACITY = 20;
    private final Sheet sheet;
    private final TreeMap<Integer, HSSFRow> rows;
    protected final Workbook book;
    protected final HSSFWorkbook workbook;
    private int firstrow;
    private int lastrow;

    protected HSSFSheet(HSSFWorkbook workbook) {
        this.sheet = Sheet.createSheet();
        this.rows = new TreeMap();
        this.workbook = workbook;
        this.book = workbook.getWorkbook();
    }

    protected HSSFSheet(HSSFWorkbook workbook, Sheet sheet) {
        this.sheet = sheet;
        this.rows = new TreeMap();
        this.workbook = workbook;
        this.book = workbook.getWorkbook();
        this.setPropertiesFromSheet(sheet);
    }

    HSSFSheet cloneSheet(HSSFWorkbook workbook) {
        return new HSSFSheet(workbook, this.sheet.cloneSheet());
    }

    @Override
    public HSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    private void setPropertiesFromSheet(Sheet sheet) {
        boolean rowRecordsAlreadyPresent;
        RowRecord row = sheet.getNextRow();
        boolean bl = rowRecordsAlreadyPresent = row != null;
        while (row != null) {
            this.createRowFromRecord(row);
            row = sheet.getNextRow();
        }
        CellValueRecordInterface[] cvals = sheet.getValueRecords();
        long timestart = System.currentTimeMillis();
        if (log.check(1)) {
            log.log(1, (Object)"Time at start of cell creating in HSSF sheet = ", new Long(timestart));
        }
        HSSFRow lastrow = null;
        for (int i = 0; i < cvals.length; ++i) {
            CellValueRecordInterface cval = cvals[i];
            long cellstart = System.currentTimeMillis();
            HSSFRow hrow = lastrow;
            if (hrow == null || hrow.getRowNum() != cval.getRow()) {
                lastrow = hrow = this.getRow(cval.getRow());
                if (hrow == null) {
                    if (rowRecordsAlreadyPresent) {
                        throw new RuntimeException("Unexpected missing row when some rows already present");
                    }
                    RowRecord rowRec = new RowRecord(cval.getRow());
                    sheet.addRow(rowRec);
                    hrow = this.createRowFromRecord(rowRec);
                }
            }
            if (log.check(1)) {
                log.log(1, "record id = " + Integer.toHexString(((Record)((Object)cval)).getSid()));
            }
            hrow.createCellFromRecord(cval);
            if (!log.check(1)) continue;
            log.log(1, (Object)"record took ", new Long(System.currentTimeMillis() - cellstart));
        }
        if (log.check(1)) {
            log.log(1, (Object)"total sheet cell creation took ", new Long(System.currentTimeMillis() - timestart));
        }
    }

    @Override
    public HSSFRow createRow(int rownum) {
        HSSFRow row = new HSSFRow(this.workbook, this, rownum);
        this.addRow(row, true);
        return row;
    }

    private HSSFRow createRowFromRecord(RowRecord row) {
        HSSFRow hrow = new HSSFRow(this.workbook, this, row);
        this.addRow(hrow, false);
        return hrow;
    }

    @Override
    public void removeRow(Row row) {
        HSSFRow hrow = (HSSFRow)row;
        if (this.rows.size() > 0) {
            Integer key = new Integer(row.getRowNum());
            HSSFRow removedRow = this.rows.remove(key);
            if (removedRow != row) {
                if (removedRow != null) {
                    this.rows.put(key, removedRow);
                }
                throw new RuntimeException("Specified row does not belong to this sheet");
            }
            if (hrow.getRowNum() == this.getLastRowNum()) {
                this.lastrow = this.findLastRow(this.lastrow);
            }
            if (hrow.getRowNum() == this.getFirstRowNum()) {
                this.firstrow = this.findFirstRow(this.firstrow);
            }
            this.sheet.removeRow(hrow.getRowRecord());
        }
    }

    private int findLastRow(int lastrow) {
        if (lastrow < 1) {
            return -1;
        }
        int rownum = lastrow - 1;
        HSSFRow r = this.getRow(rownum);
        while (r == null && rownum > 0) {
            r = this.getRow(--rownum);
        }
        if (r == null) {
            return -1;
        }
        return rownum;
    }

    private int findFirstRow(int firstrow) {
        int rownum = firstrow + 1;
        HSSFRow r = this.getRow(rownum);
        while (r == null && rownum <= this.getLastRowNum()) {
            r = this.getRow(++rownum);
        }
        if (rownum > this.getLastRowNum()) {
            return -1;
        }
        return rownum;
    }

    private void addRow(HSSFRow row, boolean addLow) {
        this.rows.put(new Integer(row.getRowNum()), row);
        if (addLow) {
            this.sheet.addRow(row.getRowRecord());
        }
        if (row.getRowNum() > this.getLastRowNum()) {
            this.lastrow = row.getRowNum();
        }
        if (row.getRowNum() < this.getFirstRowNum()) {
            this.firstrow = row.getRowNum();
        }
    }

    @Override
    public HSSFRow getRow(int rowIndex) {
        return this.rows.get(new Integer(rowIndex));
    }

    @Override
    public int getPhysicalNumberOfRows() {
        return this.rows.size();
    }

    @Override
    public int getFirstRowNum() {
        return this.firstrow;
    }

    @Override
    public int getLastRowNum() {
        return this.lastrow;
    }

    public void addValidationData(HSSFDataValidation dataValidation) {
        if (dataValidation == null) {
            throw new IllegalArgumentException("objValidation must not be null");
        }
        DataValidityTable dvt = this.sheet.getOrCreateDataValidityTable();
        DVRecord dvRecord = dataValidation.createDVRecord(this);
        dvt.addDataValidation(dvRecord);
    }

    public void setColumnHidden(short columnIndex, boolean hidden) {
        this.setColumnHidden(columnIndex & 0xFFFF, hidden);
    }

    public boolean isColumnHidden(short columnIndex) {
        return this.isColumnHidden(columnIndex & 0xFFFF);
    }

    public void setColumnWidth(short columnIndex, short width) {
        this.setColumnWidth(columnIndex & 0xFFFF, width & 0xFFFF);
    }

    public short getColumnWidth(short columnIndex) {
        return (short)this.getColumnWidth(columnIndex & 0xFFFF);
    }

    public void setDefaultColumnWidth(short width) {
        this.setDefaultColumnWidth(width & 0xFFFF);
    }

    @Override
    public void setColumnHidden(int columnIndex, boolean hidden) {
        this.sheet.setColumnHidden(columnIndex, hidden);
    }

    @Override
    public boolean isColumnHidden(int columnIndex) {
        return this.sheet.isColumnHidden(columnIndex);
    }

    @Override
    public void setColumnWidth(int columnIndex, int width) {
        this.sheet.setColumnWidth(columnIndex, width);
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        return this.sheet.getColumnWidth(columnIndex);
    }

    @Override
    public int getDefaultColumnWidth() {
        return this.sheet.getDefaultColumnWidth();
    }

    @Override
    public void setDefaultColumnWidth(int width) {
        this.sheet.setDefaultColumnWidth(width);
    }

    @Override
    public short getDefaultRowHeight() {
        return this.sheet.getDefaultRowHeight();
    }

    @Override
    public float getDefaultRowHeightInPoints() {
        return this.sheet.getDefaultRowHeight() / 20;
    }

    @Override
    public void setDefaultRowHeight(short height) {
        this.sheet.setDefaultRowHeight(height);
    }

    @Override
    public void setDefaultRowHeightInPoints(float height) {
        this.sheet.setDefaultRowHeight((short)(height * 20.0f));
    }

    @Override
    public HSSFCellStyle getColumnStyle(int column) {
        short styleIndex = this.sheet.getXFIndexForColAt((short)column);
        if (styleIndex == 15) {
            return null;
        }
        ExtendedFormatRecord xf = this.book.getExFormatAt(styleIndex);
        return new HSSFCellStyle(styleIndex, xf, this.book);
    }

    public boolean isGridsPrinted() {
        return this.sheet.isGridsPrinted();
    }

    public void setGridsPrinted(boolean value) {
        this.sheet.setGridsPrinted(value);
    }

    public int addMergedRegion(org.apache.poi.ss.util.Region region) {
        return this.sheet.addMergedRegion(region.getRowFrom(), region.getColumnFrom(), region.getRowTo(), region.getColumnTo());
    }

    @Override
    public int addMergedRegion(CellRangeAddress region) {
        return this.sheet.addMergedRegion(region.getFirstRow(), region.getFirstColumn(), region.getLastRow(), region.getLastColumn());
    }

    public void setForceFormulaRecalculation(boolean value) {
        this.sheet.setUncalced(value);
    }

    public boolean getForceFormulaRecalculation() {
        return this.sheet.getUncalced();
    }

    @Override
    public void setVerticallyCenter(boolean value) {
        this.sheet.getPageSettings().getVCenter().setVCenter(value);
    }

    public boolean getVerticallyCenter(boolean value) {
        return this.getVerticallyCenter();
    }

    public boolean getVerticallyCenter() {
        return this.sheet.getPageSettings().getVCenter().getVCenter();
    }

    @Override
    public void setHorizontallyCenter(boolean value) {
        this.sheet.getPageSettings().getHCenter().setHCenter(value);
    }

    @Override
    public boolean getHorizontallyCenter() {
        return this.sheet.getPageSettings().getHCenter().getHCenter();
    }

    @Override
    public void removeMergedRegion(int index) {
        this.sheet.removeMergedRegion(index);
    }

    @Override
    public int getNumMergedRegions() {
        return this.sheet.getNumMergedRegions();
    }

    public Region getMergedRegionAt(int index) {
        CellRangeAddress cra = this.getMergedRegion(index);
        return new Region(cra.getFirstRow(), (short)cra.getFirstColumn(), cra.getLastRow(), (short)cra.getLastColumn());
    }

    public CellRangeAddress getMergedRegion(int index) {
        return this.sheet.getMergedRegionAt(index);
    }

    @Override
    public Iterator<Row> rowIterator() {
        Iterator<Row> result = this.rows.values().iterator();
        return result;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rowIterator();
    }

    Sheet getSheet() {
        return this.sheet;
    }

    public void setAlternativeExpression(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setAlternateExpression(b);
    }

    public void setAlternativeFormula(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setAlternateFormula(b);
    }

    @Override
    public void setAutobreaks(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setAutobreaks(b);
    }

    public void setDialog(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setDialog(b);
    }

    @Override
    public void setDisplayGuts(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setDisplayGuts(b);
    }

    @Override
    public void setFitToPage(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setFitToPage(b);
    }

    @Override
    public void setRowSumsBelow(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setRowSumsBelow(b);
    }

    @Override
    public void setRowSumsRight(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setRowSumsRight(b);
    }

    public boolean getAlternateExpression() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getAlternateExpression();
    }

    public boolean getAlternateFormula() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getAlternateFormula();
    }

    @Override
    public boolean getAutobreaks() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getAutobreaks();
    }

    public boolean getDialog() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getDialog();
    }

    @Override
    public boolean getDisplayGuts() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getDisplayGuts();
    }

    @Override
    public boolean getFitToPage() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getFitToPage();
    }

    @Override
    public boolean getRowSumsBelow() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getRowSumsBelow();
    }

    @Override
    public boolean getRowSumsRight() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getRowSumsRight();
    }

    @Override
    public boolean isPrintGridlines() {
        return this.getSheet().getPrintGridlines().getPrintGridlines();
    }

    @Override
    public void setPrintGridlines(boolean newPrintGridlines) {
        this.getSheet().getPrintGridlines().setPrintGridlines(newPrintGridlines);
    }

    @Override
    public HSSFPrintSetup getPrintSetup() {
        return new HSSFPrintSetup(this.sheet.getPageSettings().getPrintSetup());
    }

    @Override
    public HSSFHeader getHeader() {
        return new HSSFHeader(this.sheet.getPageSettings().getHeader());
    }

    @Override
    public HSSFFooter getFooter() {
        return new HSSFFooter(this.sheet.getPageSettings().getFooter());
    }

    public boolean isSelected() {
        return this.getSheet().getWindowTwo().getSelected();
    }

    @Override
    public void setSelected(boolean sel) {
        this.getSheet().getWindowTwo().setSelected(sel);
    }

    public boolean isActive() {
        return this.getSheet().getWindowTwo().isActive();
    }

    public void setActive(boolean sel) {
        this.getSheet().getWindowTwo().setActive(sel);
    }

    @Override
    public double getMargin(short margin) {
        return this.sheet.getPageSettings().getMargin(margin);
    }

    @Override
    public void setMargin(short margin, double size) {
        this.sheet.getPageSettings().setMargin(margin, size);
    }

    @Override
    public boolean getProtect() {
        return this.getSheet().isProtected()[0];
    }

    public short getPassword() {
        return (short)this.getSheet().getPassword().getPassword();
    }

    public boolean getObjectProtect() {
        return this.getSheet().isProtected()[1];
    }

    @Override
    public boolean getScenarioProtect() {
        return this.getSheet().isProtected()[2];
    }

    public void setProtect(boolean protect) {
        this.getSheet().getProtect().setProtect(protect);
    }

    public void protectSheet(String password) {
        this.getSheet().protectSheet(password, true, true);
    }

    @Override
    public void setZoom(int numerator, int denominator) {
        if (numerator < 1 || numerator > 65535) {
            throw new IllegalArgumentException("Numerator must be greater than 1 and less than 65536");
        }
        if (denominator < 1 || denominator > 65535) {
            throw new IllegalArgumentException("Denominator must be greater than 1 and less than 65536");
        }
        SCLRecord sclRecord = new SCLRecord();
        sclRecord.setNumerator((short)numerator);
        sclRecord.setDenominator((short)denominator);
        this.getSheet().setSCLRecord(sclRecord);
    }

    @Override
    public short getTopRow() {
        return this.sheet.getTopRow();
    }

    @Override
    public short getLeftCol() {
        return this.sheet.getLeftCol();
    }

    @Override
    public void showInPane(short toprow, short leftcol) {
        this.sheet.setTopRow(toprow);
        this.sheet.setLeftCol(leftcol);
    }

    protected void shiftMerged(int startRow, int endRow, int n, boolean isRow) {
        ArrayList<CellRangeAddress> shiftedRegions = new ArrayList<CellRangeAddress>();
        for (int i = 0; i < this.getNumMergedRegions(); ++i) {
            boolean inEnd;
            CellRangeAddress merged = this.getMergedRegion(i);
            boolean inStart = merged.getFirstRow() >= startRow || merged.getLastRow() >= startRow;
            boolean bl = inEnd = merged.getFirstRow() <= endRow || merged.getLastRow() <= endRow;
            if (!inStart || !inEnd || HSSFSheet.containsCell(merged, startRow - 1, 0) || HSSFSheet.containsCell(merged, endRow + 1, 0)) continue;
            merged.setFirstRow(merged.getFirstRow() + n);
            merged.setLastRow(merged.getLastRow() + n);
            shiftedRegions.add(merged);
            this.removeMergedRegion(i);
            --i;
        }
        for (CellRangeAddress region : shiftedRegions) {
            this.addMergedRegion(region);
        }
    }

    private static boolean containsCell(CellRangeAddress cr, int rowIx, int colIx) {
        return cr.getFirstRow() <= rowIx && cr.getLastRow() >= rowIx && cr.getFirstColumn() <= colIx && cr.getLastColumn() >= colIx;
    }

    @Override
    public void shiftRows(int startRow, int endRow, int n) {
        this.shiftRows(startRow, endRow, n, false, false);
    }

    @Override
    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        this.shiftRows(startRow, endRow, n, copyRowHeight, resetOriginalRowHeight, true);
    }

    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight, boolean moveComments) {
        int inc;
        int s;
        if (n < 0) {
            s = startRow;
            inc = 1;
        } else {
            s = endRow;
            inc = -1;
        }
        NoteRecord[] noteRecs = moveComments ? this.sheet.getNoteRecords() : NoteRecord.EMPTY_ARRAY;
        this.shiftMerged(startRow, endRow, n, true);
        this.sheet.getPageSettings().shiftRowBreaks(startRow, endRow, n);
        for (int rowNum = s; rowNum >= startRow && rowNum <= endRow && rowNum >= 0 && rowNum < 65536; rowNum += inc) {
            HSSFRow row = this.getRow(rowNum);
            HSSFRow row2Replace = this.getRow(rowNum + n);
            if (row2Replace == null) {
                row2Replace = this.createRow(rowNum + n);
            }
            row2Replace.removeAllCells();
            if (row == null) continue;
            if (copyRowHeight) {
                row2Replace.setHeight(row.getHeight());
            }
            if (resetOriginalRowHeight) {
                row.setHeight((short)255);
            }
            Iterator<Cell> cells = row.cellIterator();
            while (cells.hasNext()) {
                HSSFCell cell = (HSSFCell)cells.next();
                row.removeCell(cell);
                CellValueRecordInterface cellRecord = cell.getCellValueRecord();
                cellRecord.setRow(rowNum + n);
                row2Replace.createCellFromRecord(cellRecord);
                this.sheet.addValueRecord(rowNum + n, cellRecord);
                HSSFHyperlink link = cell.getHyperlink();
                if (link == null) continue;
                link.setFirstRow(link.getFirstRow() + n);
                link.setLastRow(link.getLastRow() + n);
            }
            row.removeAllCells();
            if (!moveComments) continue;
            for (int i = noteRecs.length - 1; i >= 0; --i) {
                HSSFComment comment;
                NoteRecord nr = noteRecs[i];
                if (nr.getRow() != rowNum || (comment = this.getCellComment(rowNum, nr.getColumn())) == null) continue;
                comment.setRow(rowNum + n);
            }
        }
        if (endRow == this.lastrow || endRow + n > this.lastrow) {
            this.lastrow = Math.min(endRow + n, 65535);
        }
        if (startRow == this.firstrow || startRow + n < this.firstrow) {
            this.firstrow = Math.max(startRow + n, 0);
        }
        int sheetIndex = this.workbook.getSheetIndex(this);
        short externSheetIndex = this.book.checkExternSheet(sheetIndex);
        FormulaShifter shifter = FormulaShifter.createForRowShift(externSheetIndex, startRow, endRow, n);
        this.sheet.updateFormulasAfterCellShift(shifter, externSheetIndex);
        int nSheets = this.workbook.getNumberOfSheets();
        for (int i = 0; i < nSheets; ++i) {
            Sheet otherSheet = this.workbook.getSheetAt(i).getSheet();
            if (otherSheet == this.sheet) continue;
            short otherExtSheetIx = this.book.checkExternSheet(i);
            otherSheet.updateFormulasAfterCellShift(shifter, otherExtSheetIx);
        }
    }

    protected void insertChartRecords(List<Record> records) {
        int window2Loc = this.sheet.findFirstRecordLocBySid((short)574);
        this.sheet.getRecords().addAll(window2Loc, records);
    }

    @Override
    public void createFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        if (colSplit < 0 || colSplit > 255) {
            throw new IllegalArgumentException("Column must be between 0 and 255");
        }
        if (rowSplit < 0 || rowSplit > 65535) {
            throw new IllegalArgumentException("Row must be between 0 and 65535");
        }
        if (leftmostColumn < colSplit) {
            throw new IllegalArgumentException("leftmostColumn parameter must not be less than colSplit parameter");
        }
        if (topRow < rowSplit) {
            throw new IllegalArgumentException("topRow parameter must not be less than leftmostColumn parameter");
        }
        this.getSheet().createFreezePane(colSplit, rowSplit, topRow, leftmostColumn);
    }

    @Override
    public void createFreezePane(int colSplit, int rowSplit) {
        this.createFreezePane(colSplit, rowSplit, colSplit, rowSplit);
    }

    @Override
    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
        this.getSheet().createSplitPane(xSplitPos, ySplitPos, topRow, leftmostColumn, activePane);
    }

    @Override
    public PaneInformation getPaneInformation() {
        return this.getSheet().getPaneInformation();
    }

    @Override
    public void setDisplayGridlines(boolean show) {
        this.sheet.setDisplayGridlines(show);
    }

    @Override
    public boolean isDisplayGridlines() {
        return this.sheet.isDisplayGridlines();
    }

    @Override
    public void setDisplayFormulas(boolean show) {
        this.sheet.setDisplayFormulas(show);
    }

    @Override
    public boolean isDisplayFormulas() {
        return this.sheet.isDisplayFormulas();
    }

    @Override
    public void setDisplayRowColHeadings(boolean show) {
        this.sheet.setDisplayRowColHeadings(show);
    }

    @Override
    public boolean isDisplayRowColHeadings() {
        return this.sheet.isDisplayRowColHeadings();
    }

    @Override
    public void setRowBreak(int row) {
        this.validateRow(row);
        this.sheet.getPageSettings().setRowBreak(row, (short)0, (short)255);
    }

    @Override
    public boolean isRowBroken(int row) {
        return this.sheet.getPageSettings().isRowBroken(row);
    }

    @Override
    public void removeRowBreak(int row) {
        this.sheet.getPageSettings().removeRowBreak(row);
    }

    @Override
    public int[] getRowBreaks() {
        return this.sheet.getPageSettings().getRowBreaks();
    }

    @Override
    public int[] getColumnBreaks() {
        return this.sheet.getPageSettings().getColumnBreaks();
    }

    @Override
    public void setColumnBreak(short column) {
        this.validateColumn(column);
        this.sheet.getPageSettings().setColumnBreak(column, (short)0, (short)-1);
    }

    @Override
    public boolean isColumnBroken(short column) {
        return this.sheet.getPageSettings().isColumnBroken(column);
    }

    @Override
    public void removeColumnBreak(short column) {
        this.sheet.getPageSettings().removeColumnBreak(column);
    }

    protected void validateRow(int row) {
        if (row > 65535) {
            throw new IllegalArgumentException("Maximum row number is 65535");
        }
        if (row < 0) {
            throw new IllegalArgumentException("Minumum row number is 0");
        }
    }

    protected void validateColumn(short column) {
        if (column > 255) {
            throw new IllegalArgumentException("Maximum column number is 255");
        }
        if (column < 0) {
            throw new IllegalArgumentException("Minimum column number is 0");
        }
    }

    public void dumpDrawingRecords(boolean fat) {
        this.sheet.aggregateDrawingRecords(this.book.getDrawingManager(), false);
        EscherAggregate r = (EscherAggregate)this.getSheet().findFirstRecordBySid((short)9876);
        List escherRecords = r.getEscherRecords();
        PrintWriter w = new PrintWriter(System.out);
        for (EscherRecord escherRecord : escherRecords) {
            if (fat) {
                System.out.println(escherRecord.toString());
                continue;
            }
            escherRecord.display(w, 0);
        }
        w.flush();
    }

    @Override
    public HSSFPatriarch createDrawingPatriarch() {
        this.book.createDrawingGroup();
        this.sheet.aggregateDrawingRecords(this.book.getDrawingManager(), true);
        EscherAggregate agg = (EscherAggregate)this.sheet.findFirstRecordBySid((short)9876);
        HSSFPatriarch patriarch = new HSSFPatriarch(this, agg);
        agg.clear();
        agg.setPatriarch(patriarch);
        return patriarch;
    }

    public EscherAggregate getDrawingEscherAggregate() {
        this.book.findDrawingGroup();
        if (this.book.getDrawingManager() == null) {
            return null;
        }
        int found = this.sheet.aggregateDrawingRecords(this.book.getDrawingManager(), false);
        if (found == -1) {
            return null;
        }
        EscherAggregate agg = (EscherAggregate)this.sheet.findFirstRecordBySid((short)9876);
        return agg;
    }

    public HSSFPatriarch getDrawingPatriarch() {
        EscherAggregate agg = this.getDrawingEscherAggregate();
        if (agg == null) {
            return null;
        }
        HSSFPatriarch patriarch = new HSSFPatriarch(this, agg);
        agg.setPatriarch(patriarch);
        agg.convertRecordsToUserModel();
        return patriarch;
    }

    public void setColumnGroupCollapsed(short columnNumber, boolean collapsed) {
        this.setColumnGroupCollapsed(columnNumber & 0xFFFF, collapsed);
    }

    public void groupColumn(short fromColumn, short toColumn) {
        this.groupColumn(fromColumn & 0xFFFF, toColumn & 0xFFFF);
    }

    public void ungroupColumn(short fromColumn, short toColumn) {
        this.ungroupColumn(fromColumn & 0xFFFF, toColumn & 0xFFFF);
    }

    @Override
    public void setColumnGroupCollapsed(int columnNumber, boolean collapsed) {
        this.sheet.setColumnGroupCollapsed(columnNumber, collapsed);
    }

    @Override
    public void groupColumn(int fromColumn, int toColumn) {
        this.sheet.groupColumnRange(fromColumn, toColumn, true);
    }

    @Override
    public void ungroupColumn(int fromColumn, int toColumn) {
        this.sheet.groupColumnRange(fromColumn, toColumn, false);
    }

    @Override
    public void groupRow(int fromRow, int toRow) {
        this.sheet.groupRowRange(fromRow, toRow, true);
    }

    @Override
    public void ungroupRow(int fromRow, int toRow) {
        this.sheet.groupRowRange(fromRow, toRow, false);
    }

    @Override
    public void setRowGroupCollapsed(int rowIndex, boolean collapse) {
        if (collapse) {
            this.sheet.getRowsAggregate().collapseRow(rowIndex);
        } else {
            this.sheet.getRowsAggregate().expandRow(rowIndex);
        }
    }

    @Override
    public void setDefaultColumnStyle(int column, CellStyle style) {
        this.sheet.setDefaultColumnStyle(column, ((HSSFCellStyle)style).getIndex());
    }

    @Override
    public void autoSizeColumn(int column) {
        this.autoSizeColumn(column, false);
    }

    @Override
    public void autoSizeColumn(int column, boolean useMergedCells) {
        char defaultChar = '0';
        double fontHeightMultiple = 2.0;
        FontRenderContext frc = new FontRenderContext(null, true, true);
        HSSFWorkbook wb = new HSSFWorkbook(this.book);
        HSSFFont defaultFont = wb.getFontAt((short)0);
        AttributedString str = new AttributedString("" + defaultChar);
        this.copyAttributes(defaultFont, str, 0, 1);
        TextLayout layout = new TextLayout(str.getIterator(), frc);
        int defaultCharWidth = (int)layout.getAdvance();
        double width = -1.0;
        Iterator<Row> it = this.rowIterator();
        block2: while (it.hasNext()) {
            String sval;
            HSSFFont font;
            HSSFCellStyle style;
            int colspan;
            HSSFCell cell;
            block16: {
                HSSFRow row = (HSSFRow)it.next();
                cell = row.getCell(column);
                if (cell == null) continue;
                colspan = 1;
                for (int i = 0; i < this.getNumMergedRegions(); ++i) {
                    CellRangeAddress region = this.getMergedRegion(i);
                    if (!HSSFSheet.containsCell(region, row.getRowNum(), column)) continue;
                    if (!useMergedCells) continue block2;
                    cell = row.getCell(region.getFirstColumn());
                    colspan = 1 + region.getLastColumn() - region.getFirstColumn();
                }
                style = cell.getCellStyle();
                font = wb.getFontAt(style.getFontIndex());
                if (cell.getCellType() == 1) {
                    HSSFRichTextString rt = cell.getRichStringCellValue();
                    String[] lines = rt.getString().split("\\n");
                    for (int i = 0; i < lines.length; ++i) {
                        String txt = lines[i] + defaultChar;
                        str = new AttributedString(txt);
                        this.copyAttributes(font, str, 0, txt.length());
                        if (rt.numFormattingRuns() > 0) {
                            for (int j = 0; j < lines[i].length(); ++j) {
                                short idx = rt.getFontAtIndex(j);
                                if (idx == 0) continue;
                                HSSFFont fnt = wb.getFontAt(idx);
                                this.copyAttributes(fnt, str, j, j + 1);
                            }
                        }
                        layout = new TextLayout(str.getIterator(), frc);
                        if (style.getRotation() != 0) {
                            AffineTransform trans = new AffineTransform();
                            trans.concatenate(AffineTransform.getRotateInstance((double)style.getRotation() * 2.0 * Math.PI / 360.0));
                            trans.concatenate(AffineTransform.getScaleInstance(1.0, fontHeightMultiple));
                            width = Math.max(width, layout.getOutline(trans).getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
                            continue;
                        }
                        width = Math.max(width, layout.getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
                    }
                    continue;
                }
                sval = null;
                if (cell.getCellType() == 0) {
                    String format = style.getDataFormatString().replaceAll("\"", "");
                    double value = cell.getNumericCellValue();
                    try {
                        if ("General".equals(format)) {
                            sval = "" + value;
                            break block16;
                        }
                        DecimalFormat fmt = new DecimalFormat(format);
                        sval = fmt.format(value);
                    }
                    catch (Exception e) {
                        sval = "" + value;
                    }
                } else if (cell.getCellType() == 4) {
                    sval = String.valueOf(cell.getBooleanCellValue());
                }
            }
            if (sval == null) continue;
            String txt = sval + defaultChar;
            str = new AttributedString(txt);
            this.copyAttributes(font, str, 0, txt.length());
            layout = new TextLayout(str.getIterator(), frc);
            if (style.getRotation() != 0) {
                AffineTransform trans = new AffineTransform();
                trans.concatenate(AffineTransform.getRotateInstance((double)style.getRotation() * 2.0 * Math.PI / 360.0));
                trans.concatenate(AffineTransform.getScaleInstance(1.0, fontHeightMultiple));
                width = Math.max(width, layout.getOutline(trans).getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
                continue;
            }
            width = Math.max(width, layout.getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
        }
        if (width != -1.0) {
            if ((width *= 256.0) > 32767.0) {
                width = 32767.0;
            }
            this.sheet.setColumnWidth(column, (short)width);
        }
    }

    private void copyAttributes(HSSFFont font, AttributedString str, int startIdx, int endIdx) {
        str.addAttribute(TextAttribute.FAMILY, font.getFontName(), startIdx, endIdx);
        str.addAttribute(TextAttribute.SIZE, new Float(font.getFontHeightInPoints()));
        if (font.getBoldweight() == 700) {
            str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, startIdx, endIdx);
        }
        if (font.getItalic()) {
            str.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, startIdx, endIdx);
        }
        if (font.getUnderline() == 1) {
            str.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, startIdx, endIdx);
        }
    }

    @Override
    public HSSFComment getCellComment(int row, int column) {
        HSSFRow r = this.getRow(row);
        if (r != null) {
            HSSFCell c = r.getCell(column);
            if (c != null) {
                return c.getCellComment();
            }
            return HSSFCell.findCellComment(this.sheet, row, column);
        }
        return null;
    }

    public HSSFSheetConditionalFormatting getSheetConditionalFormatting() {
        return new HSSFSheetConditionalFormatting(this);
    }
}

