/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFTextbox;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.RichTextString;

public class HSSFComment
extends HSSFTextbox
implements Comment {
    private boolean _visible;
    private int _row;
    private int _col;
    private String _author;
    private NoteRecord _note;
    private TextObjectRecord _txo;

    public HSSFComment(HSSFShape parent, HSSFAnchor anchor) {
        super(parent, anchor);
        this.setShapeType(25);
        this.fillColor = 0x8000050;
        this._visible = false;
        this._author = "";
    }

    protected HSSFComment(NoteRecord note, TextObjectRecord txo) {
        this((HSSFShape)null, (HSSFAnchor)null);
        this._txo = txo;
        this._note = note;
    }

    public void setVisible(boolean visible) {
        if (this._note != null) {
            this._note.setFlags(visible ? (short)2 : 0);
        }
        this._visible = visible;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public int getRow() {
        return this._row;
    }

    public void setRow(int row) {
        if (this._note != null) {
            this._note.setRow(row);
        }
        this._row = row;
    }

    public int getColumn() {
        return this._col;
    }

    public void setColumn(short col) {
        if (this._note != null) {
            this._note.setColumn(col);
        }
        this._col = col;
    }

    public String getAuthor() {
        return this._author;
    }

    public void setAuthor(String author) {
        if (this._note != null) {
            this._note.setAuthor(author);
        }
        this._author = author;
    }

    public void setString(RichTextString string) {
        HSSFRichTextString hstring = (HSSFRichTextString)string;
        if (hstring.numFormattingRuns() == 0) {
            hstring.applyFont((short)0);
        }
        if (this._txo != null) {
            this._txo.setStr(hstring);
        }
        super.setString(string);
    }

    protected NoteRecord getNoteRecord() {
        return this._note;
    }

    protected TextObjectRecord getTextObjectRecord() {
        return this._txo;
    }
}

