/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.pivottable;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class PageItemRecord
extends StandardRecord {
    public static final short sid = 182;
    private int isxvi;
    private int isxvd;
    private int idObj;

    public PageItemRecord(RecordInputStream in) {
        this.isxvi = in.readShort();
        this.isxvd = in.readShort();
        this.idObj = in.readShort();
    }

    protected void serialize(LittleEndianOutput out) {
        out.writeShort(this.isxvi);
        out.writeShort(this.isxvd);
        out.writeShort(this.idObj);
    }

    protected int getDataSize() {
        return 6;
    }

    public short getSid() {
        return 182;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SXPI]\n");
        buffer.append("    .isxvi      =").append(HexDump.shortToHex(this.isxvi)).append('\n');
        buffer.append("    .isxvd      =").append(HexDump.shortToHex(this.isxvd)).append('\n');
        buffer.append("    .idObj      =").append(HexDump.shortToHex(this.idObj)).append('\n');
        buffer.append("[/SXPI]\n");
        return buffer.toString();
    }
}

