/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.pivottable;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.StringUtil;

public final class ExtendedPivotTableViewFieldsRecord
extends StandardRecord {
    public static final short sid = 256;
    private static final int STRING_NOT_PRESENT_LEN = -1;
    private int grbit1;
    private int grbit2;
    private int citmShow;
    private int isxdiSort;
    private int isxdiShow;
    private int reserved1;
    private int reserved2;
    private String subName;

    public ExtendedPivotTableViewFieldsRecord(RecordInputStream in) {
        this.grbit1 = in.readInt();
        this.grbit2 = in.readUByte();
        this.citmShow = in.readUByte();
        this.isxdiSort = in.readUShort();
        this.isxdiShow = in.readUShort();
        int cchSubName = in.readUShort();
        this.reserved1 = in.readInt();
        this.reserved2 = in.readInt();
        if (cchSubName != -1) {
            this.subName = in.readUnicodeLEString(cchSubName);
        }
    }

    protected void serialize(LittleEndianOutput out) {
        out.writeInt(this.grbit1);
        out.writeByte(this.grbit2);
        out.writeByte(this.citmShow);
        out.writeShort(this.isxdiSort);
        out.writeShort(this.isxdiShow);
        if (this.subName == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(this.subName.length());
        }
        out.writeInt(this.reserved1);
        out.writeInt(this.reserved2);
        if (this.subName != null) {
            StringUtil.putUnicodeLE(this.subName, out);
        }
    }

    protected int getDataSize() {
        return 20 + (this.subName == null ? 0 : 2 * this.subName.length());
    }

    public short getSid() {
        return 256;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SXVDEX]\n");
        buffer.append("    .grbit1 =").append(HexDump.intToHex(this.grbit1)).append("\n");
        buffer.append("    .grbit2 =").append(HexDump.byteToHex(this.grbit2)).append("\n");
        buffer.append("    .citmShow =").append(HexDump.byteToHex(this.citmShow)).append("\n");
        buffer.append("    .isxdiSort =").append(HexDump.shortToHex(this.isxdiSort)).append("\n");
        buffer.append("    .isxdiShow =").append(HexDump.shortToHex(this.isxdiShow)).append("\n");
        buffer.append("    .subName =").append(this.subName).append("\n");
        buffer.append("[/SXVDEX]\n");
        return buffer.toString();
    }
}

