/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.OperationEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;

public final class RangeEval
implements OperationEval {
    public static final OperationEval instance = new RangeEval();

    private RangeEval() {
    }

    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        if (args.length != 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            RefEval reA = RangeEval.evaluateRef(args[0]);
            RefEval reB = RangeEval.evaluateRef(args[1]);
            return RangeEval.resolveRange(reA, reB);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    private static AreaEval resolveRange(RefEval reA, RefEval reB) {
        int height = reB.getRow() - reA.getRow();
        int width = reB.getColumn() - reA.getColumn();
        return reA.offset(0, height, 0, width);
    }

    private static RefEval evaluateRef(Eval arg) throws EvaluationException {
        if (arg instanceof RefEval) {
            return (RefEval)arg;
        }
        if (arg instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)arg);
        }
        throw new IllegalArgumentException("Unexpected ref arg class (" + arg.getClass().getName() + ")");
    }

    public int getNumberOfOperands() {
        return 2;
    }
}

