/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.chart;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class SheetPropertiesRecord
extends StandardRecord {
    public static final short sid = 4164;
    private static final BitField chartTypeManuallyFormatted = BitFieldFactory.getInstance(1);
    private static final BitField plotVisibleOnly = BitFieldFactory.getInstance(2);
    private static final BitField doNotSizeWithWindow = BitFieldFactory.getInstance(4);
    private static final BitField defaultPlotDimensions = BitFieldFactory.getInstance(8);
    private static final BitField autoPlotArea = BitFieldFactory.getInstance(16);
    private short field_1_flags;
    private byte field_2_empty;
    public static final byte EMPTY_NOT_PLOTTED = 0;
    public static final byte EMPTY_ZERO = 1;
    public static final byte EMPTY_INTERPOLATED = 2;

    public SheetPropertiesRecord() {
    }

    public SheetPropertiesRecord(RecordInputStream in) {
        this.field_1_flags = in.readShort();
        this.field_2_empty = in.readByte();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SHTPROPS]\n");
        buffer.append("    .flags                = ").append("0x").append(HexDump.toHex(this.getFlags())).append(" (").append(this.getFlags()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .chartTypeManuallyFormatted     = ").append(this.isChartTypeManuallyFormatted()).append('\n');
        buffer.append("         .plotVisibleOnly          = ").append(this.isPlotVisibleOnly()).append('\n');
        buffer.append("         .doNotSizeWithWindow      = ").append(this.isDoNotSizeWithWindow()).append('\n');
        buffer.append("         .defaultPlotDimensions     = ").append(this.isDefaultPlotDimensions()).append('\n');
        buffer.append("         .autoPlotArea             = ").append(this.isAutoPlotArea()).append('\n');
        buffer.append("    .empty                = ").append("0x").append(HexDump.toHex(this.getEmpty())).append(" (").append(this.getEmpty()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/SHTPROPS]\n");
        return buffer.toString();
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.field_1_flags);
        out.writeByte(this.field_2_empty);
    }

    protected int getDataSize() {
        return 3;
    }

    public short getSid() {
        return 4164;
    }

    public Object clone() {
        SheetPropertiesRecord rec = new SheetPropertiesRecord();
        rec.field_1_flags = this.field_1_flags;
        rec.field_2_empty = this.field_2_empty;
        return rec;
    }

    public short getFlags() {
        return this.field_1_flags;
    }

    public void setFlags(short field_1_flags) {
        this.field_1_flags = field_1_flags;
    }

    public byte getEmpty() {
        return this.field_2_empty;
    }

    public void setEmpty(byte field_2_empty) {
        this.field_2_empty = field_2_empty;
    }

    public void setChartTypeManuallyFormatted(boolean value) {
        this.field_1_flags = chartTypeManuallyFormatted.setShortBoolean(this.field_1_flags, value);
    }

    public boolean isChartTypeManuallyFormatted() {
        return chartTypeManuallyFormatted.isSet(this.field_1_flags);
    }

    public void setPlotVisibleOnly(boolean value) {
        this.field_1_flags = plotVisibleOnly.setShortBoolean(this.field_1_flags, value);
    }

    public boolean isPlotVisibleOnly() {
        return plotVisibleOnly.isSet(this.field_1_flags);
    }

    public void setDoNotSizeWithWindow(boolean value) {
        this.field_1_flags = doNotSizeWithWindow.setShortBoolean(this.field_1_flags, value);
    }

    public boolean isDoNotSizeWithWindow() {
        return doNotSizeWithWindow.isSet(this.field_1_flags);
    }

    public void setDefaultPlotDimensions(boolean value) {
        this.field_1_flags = defaultPlotDimensions.setShortBoolean(this.field_1_flags, value);
    }

    public boolean isDefaultPlotDimensions() {
        return defaultPlotDimensions.isSet(this.field_1_flags);
    }

    public void setAutoPlotArea(boolean value) {
        this.field_1_flags = autoPlotArea.setShortBoolean(this.field_1_flags, value);
    }

    public boolean isAutoPlotArea() {
        return autoPlotArea.isSet(this.field_1_flags);
    }
}

