/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.hssf.util.RKUtil;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class RKRecord
extends StandardRecord
implements CellValueRecordInterface {
    public static final short sid = 638;
    public static final short RK_IEEE_NUMBER = 0;
    public static final short RK_IEEE_NUMBER_TIMES_100 = 1;
    public static final short RK_INTEGER = 2;
    public static final short RK_INTEGER_TIMES_100 = 3;
    private int field_1_row;
    private int field_2_col;
    private int field_3_xf_index;
    private int field_4_rk_number;

    private RKRecord() {
    }

    public RKRecord(RecordInputStream in) {
        this.field_1_row = in.readUShort();
        this.field_2_col = in.readUShort();
        this.field_3_xf_index = in.readUShort();
        this.field_4_rk_number = in.readInt();
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return (short)this.field_2_col;
    }

    public short getXFIndex() {
        return (short)this.field_3_xf_index;
    }

    public int getRKField() {
        return this.field_4_rk_number;
    }

    public short getRKType() {
        return (short)(this.field_4_rk_number & 3);
    }

    public double getRKNumber() {
        return RKUtil.decodeNumber(this.field_4_rk_number);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[RK]\n");
        sb.append("    .row       = ").append(HexDump.shortToHex(this.getRow())).append("\n");
        sb.append("    .col       = ").append(HexDump.shortToHex(this.getColumn())).append("\n");
        sb.append("    .xfindex   = ").append(HexDump.shortToHex(this.getXFIndex())).append("\n");
        sb.append("    .rknumber  = ").append(HexDump.intToHex(this.getRKField())).append("\n");
        sb.append("      .rktype  = ").append(HexDump.byteToHex(this.getRKType())).append("\n");
        sb.append("      .rknumber= ").append(this.getRKNumber()).append("\n");
        sb.append("[/RK]\n");
        return sb.toString();
    }

    public void serialize(LittleEndianOutput out) {
        throw new RecordFormatException("Sorry, you can't serialize RK in this release");
    }

    protected int getDataSize() {
        throw new RecordFormatException("Sorry, you can't serialize RK in this release");
    }

    public short getSid() {
        return 638;
    }

    public void setColumn(short col) {
    }

    public void setRow(int row) {
    }

    public void setXFIndex(short xf) {
    }

    public Object clone() {
        RKRecord rec = new RKRecord();
        rec.field_1_row = this.field_1_row;
        rec.field_2_col = this.field_2_col;
        rec.field_3_xf_index = this.field_3_xf_index;
        rec.field_4_rk_number = this.field_4_rk_number;
        return rec;
    }
}

