/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.StringUtil;

abstract class HeaderFooterBase
extends StandardRecord {
    private boolean field_2_hasMultibyte;
    private String field_3_text;

    protected HeaderFooterBase(String text) {
        this.setText(text);
    }

    protected HeaderFooterBase(RecordInputStream in) {
        if (in.remaining() > 0) {
            short field_1_footer_len = in.readShort();
            boolean bl = this.field_2_hasMultibyte = in.readByte() != 0;
            this.field_3_text = this.field_2_hasMultibyte ? in.readUnicodeLEString(field_1_footer_len) : in.readCompressedUnicode(field_1_footer_len);
        } else {
            this.field_3_text = "";
        }
    }

    public final void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        this.field_2_hasMultibyte = StringUtil.hasMultibyte(text);
        this.field_3_text = text;
        if (this.field_2_hasMultibyte) {
            if (this.field_3_text.length() > 127) {
                throw new IllegalArgumentException("Footer string too long (limit is 127 for unicode strings)");
            }
        } else if (this.field_3_text.length() > 255) {
            throw new IllegalArgumentException("Footer string too long (limit is 255 for non-unicode strings)");
        }
    }

    private int getTextLength() {
        return this.field_3_text.length();
    }

    public final String getText() {
        return this.field_3_text;
    }

    public final void serialize(LittleEndianOutput out) {
        if (this.getTextLength() > 0) {
            out.writeShort(this.getTextLength());
            out.writeByte(this.field_2_hasMultibyte ? 1 : 0);
            if (this.field_2_hasMultibyte) {
                StringUtil.putUnicodeLE(this.field_3_text, out);
            } else {
                StringUtil.putCompressedUnicode(this.field_3_text, out);
            }
        }
    }

    protected final int getDataSize() {
        if (this.getTextLength() < 1) {
            return 0;
        }
        return 3 + this.getTextLength() * (this.field_2_hasMultibyte ? 2 : 1);
    }
}

