/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.ss.formula.Formula;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.StringUtil;

public final class ExternalNameRecord
extends StandardRecord {
    public static final short sid = 35;
    private static final int OPT_BUILTIN_NAME = 1;
    private static final int OPT_AUTOMATIC_LINK = 2;
    private static final int OPT_PICTURE_LINK = 4;
    private static final int OPT_STD_DOCUMENT_NAME = 8;
    private static final int OPT_OLE_LINK = 16;
    private static final int OPT_ICONIFIED_PICTURE_LINK = 32768;
    private short field_1_option_flag;
    private short field_2_index;
    private short field_3_not_used;
    private String field_4_name;
    private Formula field_5_name_definition;

    public boolean isBuiltInName() {
        return (this.field_1_option_flag & 1) != 0;
    }

    public boolean isAutomaticLink() {
        return (this.field_1_option_flag & 2) != 0;
    }

    public boolean isPicureLink() {
        return (this.field_1_option_flag & 4) != 0;
    }

    public boolean isStdDocumentNameIdentifier() {
        return (this.field_1_option_flag & 8) != 0;
    }

    public boolean isOLELink() {
        return (this.field_1_option_flag & 0x10) != 0;
    }

    public boolean isIconifiedPictureLink() {
        return (this.field_1_option_flag & 0x8000) != 0;
    }

    public String getText() {
        return this.field_4_name;
    }

    protected int getDataSize() {
        int result = 8 + this.field_4_name.length();
        if (this.hasFormula()) {
            result += this.field_5_name_definition.getEncodedSize();
        }
        return result;
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.field_1_option_flag);
        out.writeShort(this.field_2_index);
        out.writeShort(this.field_3_not_used);
        int nameLen = this.field_4_name.length();
        out.writeShort(nameLen);
        StringUtil.putCompressedUnicode(this.field_4_name, out);
        if (this.hasFormula()) {
            this.field_5_name_definition.serialize(out);
        }
    }

    public ExternalNameRecord(RecordInputStream in) {
        this.field_1_option_flag = in.readShort();
        this.field_2_index = in.readShort();
        this.field_3_not_used = in.readShort();
        short nameLength = in.readShort();
        this.field_4_name = in.readCompressedUnicode(nameLength);
        if (!this.hasFormula()) {
            if (in.remaining() > 0) {
                throw this.readFail("Some unread data (is formula present?)");
            }
            this.field_5_name_definition = null;
            return;
        }
        int nBytesRemaining = in.available();
        if (nBytesRemaining <= 0) {
            throw this.readFail("Ran out of record data trying to read formula.");
        }
        int formulaLen = in.readUShort();
        this.field_5_name_definition = Formula.read(formulaLen, in, nBytesRemaining -= 2);
    }

    private RuntimeException readFail(String msg) {
        String fullMsg = msg + " fields: (option=" + this.field_1_option_flag + " index=" + this.field_2_index + " not_used=" + this.field_3_not_used + " name='" + this.field_4_name + "')";
        return new RecordFormatException(fullMsg);
    }

    private boolean hasFormula() {
        return !this.isAutomaticLink();
    }

    public short getSid() {
        return 35;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" [EXTERNALNAME ");
        sb.append(" ").append(this.field_4_name);
        sb.append(" ix=").append(this.field_2_index);
        sb.append("]");
        return sb.toString();
    }
}

