/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherBoolProperty;
import org.apache.poi.ddf.EscherClientAnchorRecord;
import org.apache.poi.ddf.EscherClientDataRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherDgRecord;
import org.apache.poi.ddf.EscherDggRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSerializationListener;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.ddf.EscherSpgrRecord;
import org.apache.poi.ddf.EscherTextboxRecord;
import org.apache.poi.hssf.model.AbstractShape;
import org.apache.poi.hssf.model.CommentShape;
import org.apache.poi.hssf.model.ConvertAnchor;
import org.apache.poi.hssf.model.DrawingManager2;
import org.apache.poi.hssf.model.TextboxShape;
import org.apache.poi.hssf.record.AbstractEscherHolderRecord;
import org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import org.apache.poi.hssf.record.DrawingRecord;
import org.apache.poi.hssf.record.EndSubRecord;
import org.apache.poi.hssf.record.GroupMarkerSubRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFShapeContainer;
import org.apache.poi.hssf.usermodel.HSSFShapeGroup;
import org.apache.poi.hssf.usermodel.HSSFTextbox;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class EscherAggregate
extends AbstractEscherHolderRecord {
    public static final short sid = 9876;
    private static POILogger log = POILogFactory.getLogger(EscherAggregate.class);
    public static final short ST_MIN = 0;
    public static final short ST_NOT_PRIMATIVE = 0;
    public static final short ST_RECTANGLE = 1;
    public static final short ST_ROUNDRECTANGLE = 2;
    public static final short ST_ELLIPSE = 3;
    public static final short ST_DIAMOND = 4;
    public static final short ST_ISOCELESTRIANGLE = 5;
    public static final short ST_RIGHTTRIANGLE = 6;
    public static final short ST_PARALLELOGRAM = 7;
    public static final short ST_TRAPEZOID = 8;
    public static final short ST_HEXAGON = 9;
    public static final short ST_OCTAGON = 10;
    public static final short ST_PLUS = 11;
    public static final short ST_STAR = 12;
    public static final short ST_ARROW = 13;
    public static final short ST_THICKARROW = 14;
    public static final short ST_HOMEPLATE = 15;
    public static final short ST_CUBE = 16;
    public static final short ST_BALLOON = 17;
    public static final short ST_SEAL = 18;
    public static final short ST_ARC = 19;
    public static final short ST_LINE = 20;
    public static final short ST_PLAQUE = 21;
    public static final short ST_CAN = 22;
    public static final short ST_DONUT = 23;
    public static final short ST_TEXTSIMPLE = 24;
    public static final short ST_TEXTOCTAGON = 25;
    public static final short ST_TEXTHEXAGON = 26;
    public static final short ST_TEXTCURVE = 27;
    public static final short ST_TEXTWAVE = 28;
    public static final short ST_TEXTRING = 29;
    public static final short ST_TEXTONCURVE = 30;
    public static final short ST_TEXTONRING = 31;
    public static final short ST_STRAIGHTCONNECTOR1 = 32;
    public static final short ST_BENTCONNECTOR2 = 33;
    public static final short ST_BENTCONNECTOR3 = 34;
    public static final short ST_BENTCONNECTOR4 = 35;
    public static final short ST_BENTCONNECTOR5 = 36;
    public static final short ST_CURVEDCONNECTOR2 = 37;
    public static final short ST_CURVEDCONNECTOR3 = 38;
    public static final short ST_CURVEDCONNECTOR4 = 39;
    public static final short ST_CURVEDCONNECTOR5 = 40;
    public static final short ST_CALLOUT1 = 41;
    public static final short ST_CALLOUT2 = 42;
    public static final short ST_CALLOUT3 = 43;
    public static final short ST_ACCENTCALLOUT1 = 44;
    public static final short ST_ACCENTCALLOUT2 = 45;
    public static final short ST_ACCENTCALLOUT3 = 46;
    public static final short ST_BORDERCALLOUT1 = 47;
    public static final short ST_BORDERCALLOUT2 = 48;
    public static final short ST_BORDERCALLOUT3 = 49;
    public static final short ST_ACCENTBORDERCALLOUT1 = 50;
    public static final short ST_ACCENTBORDERCALLOUT2 = 51;
    public static final short ST_ACCENTBORDERCALLOUT3 = 52;
    public static final short ST_RIBBON = 53;
    public static final short ST_RIBBON2 = 54;
    public static final short ST_CHEVRON = 55;
    public static final short ST_PENTAGON = 56;
    public static final short ST_NOSMOKING = 57;
    public static final short ST_SEAL8 = 58;
    public static final short ST_SEAL16 = 59;
    public static final short ST_SEAL32 = 60;
    public static final short ST_WEDGERECTCALLOUT = 61;
    public static final short ST_WEDGERRECTCALLOUT = 62;
    public static final short ST_WEDGEELLIPSECALLOUT = 63;
    public static final short ST_WAVE = 64;
    public static final short ST_FOLDEDCORNER = 65;
    public static final short ST_LEFTARROW = 66;
    public static final short ST_DOWNARROW = 67;
    public static final short ST_UPARROW = 68;
    public static final short ST_LEFTRIGHTARROW = 69;
    public static final short ST_UPDOWNARROW = 70;
    public static final short ST_IRREGULARSEAL1 = 71;
    public static final short ST_IRREGULARSEAL2 = 72;
    public static final short ST_LIGHTNINGBOLT = 73;
    public static final short ST_HEART = 74;
    public static final short ST_PICTUREFRAME = 75;
    public static final short ST_QUADARROW = 76;
    public static final short ST_LEFTARROWCALLOUT = 77;
    public static final short ST_RIGHTARROWCALLOUT = 78;
    public static final short ST_UPARROWCALLOUT = 79;
    public static final short ST_DOWNARROWCALLOUT = 80;
    public static final short ST_LEFTRIGHTARROWCALLOUT = 81;
    public static final short ST_UPDOWNARROWCALLOUT = 82;
    public static final short ST_QUADARROWCALLOUT = 83;
    public static final short ST_BEVEL = 84;
    public static final short ST_LEFTBRACKET = 85;
    public static final short ST_RIGHTBRACKET = 86;
    public static final short ST_LEFTBRACE = 87;
    public static final short ST_RIGHTBRACE = 88;
    public static final short ST_LEFTUPARROW = 89;
    public static final short ST_BENTUPARROW = 90;
    public static final short ST_BENTARROW = 91;
    public static final short ST_SEAL24 = 92;
    public static final short ST_STRIPEDRIGHTARROW = 93;
    public static final short ST_NOTCHEDRIGHTARROW = 94;
    public static final short ST_BLOCKARC = 95;
    public static final short ST_SMILEYFACE = 96;
    public static final short ST_VERTICALSCROLL = 97;
    public static final short ST_HORIZONTALSCROLL = 98;
    public static final short ST_CIRCULARARROW = 99;
    public static final short ST_NOTCHEDCIRCULARARROW = 100;
    public static final short ST_UTURNARROW = 101;
    public static final short ST_CURVEDRIGHTARROW = 102;
    public static final short ST_CURVEDLEFTARROW = 103;
    public static final short ST_CURVEDUPARROW = 104;
    public static final short ST_CURVEDDOWNARROW = 105;
    public static final short ST_CLOUDCALLOUT = 106;
    public static final short ST_ELLIPSERIBBON = 107;
    public static final short ST_ELLIPSERIBBON2 = 108;
    public static final short ST_FLOWCHARTPROCESS = 109;
    public static final short ST_FLOWCHARTDECISION = 110;
    public static final short ST_FLOWCHARTINPUTOUTPUT = 111;
    public static final short ST_FLOWCHARTPREDEFINEDPROCESS = 112;
    public static final short ST_FLOWCHARTINTERNALSTORAGE = 113;
    public static final short ST_FLOWCHARTDOCUMENT = 114;
    public static final short ST_FLOWCHARTMULTIDOCUMENT = 115;
    public static final short ST_FLOWCHARTTERMINATOR = 116;
    public static final short ST_FLOWCHARTPREPARATION = 117;
    public static final short ST_FLOWCHARTMANUALINPUT = 118;
    public static final short ST_FLOWCHARTMANUALOPERATION = 119;
    public static final short ST_FLOWCHARTCONNECTOR = 120;
    public static final short ST_FLOWCHARTPUNCHEDCARD = 121;
    public static final short ST_FLOWCHARTPUNCHEDTAPE = 122;
    public static final short ST_FLOWCHARTSUMMINGJUNCTION = 123;
    public static final short ST_FLOWCHARTOR = 124;
    public static final short ST_FLOWCHARTCOLLATE = 125;
    public static final short ST_FLOWCHARTSORT = 126;
    public static final short ST_FLOWCHARTEXTRACT = 127;
    public static final short ST_FLOWCHARTMERGE = 128;
    public static final short ST_FLOWCHARTOFFLINESTORAGE = 129;
    public static final short ST_FLOWCHARTONLINESTORAGE = 130;
    public static final short ST_FLOWCHARTMAGNETICTAPE = 131;
    public static final short ST_FLOWCHARTMAGNETICDISK = 132;
    public static final short ST_FLOWCHARTMAGNETICDRUM = 133;
    public static final short ST_FLOWCHARTDISPLAY = 134;
    public static final short ST_FLOWCHARTDELAY = 135;
    public static final short ST_TEXTPLAINTEXT = 136;
    public static final short ST_TEXTSTOP = 137;
    public static final short ST_TEXTTRIANGLE = 138;
    public static final short ST_TEXTTRIANGLEINVERTED = 139;
    public static final short ST_TEXTCHEVRON = 140;
    public static final short ST_TEXTCHEVRONINVERTED = 141;
    public static final short ST_TEXTRINGINSIDE = 142;
    public static final short ST_TEXTRINGOUTSIDE = 143;
    public static final short ST_TEXTARCHUPCURVE = 144;
    public static final short ST_TEXTARCHDOWNCURVE = 145;
    public static final short ST_TEXTCIRCLECURVE = 146;
    public static final short ST_TEXTBUTTONCURVE = 147;
    public static final short ST_TEXTARCHUPPOUR = 148;
    public static final short ST_TEXTARCHDOWNPOUR = 149;
    public static final short ST_TEXTCIRCLEPOUR = 150;
    public static final short ST_TEXTBUTTONPOUR = 151;
    public static final short ST_TEXTCURVEUP = 152;
    public static final short ST_TEXTCURVEDOWN = 153;
    public static final short ST_TEXTCASCADEUP = 154;
    public static final short ST_TEXTCASCADEDOWN = 155;
    public static final short ST_TEXTWAVE1 = 156;
    public static final short ST_TEXTWAVE2 = 157;
    public static final short ST_TEXTWAVE3 = 158;
    public static final short ST_TEXTWAVE4 = 159;
    public static final short ST_TEXTINFLATE = 160;
    public static final short ST_TEXTDEFLATE = 161;
    public static final short ST_TEXTINFLATEBOTTOM = 162;
    public static final short ST_TEXTDEFLATEBOTTOM = 163;
    public static final short ST_TEXTINFLATETOP = 164;
    public static final short ST_TEXTDEFLATETOP = 165;
    public static final short ST_TEXTDEFLATEINFLATE = 166;
    public static final short ST_TEXTDEFLATEINFLATEDEFLATE = 167;
    public static final short ST_TEXTFADERIGHT = 168;
    public static final short ST_TEXTFADELEFT = 169;
    public static final short ST_TEXTFADEUP = 170;
    public static final short ST_TEXTFADEDOWN = 171;
    public static final short ST_TEXTSLANTUP = 172;
    public static final short ST_TEXTSLANTDOWN = 173;
    public static final short ST_TEXTCANUP = 174;
    public static final short ST_TEXTCANDOWN = 175;
    public static final short ST_FLOWCHARTALTERNATEPROCESS = 176;
    public static final short ST_FLOWCHARTOFFPAGECONNECTOR = 177;
    public static final short ST_CALLOUT90 = 178;
    public static final short ST_ACCENTCALLOUT90 = 179;
    public static final short ST_BORDERCALLOUT90 = 180;
    public static final short ST_ACCENTBORDERCALLOUT90 = 181;
    public static final short ST_LEFTRIGHTUPARROW = 182;
    public static final short ST_SUN = 183;
    public static final short ST_MOON = 184;
    public static final short ST_BRACKETPAIR = 185;
    public static final short ST_BRACEPAIR = 186;
    public static final short ST_SEAL4 = 187;
    public static final short ST_DOUBLEWAVE = 188;
    public static final short ST_ACTIONBUTTONBLANK = 189;
    public static final short ST_ACTIONBUTTONHOME = 190;
    public static final short ST_ACTIONBUTTONHELP = 191;
    public static final short ST_ACTIONBUTTONINFORMATION = 192;
    public static final short ST_ACTIONBUTTONFORWARDNEXT = 193;
    public static final short ST_ACTIONBUTTONBACKPREVIOUS = 194;
    public static final short ST_ACTIONBUTTONEND = 195;
    public static final short ST_ACTIONBUTTONBEGINNING = 196;
    public static final short ST_ACTIONBUTTONRETURN = 197;
    public static final short ST_ACTIONBUTTONDOCUMENT = 198;
    public static final short ST_ACTIONBUTTONSOUND = 199;
    public static final short ST_ACTIONBUTTONMOVIE = 200;
    public static final short ST_HOSTCONTROL = 201;
    public static final short ST_TEXTBOX = 202;
    public static final short ST_NIL = 4095;
    protected HSSFPatriarch patriarch;
    private Map shapeToObj = new HashMap();
    private DrawingManager2 drawingManager;
    private short drawingGroupId;
    private List tailRec = new ArrayList();

    public EscherAggregate(DrawingManager2 drawingManager) {
        this.drawingManager = drawingManager;
    }

    public short getSid() {
        return 9876;
    }

    public String toString() {
        String nl = System.getProperty("line.separtor");
        StringBuffer result = new StringBuffer();
        result.append('[').append(this.getRecordName()).append(']' + nl);
        for (EscherRecord escherRecord : this.getEscherRecords()) {
            result.append(escherRecord.toString());
        }
        result.append("[/").append(this.getRecordName()).append(']' + nl);
        return result.toString();
    }

    public static EscherAggregate createAggregate(List records, int locFirstDrawingRecord, DrawingManager2 drawingManager) {
        int bytesRead;
        final ArrayList shapeRecords = new ArrayList();
        DefaultEscherRecordFactory recordFactory = new DefaultEscherRecordFactory(){

            public EscherRecord createRecord(byte[] data, int offset) {
                EscherRecord r = super.createRecord(data, offset);
                if (r.getRecordId() == -4079 || r.getRecordId() == -4083) {
                    shapeRecords.add(r);
                }
                return r;
            }
        };
        EscherAggregate agg = new EscherAggregate(drawingManager);
        int loc = locFirstDrawingRecord;
        int dataSize = 0;
        while (loc + 1 < records.size() && EscherAggregate.sid(records, loc) == 236 && EscherAggregate.isObjectRecord(records, loc + 1)) {
            dataSize += ((DrawingRecord)records.get(loc)).getData().length;
            loc += 2;
        }
        byte[] buffer = new byte[dataSize];
        int offset = 0;
        loc = locFirstDrawingRecord;
        while (loc + 1 < records.size() && EscherAggregate.sid(records, loc) == 236 && EscherAggregate.isObjectRecord(records, loc + 1)) {
            DrawingRecord drawingRecord = (DrawingRecord)records.get(loc);
            System.arraycopy(drawingRecord.getData(), 0, buffer, offset, drawingRecord.getData().length);
            offset += drawingRecord.getData().length;
            loc += 2;
        }
        for (int pos = 0; pos < dataSize; pos += bytesRead) {
            EscherRecord r = recordFactory.createRecord(buffer, pos);
            bytesRead = r.fillFields(buffer, pos, recordFactory);
            agg.addEscherRecord(r);
        }
        loc = locFirstDrawingRecord;
        int shapeIndex = 0;
        agg.shapeToObj = new HashMap();
        while (loc + 1 < records.size() && EscherAggregate.sid(records, loc) == 236 && EscherAggregate.isObjectRecord(records, loc + 1)) {
            Record objRecord = (Record)records.get(loc + 1);
            agg.shapeToObj.put(shapeRecords.get(shapeIndex++), objRecord);
            loc += 2;
        }
        return agg;
    }

    public int serialize(int offset, byte[] data) {
        int i;
        this.convertUserModelToRecords();
        List records = this.getEscherRecords();
        int size = this.getEscherRecordSize(records);
        byte[] buffer = new byte[size];
        final ArrayList spEndingOffsets = new ArrayList();
        final ArrayList shapes = new ArrayList();
        int pos = 0;
        for (EscherRecord e : records) {
            pos += e.serialize(pos, buffer, new EscherSerializationListener(){

                public void beforeRecordSerialize(int offset, short recordId, EscherRecord record) {
                }

                public void afterRecordSerialize(int offset, short recordId, int size, EscherRecord record) {
                    if (recordId == -4079 || recordId == -4083) {
                        spEndingOffsets.add(new Integer(offset));
                        shapes.add(record);
                    }
                }
            });
        }
        shapes.add(0, null);
        spEndingOffsets.add(0, null);
        pos = offset;
        for (i = 1; i < shapes.size(); ++i) {
            int endOffset = (Integer)spEndingOffsets.get(i) - 1;
            int startOffset = i == 1 ? 0 : (Integer)spEndingOffsets.get(i - 1);
            DrawingRecord drawing = new DrawingRecord();
            byte[] drawingData = new byte[endOffset - startOffset + 1];
            System.arraycopy(buffer, startOffset, drawingData, 0, drawingData.length);
            drawing.setData(drawingData);
            int temp = drawing.serialize(pos, data);
            pos += temp;
            Record obj = (Record)this.shapeToObj.get(shapes.get(i));
            temp = obj.serialize(pos, data);
            pos += temp;
        }
        for (i = 0; i < this.tailRec.size(); ++i) {
            Record rec = (Record)this.tailRec.get(i);
            pos += rec.serialize(pos, data);
        }
        int bytesWritten = pos - offset;
        if (bytesWritten != this.getRecordSize()) {
            throw new RecordFormatException(bytesWritten + " bytes written but getRecordSize() reports " + this.getRecordSize());
        }
        return bytesWritten;
    }

    private int getEscherRecordSize(List records) {
        int size = 0;
        Iterator iterator = records.iterator();
        while (iterator.hasNext()) {
            size += ((EscherRecord)iterator.next()).getRecordSize();
        }
        return size;
    }

    public int getRecordSize() {
        this.convertUserModelToRecords();
        List records = this.getEscherRecords();
        int rawEscherSize = this.getEscherRecordSize(records);
        int drawingRecordSize = rawEscherSize + this.shapeToObj.size() * 4;
        int objRecordSize = 0;
        for (Record r : this.shapeToObj.values()) {
            objRecordSize += r.getRecordSize();
        }
        int tailRecordSize = 0;
        for (Record r : this.tailRec) {
            tailRecordSize += r.getRecordSize();
        }
        return drawingRecordSize + objRecordSize + tailRecordSize;
    }

    public Object assoicateShapeToObjRecord(EscherRecord r, Record objRecord) {
        return this.shapeToObj.put(r, objRecord);
    }

    public HSSFPatriarch getPatriarch() {
        return this.patriarch;
    }

    public void setPatriarch(HSSFPatriarch patriarch) {
        this.patriarch = patriarch;
    }

    public void convertRecordsToUserModel() {
        if (this.patriarch == null) {
            throw new IllegalStateException("Must call setPatriarch() first");
        }
        EscherContainerRecord topContainer = this.getEscherContainer();
        if (topContainer == null) {
            return;
        }
        List tcc = (topContainer = (EscherContainerRecord)topContainer.getChildContainers().get(0)).getChildContainers();
        if (tcc.size() == 0) {
            throw new IllegalStateException("No child escher containers at the point that should hold the patriach data, and one container per top level shape!");
        }
        EscherContainerRecord patriachContainer = (EscherContainerRecord)tcc.get(0);
        EscherSpgrRecord spgr = null;
        for (EscherRecord r : patriachContainer.getChildRecords()) {
            if (!(r instanceof EscherSpgrRecord)) continue;
            spgr = (EscherSpgrRecord)r;
            break;
        }
        if (spgr != null) {
            this.patriarch.setCoordinates(spgr.getRectX1(), spgr.getRectY1(), spgr.getRectX2(), spgr.getRectY2());
        }
        for (int i = 1; i < tcc.size(); ++i) {
            EscherContainerRecord shapeContainer = (EscherContainerRecord)tcc.get(i);
            if (shapeContainer.getChildRecords().size() == 1 && shapeContainer.getChildContainers().size() == 1) {
                HSSFShapeGroup group = new HSSFShapeGroup(null, new HSSFClientAnchor());
                this.patriarch.getChildren().add(group);
                EscherContainerRecord groupContainer = (EscherContainerRecord)shapeContainer.getChild(0);
                this.convertRecordsToUserModel(groupContainer, group);
                continue;
            }
            if (shapeContainer.hasChildOfType((short)-4083)) {
                HSSFTextbox box = new HSSFTextbox(null, new HSSFClientAnchor());
                this.patriarch.getChildren().add(box);
                this.convertRecordsToUserModel(shapeContainer, box);
                continue;
            }
            if (shapeContainer.hasChildOfType((short)-4079)) continue;
            this.convertRecordsToUserModel(shapeContainer, this.patriarch);
        }
        this.drawingManager.getDgg().setFileIdClusters(new EscherDggRecord.FileIdCluster[0]);
        log.log(5, "Not processing objects into Patriarch!");
    }

    private void convertRecordsToUserModel(EscherContainerRecord shapeContainer, Object model) {
        for (EscherRecord r : shapeContainer.getChildRecords()) {
            HSSFShape g;
            if (r instanceof EscherSpgrRecord) {
                EscherSpgrRecord spgr = (EscherSpgrRecord)r;
                if (model instanceof HSSFShapeGroup) {
                    g = (HSSFShapeGroup)model;
                    ((HSSFShapeGroup)g).setCoordinates(spgr.getRectX1(), spgr.getRectY1(), spgr.getRectX2(), spgr.getRectY2());
                    continue;
                }
                throw new IllegalStateException("Got top level anchor but not processing a group");
            }
            if (r instanceof EscherClientAnchorRecord) {
                EscherClientAnchorRecord car = (EscherClientAnchorRecord)r;
                if (model instanceof HSSFShape) {
                    g = (HSSFShape)model;
                    g.getAnchor().setDx1(car.getDx1());
                    g.getAnchor().setDx2(car.getDx2());
                    g.getAnchor().setDy1(car.getDy1());
                    g.getAnchor().setDy2(car.getDy2());
                    continue;
                }
                throw new IllegalStateException("Got top level anchor but not processing a group or shape");
            }
            if (r instanceof EscherTextboxRecord) {
                EscherTextboxRecord tbr = (EscherTextboxRecord)r;
                continue;
            }
            if (!(r instanceof EscherSpRecord) && !(r instanceof EscherOptRecord)) continue;
        }
    }

    public void clear() {
        this.clearEscherRecords();
        this.shapeToObj.clear();
    }

    protected String getRecordName() {
        return "ESCHERAGGREGATE";
    }

    private static boolean isObjectRecord(List records, int loc) {
        return EscherAggregate.sid(records, loc) == 93 || EscherAggregate.sid(records, loc) == 438;
    }

    private void convertUserModelToRecords() {
        if (this.patriarch != null) {
            this.shapeToObj.clear();
            this.tailRec.clear();
            this.clearEscherRecords();
            if (this.patriarch.getChildren().size() != 0) {
                this.convertPatriarch(this.patriarch);
                EscherContainerRecord dgContainer = (EscherContainerRecord)this.getEscherRecord(0);
                EscherContainerRecord spgrContainer = null;
                for (int i = 0; i < dgContainer.getChildRecords().size(); ++i) {
                    if (dgContainer.getChild(i).getRecordId() != -4093) continue;
                    spgrContainer = (EscherContainerRecord)dgContainer.getChild(i);
                }
                this.convertShapes(this.patriarch, spgrContainer, this.shapeToObj);
                this.patriarch = null;
            }
        }
    }

    private void convertShapes(HSSFShapeContainer parent, EscherContainerRecord escherParent, Map shapeToObj) {
        if (escherParent == null) {
            throw new IllegalArgumentException("Parent record required");
        }
        List shapes = parent.getChildren();
        for (HSSFShape shape : shapes) {
            if (shape instanceof HSSFShapeGroup) {
                this.convertGroup((HSSFShapeGroup)shape, escherParent, shapeToObj);
                continue;
            }
            AbstractShape shapeModel = AbstractShape.createShape(shape, this.drawingManager.allocateShapeId(this.drawingGroupId));
            shapeToObj.put(this.findClientData(shapeModel.getSpContainer()), shapeModel.getObjRecord());
            if (shapeModel instanceof TextboxShape) {
                EscherRecord escherTextbox = ((TextboxShape)shapeModel).getEscherTextbox();
                shapeToObj.put(escherTextbox, ((TextboxShape)shapeModel).getTextObjectRecord());
                if (shapeModel instanceof CommentShape) {
                    CommentShape comment = (CommentShape)shapeModel;
                    this.tailRec.add(comment.getNoteRecord());
                }
            }
            escherParent.addChildRecord(shapeModel.getSpContainer());
        }
    }

    private void convertGroup(HSSFShapeGroup shape, EscherContainerRecord escherParent, Map shapeToObj) {
        EscherContainerRecord spgrContainer = new EscherContainerRecord();
        EscherContainerRecord spContainer = new EscherContainerRecord();
        EscherSpgrRecord spgr = new EscherSpgrRecord();
        EscherSpRecord sp = new EscherSpRecord();
        EscherOptRecord opt = new EscherOptRecord();
        EscherClientDataRecord clientData = new EscherClientDataRecord();
        spgrContainer.setRecordId((short)-4093);
        spgrContainer.setOptions((short)15);
        spContainer.setRecordId((short)-4092);
        spContainer.setOptions((short)15);
        spgr.setRecordId((short)-4087);
        spgr.setOptions((short)1);
        spgr.setRectX1(shape.getX1());
        spgr.setRectY1(shape.getY1());
        spgr.setRectX2(shape.getX2());
        spgr.setRectY2(shape.getY2());
        sp.setRecordId((short)-4086);
        sp.setOptions((short)2);
        int shapeId = this.drawingManager.allocateShapeId(this.drawingGroupId);
        sp.setShapeId(shapeId);
        if (shape.getAnchor() instanceof HSSFClientAnchor) {
            sp.setFlags(513);
        } else {
            sp.setFlags(515);
        }
        opt.setRecordId((short)-4085);
        opt.setOptions((short)35);
        opt.addEscherProperty(new EscherBoolProperty(127, 262148));
        opt.addEscherProperty(new EscherBoolProperty(959, 524288));
        EscherRecord anchor = ConvertAnchor.createAnchor(shape.getAnchor());
        clientData.setRecordId((short)-4079);
        clientData.setOptions((short)0);
        spgrContainer.addChildRecord(spContainer);
        spContainer.addChildRecord(spgr);
        spContainer.addChildRecord(sp);
        spContainer.addChildRecord(opt);
        spContainer.addChildRecord(anchor);
        spContainer.addChildRecord(clientData);
        ObjRecord obj = new ObjRecord();
        CommonObjectDataSubRecord cmo = new CommonObjectDataSubRecord();
        cmo.setObjectType((short)0);
        cmo.setObjectId((short)shapeId);
        cmo.setLocked(true);
        cmo.setPrintable(true);
        cmo.setAutofill(true);
        cmo.setAutoline(true);
        GroupMarkerSubRecord gmo = new GroupMarkerSubRecord();
        EndSubRecord end = new EndSubRecord();
        obj.addSubRecord(cmo);
        obj.addSubRecord(gmo);
        obj.addSubRecord(end);
        shapeToObj.put(clientData, obj);
        escherParent.addChildRecord(spgrContainer);
        this.convertShapes(shape, spgrContainer, shapeToObj);
    }

    private EscherRecord findClientData(EscherContainerRecord spContainer) {
        for (EscherRecord r : spContainer.getChildRecords()) {
            if (r.getRecordId() != -4079) continue;
            return r;
        }
        throw new IllegalArgumentException("Can not find client data record");
    }

    private void convertPatriarch(HSSFPatriarch patriarch) {
        EscherContainerRecord dgContainer = new EscherContainerRecord();
        EscherContainerRecord spgrContainer = new EscherContainerRecord();
        EscherContainerRecord spContainer1 = new EscherContainerRecord();
        EscherSpgrRecord spgr = new EscherSpgrRecord();
        EscherSpRecord sp1 = new EscherSpRecord();
        dgContainer.setRecordId((short)-4094);
        dgContainer.setOptions((short)15);
        EscherDgRecord dg = this.drawingManager.createDgRecord();
        this.drawingGroupId = dg.getDrawingGroupId();
        spgrContainer.setRecordId((short)-4093);
        spgrContainer.setOptions((short)15);
        spContainer1.setRecordId((short)-4092);
        spContainer1.setOptions((short)15);
        spgr.setRecordId((short)-4087);
        spgr.setOptions((short)1);
        spgr.setRectX1(patriarch.getX1());
        spgr.setRectY1(patriarch.getY1());
        spgr.setRectX2(patriarch.getX2());
        spgr.setRectY2(patriarch.getY2());
        sp1.setRecordId((short)-4086);
        sp1.setOptions((short)2);
        sp1.setShapeId(this.drawingManager.allocateShapeId(dg.getDrawingGroupId()));
        sp1.setFlags(5);
        dgContainer.addChildRecord(dg);
        dgContainer.addChildRecord(spgrContainer);
        spgrContainer.addChildRecord(spContainer1);
        spContainer1.addChildRecord(spgr);
        spContainer1.addChildRecord(sp1);
        this.addEscherRecord(dgContainer);
    }

    private static short sid(List records, int loc) {
        return ((Record)records.get(loc)).getSid();
    }
}

