/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.common.function;

import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSNull;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.common.PDRange;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.common.function.PDStreamFunction;

public class PDFunctionType0
extends PDStreamFunction {
    protected PDFunctionType0(PDDocument doc) {
        super(doc, 0);
    }

    public PDFunctionType0(PDStream functionDictionary) {
        super(functionDictionary);
    }

    public List getNumberOfSamples() {
        List retval = null;
        COSArray size = (COSArray)this.getCOSStream().getDictionaryObject("Size");
        if (size != null) {
            retval = COSArrayList.convertIntegerCOSArrayToList(size);
        }
        return retval;
    }

    public void setNumberOfSamples(List samples) {
        this.getCOSStream().setItem("Size", (COSBase)COSArrayList.converterToCOSArray(samples));
    }

    public int getBitsPerSample() {
        return this.getCOSStream().getInt("BitsPerSample");
    }

    public void setBitsPerSample(int bps) {
        this.getCOSStream().setInt("BitsPerSample", bps);
    }

    public PDRange getEncodeForParameter(int paramNum) {
        PDRange retval = null;
        COSArray encode = (COSArray)this.getCOSStream().getDictionaryObject("Encode");
        if (encode != null && encode.size() >= paramNum * 2 + 1) {
            retval = new PDRange(encode, paramNum);
        }
        return retval;
    }

    public void setEncodeForParameter(int paramNum, PDRange range) {
        COSArray encode = (COSArray)this.getCOSStream().getDictionaryObject("Encode");
        if (encode == null) {
            encode = new COSArray();
        }
        for (int i = encode.size(); i < paramNum * 2 + 1; ++i) {
            encode.add(COSNull.NULL);
        }
        encode.set(paramNum * 2, new COSFloat(range.getMin()));
        encode.set(paramNum * 2 + 1, new COSFloat(range.getMax()));
    }

    public PDRange getDecodeForParameter(int paramNum) {
        PDRange retval = null;
        COSArray encode = (COSArray)this.getCOSStream().getDictionaryObject("Decode");
        if (encode != null && encode.size() >= paramNum * 2 + 1) {
            retval = new PDRange(encode, paramNum);
        }
        return retval;
    }

    public void setDecodeForParameter(int paramNum, PDRange range) {
        COSArray encode = (COSArray)this.getCOSStream().getDictionaryObject("Decode");
        if (encode == null) {
            encode = new COSArray();
        }
        for (int i = encode.size(); i < paramNum * 2 + 1; ++i) {
            encode.add(COSNull.NULL);
        }
        encode.set(paramNum * 2, new COSFloat(range.getMin()));
        encode.set(paramNum * 2 + 1, new COSFloat(range.getMax()));
    }
}

