/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.bridges.jni_uno;

import com.sun.star.lib.util.AsynchronousFinalizer;
import com.sun.star.lib.util.NativeLibraryLoader;
import com.sun.star.uno.IEnvironment;
import com.sun.star.uno.IQueryInterface;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class JNI_proxy
implements InvocationHandler {
    protected static ClassLoader s_classloader;
    protected static Class[] s_InvocationHandler;
    protected long m_bridge_handle;
    protected IEnvironment m_java_env;
    protected long m_receiver_handle;
    protected long m_td_handle;
    protected Type m_type;
    protected String m_oid;
    protected Class m_class;

    public static String get_stack_trace(Throwable throwable) throws Throwable {
        boolean bl = false;
        if (null == throwable) {
            throwable = new Throwable();
            bl = true;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        printWriter.close();
        stringWriter.flush();
        String string = stringWriter.toString();
        if (bl) {
            int n = string.indexOf(10);
            n = string.indexOf(10, n + 1);
            string = string.substring(n + 1);
        }
        return "\njava stack trace:\n" + string;
    }

    private native void finalize(long var1);

    public void finalize() {
        AsynchronousFinalizer.add((AsynchronousFinalizer.Job)new AsynchronousFinalizer.Job(){

            public void run() throws Throwable {
                JNI_proxy.this.finalize(JNI_proxy.this.m_bridge_handle);
            }
        });
    }

    private JNI_proxy(long l, IEnvironment iEnvironment, long l2, long l3, Type type, String string) {
        this.m_bridge_handle = l;
        this.m_java_env = iEnvironment;
        this.m_receiver_handle = l2;
        this.m_td_handle = l3;
        this.m_type = type;
        this.m_oid = string;
        this.m_class = this.m_type.getZClass();
    }

    public static Object create(long l, IEnvironment iEnvironment, long l2, long l3, Type type, String string, Constructor constructor) throws Throwable {
        JNI_proxy jNI_proxy = new JNI_proxy(l, iEnvironment, l2, l3, type, string);
        Object t = constructor.newInstance(jNI_proxy);
        return iEnvironment.registerInterface(t, new String[]{string}, type);
    }

    public static Constructor get_proxy_ctor(Class clazz) throws Throwable {
        Class<?> clazz2 = Proxy.getProxyClass(s_classloader, clazz, IQueryInterface.class, com.sun.star.lib.uno.Proxy.class);
        return clazz2.getConstructor(s_InvocationHandler);
    }

    private native Object dispatch_call(long var1, String var3, String var4, Object[] var5) throws Throwable;

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Class<?> clazz = method.getDeclaringClass();
        String string = method.getName();
        if (Object.class.equals(clazz)) {
            if (string.equals("hashCode")) {
                return new Integer(this.m_oid.hashCode());
            }
            if (string.equals("equals")) {
                return this.isSame(objectArray[0]);
            }
            if (string.equals("toString")) {
                return this.toString() + " [oid=" + this.m_oid + ", type=" + this.m_type.getTypeName() + "]";
            }
        } else {
            if (clazz.isAssignableFrom(this.m_class)) {
                return this.dispatch_call(this.m_bridge_handle, clazz.getName(), string, objectArray);
            }
            if (IQueryInterface.class.equals(clazz)) {
                if (string.equals("queryInterface")) {
                    Object object2 = this.m_java_env.getRegisteredInterface(this.m_oid, (Type)objectArray[0]);
                    if (null == object2) {
                        return this.dispatch_call(this.m_bridge_handle, "com.sun.star.uno.XInterface", string, objectArray);
                    }
                    return object2;
                }
                if (string.equals("isSame")) {
                    return this.isSame(objectArray[0]);
                }
                if (string.equals("getOid")) {
                    return this.m_oid;
                }
            }
        }
        throw new RuntimeException("[jni_uno bridge error] unexpected call on proxy " + object.toString() + ": " + method.toString());
    }

    private Boolean isSame(Object object) {
        return new Boolean(object != null && this.m_oid.equals(UnoRuntime.generateOid((Object)object)));
    }

    static {
        NativeLibraryLoader.loadLibrary((ClassLoader)JNI_proxy.class.getClassLoader(), (String)"java_uno");
        s_classloader = JNI_proxy.class.getClassLoader();
        s_InvocationHandler = new Class[]{InvocationHandler.class};
    }
}

