/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpbf.model.qcbits;

import org.apache.poi.hpbf.model.qcbits.QCBit;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class QCPLCBit
extends QCBit {
    protected int numberOfPLCs;
    protected int typeOfPLCS;
    protected int[] preData;
    protected long[] plcValA;
    protected long[] plcValB;

    private QCPLCBit(String thingType, String bitType, byte[] data) {
        super(thingType, bitType, data);
        this.numberOfPLCs = (int)LittleEndian.getUInt((byte[])data, (int)0);
        this.typeOfPLCS = (int)LittleEndian.getUInt((byte[])data, (int)4);
        this.plcValA = new long[this.numberOfPLCs];
        this.plcValB = new long[this.numberOfPLCs];
    }

    public int getNumberOfPLCs() {
        return this.numberOfPLCs;
    }

    public int getTypeOfPLCS() {
        return this.typeOfPLCS;
    }

    public int[] getPreData() {
        return this.preData;
    }

    public long[] getPlcValA() {
        return this.plcValA;
    }

    public long[] getPlcValB() {
        return this.plcValB;
    }

    public static QCPLCBit createQCPLCBit(String thingType, String bitType, byte[] data) {
        int type = (int)LittleEndian.getUInt((byte[])data, (int)4);
        switch (type) {
            case 0: {
                return new Type0(thingType, bitType, data);
            }
            case 4: {
                return new Type4(thingType, bitType, data);
            }
            case 8: {
                return new Type8(thingType, bitType, data);
            }
            case 12: {
                return new Type12(thingType, bitType, data);
            }
        }
        throw new IllegalArgumentException("Sorry, I don't know how to deal with PLCs of type " + type);
    }

    public static class Type12
    extends QCPLCBit {
        private String[] hyperlinks;
        private static final int oneStartsAt = 76;
        private static final int twoStartsAt = 104;
        private static final int threePlusIncrement = 22;

        private Type12(String thingType, String bitType, byte[] data) {
            super(thingType, bitType, data);
            int i;
            this.hyperlinks = data.length == 52 ? new String[0] : new String[this.numberOfPLCs];
            this.preData = new int[1 + this.numberOfPLCs + 1];
            for (int i2 = 0; i2 < this.preData.length; ++i2) {
                this.preData[i2] = (int)LittleEndian.getUInt((byte[])data, (int)(8 + i2 * 4));
            }
            int at = 12 + this.numberOfPLCs * 4 + 4;
            int until = 52;
            if (this.numberOfPLCs == 1 && this.hyperlinks.length == 1) {
                until = 76;
            } else if (this.numberOfPLCs >= 2) {
                until = 104 + (this.numberOfPLCs - 2) * 22;
            }
            this.plcValA = new long[(until - at) / 2];
            this.plcValB = new long[0];
            for (i = 0; i < this.plcValA.length; ++i) {
                this.plcValA[i] = LittleEndian.getUShort((byte[])data, (int)(at + i * 2));
            }
            at = until;
            for (i = 0; i < this.hyperlinks.length; ++i) {
                int len = LittleEndian.getUShort((byte[])data, (int)at);
                int first = LittleEndian.getUShort((byte[])data, (int)(at + 2));
                if (first == 0) {
                    this.hyperlinks[i] = "";
                    at += len;
                    continue;
                }
                this.hyperlinks[i] = StringUtil.getFromUnicodeLE((byte[])data, (int)(at + 2), (int)len);
                at += 2 + 2 * len;
            }
        }

        public int getNumberOfHyperlinks() {
            return this.hyperlinks.length;
        }

        public String getHyperlink(int number) {
            return this.hyperlinks[number];
        }

        public int getTextStartAt(int number) {
            return this.preData[1 + number];
        }

        public int getAllTextEndAt() {
            return this.preData[this.numberOfPLCs + 1];
        }
    }

    public static class Type8
    extends QCPLCBit {
        private Type8(String thingType, String bitType, byte[] data) {
            super(thingType, bitType, data);
            this.preData = new int[7];
            this.preData[0] = LittleEndian.getUShort((byte[])data, (int)8);
            this.preData[1] = LittleEndian.getUShort((byte[])data, (int)10);
            this.preData[2] = LittleEndian.getUShort((byte[])data, (int)12);
            this.preData[3] = LittleEndian.getUShort((byte[])data, (int)14);
            this.preData[4] = LittleEndian.getUShort((byte[])data, (int)16);
            this.preData[5] = LittleEndian.getUShort((byte[])data, (int)18);
            this.preData[6] = LittleEndian.getUShort((byte[])data, (int)20);
            for (int i = 0; i < this.numberOfPLCs; ++i) {
                this.plcValA[i] = LittleEndian.getUInt((byte[])data, (int)(22 + 8 * i));
                this.plcValB[i] = LittleEndian.getUInt((byte[])data, (int)(22 + 8 * i + 4));
            }
        }
    }

    public static class Type4
    extends QCPLCBit {
        private Type4(String thingType, String bitType, byte[] data) {
            super(thingType, bitType, data);
            this.preData = new int[4];
            this.preData[0] = LittleEndian.getUShort((byte[])data, (int)8);
            this.preData[1] = LittleEndian.getUShort((byte[])data, (int)10);
            this.preData[2] = LittleEndian.getUShort((byte[])data, (int)12);
            this.preData[3] = LittleEndian.getUShort((byte[])data, (int)14);
            for (int i = 0; i < this.numberOfPLCs; ++i) {
                this.plcValA[i] = LittleEndian.getUInt((byte[])data, (int)(16 + 8 * i));
                this.plcValB[i] = LittleEndian.getUInt((byte[])data, (int)(16 + 8 * i + 4));
            }
        }
    }

    public static class Type0
    extends QCPLCBit {
        private Type0(String thingType, String bitType, byte[] data) {
            super(thingType, bitType, data);
            this.preData = new int[4];
            this.preData[0] = LittleEndian.getUShort((byte[])data, (int)8);
            this.preData[1] = LittleEndian.getUShort((byte[])data, (int)10);
            this.preData[2] = LittleEndian.getUShort((byte[])data, (int)12);
            this.preData[3] = LittleEndian.getUShort((byte[])data, (int)14);
            for (int i = 0; i < this.numberOfPLCs; ++i) {
                this.plcValA[i] = LittleEndian.getUShort((byte[])data, (int)(16 + 4 * i));
                this.plcValB[i] = LittleEndian.getUShort((byte[])data, (int)(16 + 4 * i + 2));
            }
        }
    }
}

