/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.opendocument;

import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.opendocument.NSNormalizerContentHandler;
import org.apache.tika.parser.xml.DcXMLParser;
import org.apache.tika.parser.xml.MetadataHandler;
import org.apache.tika.sax.TeeContentHandler;
import org.apache.tika.sax.xpath.CompositeMatcher;
import org.apache.tika.sax.xpath.Matcher;
import org.apache.tika.sax.xpath.MatchingContentHandler;
import org.apache.tika.sax.xpath.XPathParser;
import org.xml.sax.ContentHandler;

public class OpenOfficeMetaParser
extends DcXMLParser {
    private static final XPathParser META_XPATH = new XPathParser("meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");

    private static ContentHandler getMeta(ContentHandler ch, Metadata md, String name, String element) {
        CompositeMatcher matcher = new CompositeMatcher(META_XPATH.parse("//meta:" + element), META_XPATH.parse("//meta:" + element + "//text()"));
        MatchingContentHandler branch = new MatchingContentHandler(new MetadataHandler(md, name), matcher);
        return new TeeContentHandler(ch, branch);
    }

    private static ContentHandler getStatistic(ContentHandler ch, Metadata md, String name, String attribute) {
        Matcher matcher = META_XPATH.parse("//meta:document-statistic/@meta:" + attribute);
        MatchingContentHandler branch = new MatchingContentHandler(new MetadataHandler(md, name), matcher);
        return new TeeContentHandler(ch, branch);
    }

    protected ContentHandler getContentHandler(ContentHandler ch, Metadata md) {
        ch = super.getContentHandler(ch, md);
        ch = OpenOfficeMetaParser.getMeta(ch, md, "Keywords", "keyword");
        ch = OpenOfficeMetaParser.getMeta(ch, md, "generator", "generator");
        ch = OpenOfficeMetaParser.getStatistic(ch, md, "nbTab", "table-count");
        ch = OpenOfficeMetaParser.getStatistic(ch, md, "nbObject", "object-count");
        ch = OpenOfficeMetaParser.getStatistic(ch, md, "nbImg", "image-count");
        ch = OpenOfficeMetaParser.getStatistic(ch, md, "nbPage", "page-count");
        ch = OpenOfficeMetaParser.getStatistic(ch, md, "nbPara", "paragraph-count");
        ch = OpenOfficeMetaParser.getStatistic(ch, md, "nbWord", "word-count");
        ch = OpenOfficeMetaParser.getStatistic(ch, md, "nbCharacter", "character-count");
        ch = new NSNormalizerContentHandler(ch);
        return ch;
    }
}

