/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import org.apache.poi.POIOLE2TextExtractor;
import org.apache.poi.hdgf.extractor.VisioTextExtractor;
import org.apache.poi.hpsf.CustomProperties;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.MarkUnsupportedException;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.UnexpectedPropertySetTypeException;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.microsoft.ExcelExtractor;
import org.apache.tika.parser.microsoft.OutlookExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OfficeParser
implements Parser {
    private static final String SUMMARY_INFORMATION = "\u0005SummaryInformation";
    private static final String DOCUMENT_SUMMARY_INFORMATION = "\u0005DocumentSummaryInformation";

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        boolean outlookExtracted = false;
        POIFSFileSystem filesystem = new POIFSFileSystem(stream);
        Iterator entries = filesystem.getRoot().getEntries();
        while (entries.hasNext()) {
            POIOLE2TextExtractor extractor;
            Entry entry = (Entry)entries.next();
            String name = entry.getName();
            if (!(entry instanceof DocumentEntry)) continue;
            if (SUMMARY_INFORMATION.equals(name) || DOCUMENT_SUMMARY_INFORMATION.equals(name)) {
                this.parse((DocumentEntry)entry, metadata);
                continue;
            }
            if ("WordDocument".equals(name)) {
                this.setType(metadata, "application/msword");
                extractor = new WordExtractor(filesystem);
                this.addTextIfAny(xhtml, "header", ((WordExtractor)extractor).getHeaderText());
                for (String paragraph : ((WordExtractor)extractor).getParagraphText()) {
                    xhtml.element("p", paragraph);
                }
                this.addTextIfAny(xhtml, "footer", ((WordExtractor)extractor).getFooterText());
                continue;
            }
            if ("PowerPoint Document".equals(name)) {
                this.setType(metadata, "application/vnd.ms-powerpoint");
                extractor = new PowerPointExtractor(filesystem);
                xhtml.element("p", ((PowerPointExtractor)extractor).getText(true, true));
                continue;
            }
            if ("Workbook".equals(name)) {
                this.setType(metadata, "application/vnd.ms-excel");
                new ExcelExtractor().parse(filesystem, xhtml);
                continue;
            }
            if ("VisioDocument".equals(name)) {
                this.setType(metadata, "application/vnd.visio");
                extractor = new VisioTextExtractor(filesystem);
                for (String text : ((VisioTextExtractor)extractor).getAllText()) {
                    xhtml.element("p", text);
                }
                continue;
            }
            if (outlookExtracted || !name.startsWith("__substg1.0_")) continue;
            outlookExtracted = true;
            this.setType(metadata, "application/vnd.ms-outlook");
            new OutlookExtractor(filesystem).parse(xhtml, metadata);
        }
        xhtml.endDocument();
    }

    public void parse(DocumentEntry entry, Metadata metadata) throws IOException, TikaException {
        try {
            PropertySet properties = new PropertySet(new DocumentInputStream(entry));
            if (properties.isSummaryInformation()) {
                this.parse(new SummaryInformation(properties), metadata);
            }
            if (properties.isDocumentSummaryInformation()) {
                this.parse(new DocumentSummaryInformation(properties), metadata);
            }
        }
        catch (NoPropertySetStreamException e) {
            throw new TikaException("Not a HPSF document", e);
        }
        catch (UnexpectedPropertySetTypeException e) {
            throw new TikaException("Unexpected HPSF document", e);
        }
        catch (MarkUnsupportedException e) {
            throw new TikaException("Invalid DocumentInputStream", e);
        }
    }

    private void parse(SummaryInformation summary, Metadata metadata) {
        this.set(metadata, "title", summary.getTitle());
        this.set(metadata, "Author", summary.getAuthor());
        this.set(metadata, "Keywords", summary.getKeywords());
        this.set(metadata, "subject", summary.getSubject());
        this.set(metadata, "Last-Author", summary.getLastAuthor());
        this.set(metadata, "Comments", summary.getComments());
        this.set(metadata, "Template", summary.getTemplate());
        this.set(metadata, "Application-Name", summary.getApplicationName());
        this.set(metadata, "Revision-Number", summary.getRevNumber());
        this.set(metadata, "Creation-Date", summary.getCreateDateTime());
        this.set(metadata, "Character Count", summary.getCharCount());
        this.set(metadata, "Edit-Time", summary.getEditTime());
        this.set(metadata, "Last-Save-Date", summary.getLastSaveDateTime());
        this.set(metadata, "Page-Count", summary.getPageCount());
        this.set(metadata, "Security", summary.getSecurity());
        this.set(metadata, "Word-Count", summary.getWordCount());
        this.set(metadata, "Last-Printed", summary.getLastPrinted());
    }

    private void parse(DocumentSummaryInformation summary, Metadata metadata) {
        this.set(metadata, "Company", summary.getCompany());
        this.set(metadata, "Manager", summary.getManager());
        this.set(metadata, "language", this.getLanguage(summary));
        this.set(metadata, "Category", summary.getCategory());
    }

    private String getLanguage(DocumentSummaryInformation summary) {
        Object value;
        CustomProperties customProperties = summary.getCustomProperties();
        if (customProperties != null && (value = customProperties.get("Language")) instanceof String) {
            return (String)value;
        }
        return null;
    }

    private void setType(Metadata metadata, String type) {
        metadata.set("Content-Type", type);
    }

    private void set(Metadata metadata, String name, String value) {
        if (value != null) {
            metadata.set(name, value);
        }
    }

    private void set(Metadata metadata, String name, Date value) {
        if (value != null) {
            metadata.set(name, value.toString());
        }
    }

    private void set(Metadata metadata, String name, long value) {
        if (value > 0L) {
            metadata.set(name, Long.toString(value));
        }
    }

    private void addTextIfAny(XHTMLContentHandler xhtml, String section, String text) throws SAXException {
        if (text != null && text.length() > 0) {
            xhtml.startElement("div", "class", section);
            xhtml.element("p", text);
            xhtml.endElement("div");
        }
    }
}

