/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.gui;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.tika.gui.ParsingTransferHandler;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.apache.tika.sax.TeeContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TikaGUI
extends JFrame {
    private final Parser parser;
    private final JTabbedPane tabs;
    private final JEditorPane html;
    private final JEditorPane text;
    private final JEditorPane xml;
    private final JEditorPane metadata;
    private final JEditorPane errors;

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new TikaGUI(new AutoDetectParser()).setVisible(true);
            }
        });
    }

    public TikaGUI(Parser parser) {
        super("Apache Tika");
        this.setDefaultCloseOperation(3);
        this.tabs = new JTabbedPane();
        this.add(this.tabs);
        this.html = this.createEditor("Formatted text", "text/html");
        this.text = this.createEditor("Plain text", "text/plain");
        this.xml = this.createEditor("Structured text", "text/plain");
        this.metadata = this.createEditor("Metadata", "text/plain");
        this.errors = this.createEditor("Errors", "text/plain");
        this.setPreferredSize(new Dimension(500, 400));
        this.pack();
        this.parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importStream(InputStream input) throws IOException {
        try {
            StringWriter htmlBuffer = new StringWriter();
            StringWriter textBuffer = new StringWriter();
            StringWriter xmlBuffer = new StringWriter();
            StringBuilder metadataBuffer = new StringBuilder();
            TeeContentHandler handler = new TeeContentHandler(this.getHtmlHandler(htmlBuffer), this.getTextContentHandler(textBuffer), this.getXmlContentHandler(xmlBuffer));
            Metadata md = new Metadata();
            input = new ProgressMonitorInputStream(this, "Parsing stream", input);
            this.parser.parse(input, handler, md);
            Object[] names = md.names();
            Arrays.sort(names);
            for (Object name : names) {
                metadataBuffer.append((String)name);
                metadataBuffer.append(": ");
                metadataBuffer.append(md.get((String)name));
                metadataBuffer.append("\n");
            }
            this.setText(this.errors, "");
            this.setText(this.metadata, metadataBuffer.toString());
            this.setText(this.xml, xmlBuffer.toString());
            this.setText(this.text, textBuffer.toString());
            this.setText(this.html, htmlBuffer.toString());
            this.tabs.setSelectedIndex(0);
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.setText(this.errors, writer.toString());
            this.setText(this.metadata, "");
            this.setText(this.xml, "");
            this.setText(this.text, "");
            this.setText(this.html, "");
            this.tabs.setSelectedIndex(this.tabs.getTabCount() - 1);
            JOptionPane.showMessageDialog(this, "Apache Tika was unable to parse the file or url.\n  See the errors tab for the detailed stack trace of this error.", "Parse error", 0);
        }
        finally {
            input.close();
        }
    }

    private JEditorPane createEditor(String title, String type) {
        JEditorPane editor = new JEditorPane();
        editor.setContentType(type);
        editor.setTransferHandler(new ParsingTransferHandler(editor.getTransferHandler(), this));
        this.tabs.add(title, new JScrollPane(editor));
        return editor;
    }

    private void setText(JEditorPane editor, String text) {
        editor.setText(text);
        editor.setCaretPosition(0);
    }

    private ContentHandler getHtmlHandler(Writer writer) throws TransformerConfigurationException {
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("method", "html");
        handler.setResult(new StreamResult(writer));
        return new ContentHandlerDecorator(handler){

            public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
                if ("http://www.w3.org/1999/xhtml".equals(uri)) {
                    uri = null;
                }
                if (!"head".equals(localName)) {
                    super.startElement(uri, localName, name, atts);
                }
            }

            public void endElement(String uri, String localName, String name) throws SAXException {
                if ("http://www.w3.org/1999/xhtml".equals(uri)) {
                    uri = null;
                }
                if (!"head".equals(localName)) {
                    super.endElement(uri, localName, name);
                }
            }

            public void startPrefixMapping(String prefix, String uri) {
            }

            public void endPrefixMapping(String prefix) {
            }
        };
    }

    private ContentHandler getTextContentHandler(Writer writer) {
        return new BodyContentHandler(writer);
    }

    private ContentHandler getXmlContentHandler(Writer writer) throws TransformerConfigurationException {
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("method", "xml");
        handler.setResult(new StreamResult(writer));
        return handler;
    }
}

