/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesFactory;
import org.apache.tika.parser.DelegatingParser;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TikaConfig {
    public static final String DEFAULT_CONFIG_LOCATION = "/org/apache/tika/tika-config.xml";
    private final Map<String, Parser> parsers = new HashMap<String, Parser>();
    private static MimeTypes mimeTypes;

    public TikaConfig(String file) throws TikaException, IOException, SAXException {
        this(new File(file));
    }

    public TikaConfig(File file) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(file));
    }

    public TikaConfig(URL url) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(url.toString()));
    }

    public TikaConfig(InputStream stream) throws TikaException, IOException, SAXException {
        this(stream, null);
    }

    public TikaConfig(InputStream stream, Parser delegate) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(stream), delegate);
    }

    public TikaConfig(Document document) throws TikaException, IOException {
        this(document, null);
    }

    public TikaConfig(Document document, Parser delegate) throws TikaException, IOException {
        this(document.getDocumentElement(), delegate);
    }

    public TikaConfig(Element element) throws TikaException, IOException {
        this(element, null);
    }

    public TikaConfig(Element element, Parser delegate) throws TikaException, IOException {
        Element mtr = TikaConfig.getChild(element, "mimeTypeRepository");
        if (mtr != null) {
            mimeTypes = MimeTypesFactory.create(mtr.getAttribute("resource"));
        }
        NodeList nodes = element.getElementsByTagName("parser");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node = (Element)nodes.item(i);
            String name = node.getAttribute("class");
            try {
                Class<?> parserClass = Class.forName(name);
                Parser parser = (Parser)parserClass.newInstance();
                if (delegate != null && parser instanceof DelegatingParser) {
                    ((DelegatingParser)parser).setDelegate(delegate);
                }
                NodeList mimes = node.getElementsByTagName("mime");
                for (int j = 0; j < mimes.getLength(); ++j) {
                    this.parsers.put(this.getText(mimes.item(j)).trim(), parser);
                }
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    private String getText(Node node) {
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        if (node.getNodeType() == 1) {
            StringBuilder builder = new StringBuilder();
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                builder.append(this.getText(list.item(i)));
            }
            return builder.toString();
        }
        return "";
    }

    public Parser getParser(String mimeType) {
        return this.parsers.get(mimeType);
    }

    public Map<String, Parser> getParsers() {
        return this.parsers;
    }

    public MimeTypes getMimeRepository() {
        return mimeTypes;
    }

    public static TikaConfig getDefaultConfig() throws TikaException {
        return TikaConfig.getDefaultConfig(new EmptyParser());
    }

    public static TikaConfig getDefaultConfig(Parser delegate) throws TikaException {
        try {
            InputStream stream = TikaConfig.class.getResourceAsStream(DEFAULT_CONFIG_LOCATION);
            return new TikaConfig(stream, delegate);
        }
        catch (IOException e) {
            throw new TikaException("Unable to read default configuration", e);
        }
        catch (SAXException e) {
            throw new TikaException("Unable to parse default configuration", e);
        }
    }

    private static DocumentBuilder getBuilder() throws TikaException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new TikaException("XML parser not available", e);
        }
    }

    private static Element getChild(Element element, String name) {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !name.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }
}

